package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.model.*;
import com.digiwin.athena.apimgmt.service.util.*;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ApiMgmtApiSaveAndReviewVerifyProcessor {

    /**
     * 检查范例值规范
     *
     * @param pApiDataNameCheckResult pApiDataNameCheckResult
     * @param pAddDataName            pAddDataName
     */
    public void checkListEnum(List<Map<String, String>> pApiDataNameCheckResult,
                              Map<String, StandardApiDataName> pAddDataName) {
        Map<String, String> tReqErrorLog = new HashMap<>();
        Map<String, String> tResSuccessErrorLog = new HashMap<>();
        Map<String, String> tResFailedErrorLog = new HashMap<>();
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageServiceUtil.getMsgTypeMap(pAddDataName);
        List<StandardApiDataName> tAddRequest = tMsgTypeMap.get(1);
        List<StandardApiDataName> tAddResponseSuccess = tMsgTypeMap.get(2);
        List<StandardApiDataName> tAddResponseFailed = tMsgTypeMap.get(3);
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkListEnum(tAddRequest);
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkListEnum(tAddResponseSuccess);
        StringBuilder tResFailedRequiredDataName = ValidateApiDataNameServiceUtil.checkListEnum(tAddResponseFailed);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request信息內容列舉值格式錯誤字段：" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success信息內容列舉值格式錯誤字段：" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
        if (!tResFailedRequiredDataName.toString().equals("")) {
            tResFailedErrorLog.put("description", "Response success信息內容列舉值格式錯誤字段：" + tResFailedRequiredDataName);
            pApiDataNameCheckResult.add(tResFailedErrorLog);
        }
    }

    /**
     * 检测dataKey(可搜索)属性是否为y
     *
     * @param pApiDataNameCheckResult pApiDataNameCheckResult
     * @param pAddDataName            pAddDataName
     */
    public void checkDataKey(List<Map<String, String>> pApiDataNameCheckResult,
                             Map<String, StandardApiDataName> pAddDataName) {
        Map<String, String> tReqErrorLog = new HashMap<>();
        Map<String, String> tResSuccessErrorLog = new HashMap<>();
        Map<String, String> tResFailedErrorLog = new HashMap<>();
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageServiceUtil.getMsgTypeMap(pAddDataName);
        List<StandardApiDataName> tAddRequest = tMsgTypeMap.get(1);
        List<StandardApiDataName> tAddResponseSuccess = tMsgTypeMap.get(2);
        List<StandardApiDataName> tAddResponseFailed = tMsgTypeMap.get(3);
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkDatakey(tAddRequest);
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkDatakey(tAddResponseSuccess);
        StringBuilder tResFailedRequiredDataName = ValidateApiDataNameServiceUtil.checkDatakey(tAddResponseFailed);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request信息內容「datakey」欄位不可為Y的字段：" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success信息內容「datakey」欄位不可為Y的字段：" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
        if (!tResFailedRequiredDataName.toString().equals("")) {
            tResFailedErrorLog.put("description", "Response success信息內容「datakey」欄位不可為Y的字段：" + tResFailedRequiredDataName);
            pApiDataNameCheckResult.add(tResFailedErrorLog);
        }
    }

    /**
     * 检查必填项
     *
     * @param pApiDataNameCheckResult pApiDataNameCheckResult
     * @param pAddDataName            pAddDataName
     */
    public void checkRequiredDataName(List<Map<String, String>> pApiDataNameCheckResult,
                                      Map<String, StandardApiDataName> pAddDataName) {
        Map<String, String> tReqErrorLog = new HashMap<>();
        Map<String, String> tResSuccessErrorLog = new HashMap<>();
        Map<String, String> tResFailedErrorLog = new HashMap<>();
        // 入参所需要检测的字段，暂无
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(
                ApimgmtConstant.REQ_CHECK_REQUIRED_DATA_NAME, ApimgmtConstant.REQ_REQUIRED_DATA_NAME, pAddDataName);
        // 成功出参所需要检测的字段
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(
                ApimgmtConstant.RES_CHECK_SUCCESS_REQUIRED_DATA_NAME, ApimgmtConstant.RES_SUCCESS_REQUIRED_DATA_NAME, pAddDataName);
        // 失败出参所需要检测的字段
        StringBuilder tResFailedRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(
                ApimgmtConstant.RES_CHECK_FAIL_REQUIRED_DATA_NAME, ApimgmtConstant.RES_FAIL_REQUIRED_DATA_NAME, pAddDataName);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request信息內容缺少必要字段：" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success信息內容缺少必要字段：" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }
        if (!tResFailedRequiredDataName.toString().equals("")) {
            tResFailedErrorLog.put("description", "Response failed信息內容缺少必要字段：" + tResFailedRequiredDataName);
            pApiDataNameCheckResult.add(tResFailedErrorLog);
        }
    }

    /**
     * 检测分页必填项
     *
     * @param pApiDataNameCheckResult pApiDataNameCheckResult
     * @param pAddDataName            pAddDataName
     */
    public void checkPagingRequiredDataName(List<Map<String, String>> pApiDataNameCheckResult,
                                            Map<String, StandardApiDataName> pAddDataName) {
        Map<String, String> tReqErrorLog = new HashMap<>();
        Map<String, String> tResSuccessErrorLog = new HashMap<>();
        // 入参分页所需要检测的字段
        StringBuilder tReqRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(
                ApimgmtConstant.REQ_CHECK_PAGING_REQUIRED_DATA_NAME, ApimgmtConstant.REQ_CHECK_PAGING_DATA_NAME, pAddDataName);
        // 出参分页所成功需要检测的字段
        StringBuilder tResSuccessRequiredDataName = ValidateApiDataNameServiceUtil.checkRequiredDataName(
                ApimgmtConstant.RES_SUCCESS_CHECK_PAGING_REQUIRED_DATA_NAME, ApimgmtConstant.RES_SUCCESS_CHECK_PAGING_DATA_NAME, pAddDataName);
        if (!tReqRequiredDataName.toString().equals("")) {
            tReqErrorLog.put("description", "Request信息內容缺少必要字段：" + tReqRequiredDataName);
            pApiDataNameCheckResult.add(tReqErrorLog);
        }
        if (!tResSuccessRequiredDataName.toString().equals("")) {
            tResSuccessErrorLog.put("description", "Response success信息內容缺少必要字段：" + tResSuccessRequiredDataName);
            pApiDataNameCheckResult.add(tResSuccessErrorLog);
        }

    }

    /**
     * 检测是否可为数组
     *
     * @param pApiDataNameCheckResult pApiDataNameCheckResult
     * @param pAddDataName            pAddDataName
     */
    public void checkIsArrayCannotBeY(List<Map<String, String>> pApiDataNameCheckResult,
                                      Map<String, StandardApiDataName> pAddDataName) {
        Map<String, String> tErrorLog = new HashMap<>();
        // 匯入的Req、Res(成功)、Res(失敗)字段
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap2 = StandardApiMessageServiceUtil.getMsgTypeMap(pAddDataName);
        List<StandardApiDataName> tAddRequest = tMsgTypeMap2.get(1);
        List<StandardApiDataName> tAddResponseSuccess = tMsgTypeMap2.get(2);
        List<StandardApiDataName> tAddResponseFailed = tMsgTypeMap2.get(3);
        // 原除M、D、SD、4D、5D...之外，「為數組」不可為Y
        // 2022-03-11 Lillian 改為H、DATAKEY、P和E「為數組」不可為Y
        // 2023-02-04 Lillian P改為允許「為數組」為Y
        StringBuilder tReqIsArrayCannotBeY = ValidateApiDataNameServiceUtil.isArrayCannotBeY(tAddRequest);
        StringBuilder tResSuccessIsArrayCannotBeY = ValidateApiDataNameServiceUtil.isArrayCannotBeY(tAddResponseSuccess);
        StringBuilder tResFailedIsArrayCannotBeY = ValidateApiDataNameServiceUtil.isArrayCannotBeY(tAddResponseFailed);
        if (!tReqIsArrayCannotBeY.toString().equals("")) {
            tErrorLog.put("description", "Request信息內容「為數組」欄位不可為Y的字段：" + tReqIsArrayCannotBeY);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResSuccessIsArrayCannotBeY.toString().equals("")) {
            tErrorLog.put("description", "Response success信息內容「為數組」欄位不可為Y的字段：" + tResSuccessIsArrayCannotBeY);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResFailedIsArrayCannotBeY.toString().equals("")) {
            tErrorLog.put("description", "Response failed信息內容「為數組」欄位不可為Y的字段：" + tResFailedIsArrayCannotBeY);
            pApiDataNameCheckResult.add(tErrorLog);
        }
    }

    /**
     * 檢查前一版字段
     *
     * @param pApiDataNameCheckResult pApiDataNameCheckResult
     * @param pPreviApiDataName       pPreviApiDataName
     * @param pAddDataName            pAddDataName
     */
    public void compareDataName(List<Map<String, String>> pApiDataNameCheckResult, List<StandardApiDataName> pPreviApiDataName,
                                Map<String, StandardApiDataName> pAddDataName) {
        Map<String, String> tErrorLog = new HashMap<>();
        // 前一版的Req、Res(成功)、Res(失敗)字段
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageUtil.getMsgTypeMap(pPreviApiDataName);
        List<StandardApiDataName> tPreviRequest = tMsgTypeMap.get(1);
        List<StandardApiDataName> tPreviResponseSuccess = tMsgTypeMap.get(2);
        List<StandardApiDataName> tPreviResponseFailed = tMsgTypeMap.get(3);
        // 檢查前一版「為數組」欄位是否為Y，是的話匯入該字段不可為N
        StringBuilder tReqIsArrayDataName = ValidateApiDataNameServiceUtil.checkIsArray(tPreviRequest, pAddDataName);
        StringBuilder tResSuccessIsArrayDataName = ValidateApiDataNameServiceUtil.checkIsArray(tPreviResponseSuccess, pAddDataName);
        StringBuilder tResFailedIsArrayDataName = ValidateApiDataNameServiceUtil.checkIsArray(tPreviResponseFailed, pAddDataName);
        if (!tReqIsArrayDataName.toString().equals("")) {
            tErrorLog.put("description", "Request信息內容「為數組」欄位不可為N的字段：" + tReqIsArrayDataName);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResSuccessIsArrayDataName.toString().equals("")) {
            tErrorLog.put("description", "Response success信息內容「為數組」欄位不可為N的字段：" + tResSuccessIsArrayDataName);
            pApiDataNameCheckResult.add(tErrorLog);
        }
        if (!tResFailedIsArrayDataName.toString().equals("")) {
            tErrorLog.put("description", "Response failed信息內容「為數組」欄位不可為N的字段：" + tResFailedIsArrayDataName);
            pApiDataNameCheckResult.add(tErrorLog);
        }
    }
}
