package com.digiwin.athena.apimgmt.validator;

import java.util.Scanner;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.exception.JsonFormatValidationException;
import com.digiwin.athena.apimgmt.exception.JsonSyntaxValidationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;

public class JsonSchemaValidator {

	/**
	 * 请求体验证
	 * @param pMessage pMessage
	 * @param pSchemaFileName pSchemaFileName
	 * @return ValidatorResult
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	public ValidatorResult validate(String pMessage, String pSchemaFileName) throws BaseException, Exception {
		ValidatorResult tResult = new ValidatorResult();
		try {
			// 根據檔案名稱取得驗證綱要
			Scanner reader = new Scanner(getClass().getResourceAsStream("/schema/" + pSchemaFileName));
			StringBuilder builder = new StringBuilder();
			while (reader.hasNextLine()) {
				builder.append(reader.nextLine());
			}
			String jsonSchema = builder.toString();
			reader.close();
			JsonNode schemaNode = JsonLoader.fromString(jsonSchema);
			JsonNode jsonNode = JsonLoader.fromString(pMessage);
			ProcessingReport report = JsonSchemaFactory.byDefault().getValidator().validateUnchecked(schemaNode,
					jsonNode);
			// 驗證成功
			if (report.isSuccess()) {
				tResult.setState(ValidateStateEnum.SUCCESS);
				// 回傳解析完的JSON_CONTENT
				tResult.setJsonContent(jsonNode);
				return tResult;
				// 驗證失敗
			} else {
				for (ProcessingMessage processMessage : report) {
					if (!LogLevel.WARNING.equals(processMessage.getLogLevel())) {
						tResult.setState(ValidateStateEnum.FORMAT_ERROR);
						// 取得發生錯誤的節點路徑
						JsonNode instanceNode = processMessage.asJson().get(ApimgmtConstant.INSTANCE).get(ApimgmtConstant.POINTER);
						tResult.setErrorNodePath(instanceNode.toString().replace("\"", ""));
						// 取得錯誤訊息
//						JsonNode schema = processMessage.asJson().get("schema");
//						if (schema != null && schema.has("description")) {
//							tResult.setMessage(schema.get("description").asText());
//						} else {
//							tResult.setMessage(processMessage.getMessage().replace("\"", ""));
//						}
						tResult.setMessage(processMessage.getMessage().replace("\"", ""));
						throw new JsonFormatValidationException(
								tResult.getMessage() + ApimgmtConstant.AT_STRING + tResult.getErrorNodePath(), this.getClass());
					}
				}
				throw new JsonFormatValidationException(this.getClass());
			}
		} catch (JsonParseException e) {
			throw new JsonSyntaxValidationException(e, this.getClass());
		}
	}
}
