/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.facade;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.facade.IApiInfoFacadeService;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiInfoFacadeService
implements IApiInfoFacadeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiInfoFacadeService.class);
    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) throws Exception {
        if (CollUtil.isEmpty(apiKeys)) {
            return new ArrayList<ApiMgmtApiInfoDTO>();
        }
        String queryJson = this.buildQueryJson(apiKeys);
        log.info("Query API by keys, json: {}", (Object)queryJson);
        Map<String, Object> resultMap = this.advanceSearchApiListGetOtherService.execute(queryJson);
        return this.convertToApiInfoDTOList(resultMap);
    }

    private String buildQueryJson(List<ApiMgmtApiKeyDTO> apiKeys) {
        ObjectNode rootNode = this.mapper.createObjectNode();
        ArrayNode conditionList = this.mapper.createArrayNode();
        int order = 0;
        for (int i = 0; i < apiKeys.size(); ++i) {
            ApiMgmtApiKeyDTO key = apiKeys.get(i);
            String mark = i == 0 ? "and" : "or";
            String openBracket = "(";
            String closeBracket = ")";
            ObjectNode apiNameNode = this.mapper.createObjectNode();
            apiNameNode.put("condition", "apiName");
            apiNameNode.put("equation", "=");
            apiNameNode.put("content", key.getApiName());
            apiNameNode.put("mark", mark);
            apiNameNode.put("order", order++);
            apiNameNode.put("bracket", openBracket);
            conditionList.add((JsonNode)apiNameNode);
            if (key.getBranch() != null) {
                ObjectNode apiVersionNode = this.mapper.createObjectNode();
                apiVersionNode.put("condition", "apiBranch");
                apiVersionNode.put("equation", "=");
                apiVersionNode.put("content", key.getBranch());
                apiVersionNode.put("mark", "and");
                apiVersionNode.put("order", order++);
                apiVersionNode.put("bracket", "");
                conditionList.add((JsonNode)apiVersionNode);
            }
            if (key.getApplication() != null) {
                ObjectNode tenantIdNode = this.mapper.createObjectNode();
                tenantIdNode.put("condition", "tenantId");
                tenantIdNode.put("equation", "=");
                tenantIdNode.put("content", key.getApplication());
                tenantIdNode.put("mark", "and");
                tenantIdNode.put("order", order++);
                tenantIdNode.put("bracket", closeBracket);
                conditionList.add((JsonNode)tenantIdNode);
                continue;
            }
            if (key.getBranch() != null) {
                ObjectNode lastNode = (ObjectNode)conditionList.get(conditionList.size() - 1);
                lastNode.put("bracket", closeBracket);
                continue;
            }
            apiNameNode.put("bracket", "");
        }
        rootNode.set("conditionList", (JsonNode)conditionList);
        rootNode.put("type", false);
        rootNode.put("statusId", "");
        rootNode.put("pageSize", apiKeys.size());
        rootNode.put("pageNum", 1);
        return rootNode.toString();
    }

    private List<ApiMgmtApiInfoDTO> convertToApiInfoDTOList(Map<String, Object> resultMap) {
        ArrayList<ApiMgmtApiInfoDTO> result = new ArrayList<ApiMgmtApiInfoDTO>();
        if (resultMap == null || !resultMap.containsKey("value")) {
            return result;
        }
        List valueList = (List)resultMap.get("value");
        if (CollUtil.isEmpty((Collection)valueList)) {
            return result;
        }
        for (Map map : valueList) {
            ApiMgmtApiInfoDTO dto = ApiMgmtApiInfoDTO.builder().apiId(this.getLong(map, "apiId")).name(this.getString(map, "name")).version(this.getString(map, "version")).approvedStatus(this.getString(map, "approvedStatus")).approvedTime(this.getString(map, ApiAttributeEnum.approvedTime.toString())).approvedStatusCode(this.getLong(map, "approvedStatusCode")).description(this.getString(map, "description")).remark(this.getString(map, "remark")).syncType(this.getString(map, "syncType")).categoryId(this.getLong(map, "categoryId")).categoryName(this.getString(map, "categoryName")).msgFormat(this.getString(map, "msgFormat")).requester(this.getString(map, "requester")).provider(this.getString(map, "provider")).tenantId(this.getString(map, "tenantId")).apiBuildAcct(this.getString(map, "apiBuildAcct")).apiBuildTime(this.getString(map, "apiBuildTime")).designTenantId(this.getString(map, "designTenantId")).teamId(this.getString(map, "teamId")).statusId(this.getLong(map, "statusId")).apiType(this.getString(map, "apiType")).projectName(this.getString(map, "projectName")).projectHasVersions(this.getBoolean(map, "hasVersions")).projectVersionNameList(this.getList(map, "projectVersionNameList")).projectVersionNameListStr(this.getString(map, "projectVersionNameListStr")).firstApplicant(this.getString(map, "firstApplicant")).lastApplicant(this.getString(map, "lastApplicant")).build();
            result.add(dto);
        }
        return result;
    }

    private String getString(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value != null ? value.toString() : null;
    }

    private Long getLong(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Boolean getBoolean(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private List<String> getList(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return null;
    }
}

