/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiGroup;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import jakarta.annotation.Nonnull;
import java.beans.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@TableName(value="standard_api", resultMap="StandardApiResultMap")
public class StandardApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(value="build_acct")
    private String buildAcct;
    @TableField(value="build_time")
    private LocalDateTime buildTime;
    @TableField(value="description_en_us")
    private String descriptionEnUs;
    @TableField(value="description_zh_cn")
    private String descriptionZhCn;
    @TableField(value="description_zh_tw")
    private String descriptionZhTw;
    private String name;
    private String provider;
    @TableField(value="remark_en_us")
    private String remarkEnUs;
    @TableField(value="remark_zh_cn")
    private String remarkZhCn;
    @TableField(value="remark_zh_tw")
    private String remarkZhTw;
    private String requester;
    @TableField(value="tag_en_us")
    private String tagEnUs;
    @TableField(value="tag_zh_cn")
    private String tagZhCn;
    @TableField(value="tag_zh_tw")
    private String tagZhTw;
    @TableField(value="is_batch")
    private Boolean isBatch;
    @TableField(value="msg_m_data")
    private Boolean msgMdata = true;
    @TableField(value="msg_format")
    private String msgFormat;
    @TableField(value="tenant_id")
    private String tenantId = "";
    @TableField(value="package_name")
    private String packageName;
    @TableField(exist=false)
    private StandardApiGroup standardApiGroup;
    @TableField(exist=false)
    private StandardApiSyncType standardApiSyncType;
    @TableField(exist=false)
    private StandardApiPaging standardApiPaging;
    @TableField(exist=false)
    private StandardApiCategory standardApiCategory;
    @TableField(exist=false)
    private List<StandardApiVersion> standardApiVersions = new ArrayList<StandardApiVersion>();
    @TableField(exist=false)
    private Long projectId;
    @TableField(exist=false)
    private List<Long> projectVersion;
    @TableField(value="design_tenant_id")
    private String designTenantId;
    @TableField(value="team_id")
    private String teamId;
    @TableField(value="team_type")
    private String teamType;
    @TableField(value="parent_api_name")
    private String parentApiName;
    @TableField(value="parent_branch")
    private String parentBranch;
    @TableField(value="parent_api_tenant_id")
    private String parentApiTenantId;
    @TableField(value="api_extend")
    private String apiExtend;
    @TableField(value="first_applicant")
    private String firstApplicant;
    @TableField(value="api_type")
    private String apiType;
    @TableField(value="protocol")
    private String protocol;
    @TableField(value="request_method")
    private String requestMethod;
    @TableField(value="branch")
    private String branch;
    @TableField(value="api_path")
    private String apiPath;
    @TableField(exist=false)
    private List<ProjectVersionRelation> projectVersionRelations = new ArrayList<ProjectVersionRelation>();
    @TableField(exist=false)
    private String projectName;
    @TableField(exist=false)
    private List<String> projectVersionNameList;
    @TableField(exist=false)
    private Boolean hasVersions = false;

    public Boolean getBatch() {
        return this.isBatch;
    }

    public void setBatch(Boolean batch) {
        this.isBatch = batch;
    }

    public Boolean getHasVersions() {
        return this.hasVersions;
    }

    public void setHasVersions(Boolean hasVersions) {
        this.hasVersions = hasVersions;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<String> getProjectVersionNameList() {
        return this.projectVersionNameList;
    }

    public void setProjectVersionNameList(List<String> projectVersionNameList) {
        this.projectVersionNameList = projectVersionNameList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBuildAcct() {
        return this.buildAcct;
    }

    public void setBuildAcct(String buildAcct) {
        this.buildAcct = buildAcct;
    }

    public LocalDateTime getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(LocalDateTime buildTime) {
        this.buildTime = buildTime;
    }

    public String getDescriptionEnUs() {
        return this.descriptionEnUs;
    }

    public void setDescriptionEnUs(String descriptionEnUs) {
        this.descriptionEnUs = descriptionEnUs;
    }

    public String getDescriptionZhCn() {
        return this.descriptionZhCn;
    }

    public void setDescriptionZhCn(String descriptionZhCn) {
        this.descriptionZhCn = descriptionZhCn;
    }

    public String getDescriptionZhTw() {
        return this.descriptionZhTw;
    }

    public void setDescriptionZhTw(String descriptionZhTw) {
        this.descriptionZhTw = descriptionZhTw;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMsgFormat() {
        return this.msgFormat;
    }

    public void setMsgFormat(String msgFormat) {
        this.msgFormat = msgFormat;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getRemarkEnUs() {
        return this.remarkEnUs;
    }

    public void setRemarkEnUs(String remarkEnUs) {
        this.remarkEnUs = remarkEnUs;
    }

    public String getRemarkZhCn() {
        return this.remarkZhCn;
    }

    public void setRemarkZhCn(String remarkZhCn) {
        this.remarkZhCn = remarkZhCn;
    }

    public String getRemarkZhTw() {
        return this.remarkZhTw;
    }

    public void setRemarkZhTw(String remarkZhTw) {
        this.remarkZhTw = remarkZhTw;
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public String getTagEnUs() {
        return this.tagEnUs;
    }

    public void setTagEnUs(String tagEnUs) {
        this.tagEnUs = tagEnUs;
    }

    public String getTagZhCn() {
        return this.tagZhCn;
    }

    public void setTagZhCn(String tagZhCn) {
        this.tagZhCn = tagZhCn;
    }

    public String getTagZhTw() {
        return this.tagZhTw;
    }

    public void setTagZhTw(String tagZhTw) {
        this.tagZhTw = tagZhTw;
    }

    public Boolean getIsBatch() {
        return this.isBatch;
    }

    public void setIsBatch(Boolean isBatch) {
        this.isBatch = isBatch;
    }

    public Boolean getMsgMdata() {
        return this.msgMdata;
    }

    public void setMsgMdata(Boolean msgMdata) {
        this.msgMdata = msgMdata;
    }

    public StandardApiCategory getStandardApiCategory() {
        return this.standardApiCategory;
    }

    public void setStandardApiCategory(StandardApiCategory standardApiCategory) {
        this.standardApiCategory = standardApiCategory;
    }

    public StandardApiGroup getStandardApiGroup() {
        return this.standardApiGroup;
    }

    public void setStandardApiGroup(StandardApiGroup standardApiGroup) {
        this.standardApiGroup = standardApiGroup;
    }

    public StandardApiSyncType getStandardApiSyncType() {
        return this.standardApiSyncType;
    }

    public void setStandardApiSyncType(StandardApiSyncType standardApiSyncType) {
        this.standardApiSyncType = standardApiSyncType;
    }

    public StandardApiPaging getStandardApiPaging() {
        return this.standardApiPaging;
    }

    public void setStandardApiPaging(StandardApiPaging standardApiPaging) {
        this.standardApiPaging = standardApiPaging;
    }

    public List<StandardApiVersion> getStandardApiVersions() {
        return this.standardApiVersions;
    }

    public void setStandardApiVersions(List<StandardApiVersion> standardApiVersions) {
        this.standardApiVersions = standardApiVersions;
    }

    public StandardApiVersion addStandardApiVersion(StandardApiVersion standardApiVersion) {
        this.getStandardApiVersions().add(standardApiVersion);
        standardApiVersion.setStandardApi(this);
        return standardApiVersion;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenant_id) {
        this.tenantId = tenant_id;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String package_name) {
        this.packageName = package_name;
    }

    public String getDesignTenantId() {
        return this.designTenantId;
    }

    public void setDesignTenantId(String designTenantId) {
        this.designTenantId = designTenantId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getTeamType() {
        return this.teamType;
    }

    public void setTeamType(String teamType) {
        this.teamType = teamType;
    }

    public String getParentApiName() {
        return this.parentApiName;
    }

    public void setParentApiName(String parentApiName) {
        this.parentApiName = parentApiName;
    }

    public String getParentApiTenantId() {
        return this.parentApiTenantId;
    }

    public void setParentApiTenantId(String parentApiTenantId) {
        this.parentApiTenantId = parentApiTenantId;
    }

    public String getApiExtend() {
        return this.apiExtend;
    }

    public void setApiExtend(String apiExtend) {
        this.apiExtend = apiExtend;
    }

    public String getFirstApplicant() {
        return this.firstApplicant;
    }

    public void setFirstApplicant(String firstApplicant) {
        this.firstApplicant = firstApplicant;
    }

    public String getApiType() {
        return this.apiType;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public List<ProjectVersionRelation> getProjectVersionRelations() {
        return this.projectVersionRelations;
    }

    public void setProjectVersionRelations(List<ProjectVersionRelation> projectVersionRelations) {
        this.projectVersionRelations = projectVersionRelations;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public List<Long> getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(List<Long> projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getParentBranch() {
        return this.parentBranch;
    }

    public void setParentBranch(String parentBranch) {
        this.parentBranch = parentBranch;
    }

    @Transient
    public String getApiTypeOrDefault() {
        String apiType = this.getApiType();
        if (StrUtil.isBlank((CharSequence)apiType)) {
            return "esp";
        }
        return apiType;
    }

    public boolean validateName() {
        return StandardApi.validateName(this.getApiTypeOrDefault(), this.getName());
    }

    public static boolean validateName(@Nonnull String apiType, String apiName) {
        if (StrUtil.isBlank((CharSequence)apiName)) {
            return false;
        }
        if ("esp".equals(apiType)) {
            return ApimgmtConstant.PATTERN_API_NAME.matcher(apiName).matches();
        }
        if ("openapi".equals(apiType)) {
            return ApimgmtConstant.PATTERN_OPEN_API_NAME.matcher(apiName).matches();
        }
        return false;
    }

    public boolean validateBranch() {
        return ApimgmtConstant.PATTERN_BRANCH.matcher(this.getBranch()).matches();
    }
}

