/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.SyncTypeConstants;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiGroupDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiPagingDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiSyncTypeDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtWrongDescriptionDao;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.ColumnTypeEnum;
import com.digiwin.athena.apimgmt.enums.DataTypeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.Product;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiGroup;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import com.digiwin.athena.apimgmt.model.WrongDescription;
import com.digiwin.athena.apimgmt.service.model.ParseExcelHelper;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ProjectVersionServiceUtil;
import com.digiwin.athena.apimgmt.services.AbstractService;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardApiFileReadService
extends AbstractService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiFileReadService.class);
    @Autowired
    ApiMgmtStandardApiCategoryDao standarAPICategoryDao;
    @Autowired
    ApiMgmtStandardApiGroupDao standardApiGroupDao;
    @Autowired
    ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;
    @Autowired
    ApiMgmtStandardApiPagingDao standardApiPagingDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApimgmtProductDao productDao;
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;
    @Autowired
    ApiMgmtWrongDescriptionDao wrongDescriptionDao;
    @Autowired
    private ApiMgmtApiVersionService apiVersionService;
    @Autowired
    private ApiMgmtProjectDao projectDao;
    @Autowired
    private ApiMgmtProjectVersionDao projectVersionDao;
    @Autowired
    private ApiMgmtProp prop;

    public Workbook getWorkBook(String pFileType, InputStream pFileIn) throws IOException {
        XSSFWorkbook tWorkbook = null;
        if (pFileType.equals("xls")) {
            POIFSFileSystem tPOIFSFileSystem = new POIFSFileSystem(pFileIn);
            tWorkbook = new HSSFWorkbook(tPOIFSFileSystem);
        } else if (pFileType.equals("xlsx")) {
            tWorkbook = new XSSFWorkbook(pFileIn);
        }
        return tWorkbook;
    }

    public List<Map<String, String>> setStandardApi(StandardApi pStandardApi, String pApplicant, Sheet pSheet, String pLocale) throws Exception {
        int tRowNumber = 0;
        int tColumnNumber = 1;
        StandardApiGroup tStandardApiGroup = null;
        StandardApiCategory tStandardApiCategory = null;
        StandardApiPaging tStandardApiPaging = null;
        String tTagZhTW = null;
        String tDescriptionZhTW = null;
        String tDescriptionZhCN = null;
        String tRemarkZhTW = null;
        String tRemarkZhCN = null;
        StandardApiVersion tStandardApiVersion = new StandardApiVersion();
        ArrayList<Map<String, String>> tResult = new ArrayList<Map<String, String>>();
        int offset = 1;
        Row tRow = pSheet.getRow(tRowNumber);
        if (tRow == null || tRow.getCell(1, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL) == null || !tRow.getCell(1).getStringCellValue().equals("StandardAPI")) {
            this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_SHEET_FORMAT.toString(), null, null, tRowNumber, tColumnNumber, pLocale);
            return tResult;
        }
        tRowNumber = 2;
        tRow = pSheet.getRow(tRowNumber);
        Cell tCell = tRow.getCell(tColumnNumber = 24, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            pStandardApi.setApiType("esp");
        } else {
            pStandardApi.setApiType(ApiTypeConstants.getCodeByName((String)tCell.toString()));
        }
        tColumnNumber = 1;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 1L, null, tRowNumber, tColumnNumber, pLocale);
            return tResult;
        }
        String tApiName = tCell.toString().trim();
        pStandardApi.setName(tApiName);
        tColumnNumber = 2;
        boolean tDescriptionZhTwEmpty = false;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tDescriptionZhTwEmpty = true;
        } else {
            tDescriptionZhTW = tCell.toString().trim();
            pStandardApi.setDescriptionZhTw(tDescriptionZhTW);
        }
        tColumnNumber = 3;
        boolean tDescriptionZhCnEmpty = false;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tDescriptionZhCnEmpty = true;
        } else {
            tDescriptionZhCN = tCell.toString().trim();
            pStandardApi.setDescriptionZhCn(tDescriptionZhCN);
        }
        if (tDescriptionZhTwEmpty && tDescriptionZhCnEmpty) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 3L, null, tRowNumber, tColumnNumber, pLocale);
        } else if (tDescriptionZhTwEmpty) {
            tDescriptionZhTW = this.localeTranslate(tDescriptionZhCN, LocaleEnum.ZH2HANT.getType());
            pStandardApi.setDescriptionZhTw(tDescriptionZhTW);
        } else if (tDescriptionZhCnEmpty) {
            tDescriptionZhCN = this.localeTranslate(tDescriptionZhTW, LocaleEnum.ZH2HANS.getType());
            pStandardApi.setDescriptionZhCn(tDescriptionZhCN);
        }
        tColumnNumber = 4;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            pStandardApi.setDescriptionEnUs(tDescriptionZhTW);
        } else {
            String tDescriptionEnUS = tCell.toString().trim();
            pStandardApi.setDescriptionEnUs(tDescriptionEnUS);
        }
        tColumnNumber = 5;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 5L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tVersion = tCell.toString().trim();
            if (!tVersion.matches("\\d+\\.\\d+")) {
                this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 6L, null, tRowNumber, tColumnNumber, pLocale);
            } else {
                pStandardApi.addStandardApiVersion(tStandardApiVersion);
                pStandardApi.setBranch(ApiVersionServiceUtil.getBranchFromVersion(tVersion));
                tStandardApiVersion.setStandardApi(pStandardApi);
                tStandardApiVersion.setVersion(tVersion);
                tStandardApiVersion.setApplicant(pApplicant);
                ApprovedStatus approvedStatus = (ApprovedStatus)this.approvedStatusDao.get(1L);
                tStandardApiVersion.setApprovedStatus(approvedStatus);
            }
        }
        tColumnNumber = 6;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 7L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tCellValue = tCell.toString().trim();
            Long tSyncTypeId = SyncTypeConstants.getCodeByName((String)tCellValue);
            if (-1L == tSyncTypeId) {
                this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 8L, null, tRowNumber, tColumnNumber, pLocale);
            } else {
                StandardApiSyncType tStandardApiSyncType = (StandardApiSyncType)this.standardApiSyncTypeDao.get(tSyncTypeId);
                pStandardApi.setStandardApiSyncType(tStandardApiSyncType);
            }
        }
        tColumnNumber = 7;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 9L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tPagingValue = tCell.toString().trim();
            if (!tPagingValue.matches("[\\d]{1,3}[.].*")) {
                this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 10L, null, tRowNumber, tColumnNumber, pLocale);
            } else {
                try {
                    tStandardApiPaging = (StandardApiPaging)this.standardApiPagingDao.get(Long.valueOf(tPagingValue.substring(0, tPagingValue.indexOf("."))));
                    Long tPaging = tStandardApiPaging.getId();
                    if (pStandardApi.getApiType().equals("esp") && !tApiName.endsWith(".get") && tPaging != 1L) {
                        this.uploadCheckResult(tResult, APIExportImportEnums.CAN_NOT_PAGING.toString(), 11L, null, tRowNumber, tColumnNumber, pLocale);
                    }
                }
                catch (Exception e) {
                    this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 10L, null, tRowNumber, tColumnNumber, pLocale);
                }
                pStandardApi.setStandardApiPaging(tStandardApiPaging);
            }
        }
        tColumnNumber = 8;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 12L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tRequester = tCell.toString().replaceAll("[ |\u3000]", "");
            pStandardApi.setRequester(tRequester);
        }
        tColumnNumber = 9;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 13L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tProvider = tCell.toString().replaceAll("[ |\u3000]", "");
            pStandardApi.setProvider(tProvider);
        }
        tColumnNumber = 10;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 14L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            boolean tIsBatch = "Y".equals(tCell.toString());
            if (!tApiName.endsWith(".get") && tIsBatch) {
                this.uploadCheckResult(tResult, APIExportImportEnums.CAN_NOT_BATCH.toString(), 15L, null, tRowNumber, tColumnNumber, pLocale);
            }
            pStandardApi.setIsBatch(tIsBatch);
        }
        tColumnNumber = 11;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 16L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tGroupValue = tCell.toString().trim();
            if (!tGroupValue.matches("[\\d]{1,3}[.].*")) {
                this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 17L, null, tRowNumber, tColumnNumber, pLocale);
            } else {
                try {
                    tStandardApiGroup = (StandardApiGroup)this.standardApiGroupDao.get(Long.valueOf(tGroupValue.substring(0, tGroupValue.indexOf("."))));
                }
                catch (Exception e) {
                    this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 17L, null, tRowNumber, tColumnNumber, pLocale);
                }
                pStandardApi.setStandardApiGroup(tStandardApiGroup);
            }
        }
        tColumnNumber = 12;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 18L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tCategoryValue = tCell.toString().trim();
            if (!tCategoryValue.matches("[\\d]{1,3}[.].*")) {
                this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 19L, null, tRowNumber, tColumnNumber, pLocale);
            } else {
                try {
                    tStandardApiCategory = (StandardApiCategory)this.standarAPICategoryDao.get(Long.valueOf(tCategoryValue.substring(0, tCategoryValue.indexOf("."))));
                }
                catch (Exception e) {
                    this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 19L, null, tRowNumber, tColumnNumber, pLocale);
                }
                pStandardApi.setStandardApiCategory(tStandardApiCategory);
            }
        }
        tColumnNumber = 13;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 20L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            String tMsgFormat = tCell.toString().trim();
            try {
                MessageFormatEnum.valueOf((String)tMsgFormat.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                if (tMsgFormat.equals(MessageFormatEnum.JSON10.getMsgFormat()) || tMsgFormat.equals(MessageFormatEnum.JSON_XML.getMsgFormat())) {
                    pStandardApi.setMsgFormat(tMsgFormat);
                }
                this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 21L, null, tRowNumber, tColumnNumber, pLocale);
            }
            pStandardApi.setMsgFormat(tMsgFormat);
        }
        tColumnNumber = 14;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            tTagZhTW = tCell.toString().trim();
            pStandardApi.setTagZhTw(tTagZhTW);
        }
        if (!StringUtil.isEmptyOrSpace((Object)(tCell = tRow.getCell(tColumnNumber = 15, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
            String tTagZhCN = tCell.toString().trim();
            pStandardApi.setTagZhCn(tTagZhCN);
        }
        if (!StringUtil.isEmptyOrSpace((Object)(tCell = tRow.getCell(tColumnNumber = 16, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
            String tTagEnUS = tCell.toString().trim();
            pStandardApi.setTagEnUs(tTagEnUS);
        } else {
            pStandardApi.setTagEnUs(tTagZhTW);
        }
        tColumnNumber = 17;
        boolean tRemarkZhTWEmpty = false;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tRemarkZhTWEmpty = true;
        } else {
            tRemarkZhTW = tCell.toString().trim();
            pStandardApi.setRemarkZhTw(tRemarkZhTW);
        }
        tColumnNumber = 18;
        boolean tRemarkZhCNEmpty = false;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tRemarkZhCNEmpty = true;
        } else {
            tRemarkZhCN = tCell.toString().trim();
            pStandardApi.setRemarkZhCn(tRemarkZhCN);
        }
        if (tRemarkZhTWEmpty && tRemarkZhCNEmpty) {
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 23L, null, tRowNumber, tColumnNumber, pLocale);
        } else if (tRemarkZhTWEmpty) {
            tRemarkZhTW = this.localeTranslate(tRemarkZhCN, LocaleEnum.ZH2HANT.getType());
            pStandardApi.setRemarkZhTw(tRemarkZhTW);
        } else if (tRemarkZhCNEmpty) {
            tRemarkZhCN = this.localeTranslate(tRemarkZhTW, LocaleEnum.ZH2HANS.getType());
            pStandardApi.setRemarkZhCn(tRemarkZhCN);
        }
        tColumnNumber = 19;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            String tRemarkEnUS = tCell.toString().trim();
            pStandardApi.setRemarkEnUs(tRemarkEnUS);
        } else {
            pStandardApi.setRemarkEnUs(tRemarkZhTW);
        }
        tColumnNumber = 20;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            tCell.setCellType(CellType.STRING);
            pStandardApi.setTenantId(tCell.toString().trim());
        } else {
            pStandardApi.setTenantId("");
        }
        tColumnNumber = 21;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            pStandardApi.setPackageName(tCell.toString().trim());
        }
        boolean IsIdempotency = StringUtil.isEmptyOrSpace((Object)(tCell = tRow.getCell(tColumnNumber = 22, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL))) ? false : "Y".equals(tCell.toString());
        tStandardApiVersion.setIdempotency(IsIdempotency);
        tColumnNumber = 23;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            tStandardApiVersion.setUpdateHistory(tCell.toString().trim());
        }
        if ("openapi".equals(pStandardApi.getApiType())) {
            tColumnNumber = 25;
            tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (StringUtil.isEmptyOrSpace((Object)tCell)) {
                this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 39L, null, tRowNumber, tColumnNumber, pLocale);
            } else {
                pStandardApi.setApiPath(tCell.toString());
            }
            tColumnNumber = 26;
            tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (StringUtil.isEmptyOrSpace((Object)tCell)) {
                pStandardApi.setRequestMethod("POST");
            } else {
                pStandardApi.setRequestMethod(tCell.toString());
            }
        } else {
            pStandardApi.setRequestMethod("POST");
        }
        tColumnNumber = 27;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        Long projectId = 1L;
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            List<Project> projectList = this.projectDao.getByName(tCell.toString().trim());
            if (CollUtil.isEmpty(projectList)) {
                this.uploadCheckResult(tResult, APIExportImportEnums.PROJECT_NOT_EXIST.toString(), null, null, 2, tColumnNumber + offset, null);
            } else {
                projectId = projectList.get(0).getProjectId();
            }
        }
        pStandardApi.setProjectId(projectId);
        List<ProjectVersionRelation> projectVersionRelationList = Collections.emptyList();
        tColumnNumber = 28;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell) && ObjectUtil.isNotNull((Object)pStandardApi.getProjectId())) {
            String[] split = tCell.toString().trim().split(",");
            List<String> projectVersionNames = Arrays.stream(split).distinct().collect(Collectors.toList());
            List<ProjectVersion> projectVersionList = ProjectVersionServiceUtil.queryProjectVersionList(projectId, projectVersionNames);
            if (projectVersionNames.size() != projectVersionList.size()) {
                this.uploadCheckResult(tResult, APIExportImportEnums.PROJECT_VERSION_NOT_EXIST.toString(), null, null, 2, tColumnNumber + offset, null);
            } else {
                Long projectIdTemp = projectId;
                projectVersionRelationList = projectVersionList.stream().map(projectVersion -> {
                    ProjectVersionRelation projectVersionRelation = new ProjectVersionRelation();
                    projectVersionRelation.setProjectId(projectIdTemp);
                    projectVersionRelation.setProjectVersionId(projectVersion.getProjectVersionId());
                    projectVersionRelation.setStandardApi(pStandardApi);
                    return projectVersionRelation;
                }).collect(Collectors.toList());
            }
        } else {
            projectVersionRelationList = new ArrayList();
            ProjectVersionRelation projectRelation = new ProjectVersionRelation();
            projectRelation.setProjectId(projectId);
            projectRelation.setStandardApi(pStandardApi);
            projectVersionRelationList.add(projectRelation);
        }
        pStandardApi.setProjectVersionRelations(projectVersionRelationList);
        this.standardApiPostProcess(null, tResult, pStandardApi, pLocale);
        return tResult;
    }

    protected void standardApiPostProcess(Map<String, String> checkResult, List<Map<String, String>> tResult, StandardApi pStandardApi, String pLocale) {
        if (pStandardApi.validateName()) {
            if (this.prop.isEnvType()) {
                pStandardApi.setName("dw.paas." + pStandardApi.getName());
            }
        } else {
            this.uploadCheckResult(tResult, APIExportImportEnums.apiNameWrong((String)pStandardApi.getApiTypeOrDefault()), APIExportImportEnums.apiNameWrongDescId((String)pStandardApi.getApiTypeOrDefault()), null, 2, 1, pLocale);
            if (checkResult != null) {
                checkResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), tResult.get(0).get("description"));
            }
        }
    }

    public List<Map<String, String>> setStandardApiDataName(StandardApi pStandardApi, Map<String, StandardApiDataName> pDataNameMap, Sheet pSheet, Boolean pCheckDataName, String pLocale, boolean pSkipReview, String pLoginAcct) throws Exception {
        ArrayList<Map<String, String>> tResult = new ArrayList<Map<String, String>>();
        Row tRow2 = pSheet.getRow(5);
        Cell tCell = tRow2.getCell(18, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        Cell tCellFilter = tRow2.getCell(10, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        boolean isNew = tCell.getStringCellValue().trim().equals("\u5217\u8209\u503c(\u7e41\u9ad4)") || tCell.getStringCellValue().trim().equals("\u5217\u4e3e\u503c(\u7e41\u4f53)");
        boolean isFilter = tCellFilter.getStringCellValue().trim().equals("\u53ef\u7b5b\u9009");
        if (!isFilter) {
            this.uploadCheckResult(tResult, APIExportImportEnums.OLD_SHEET_FORMAT.toString(), null, null, 5, 10, pLocale);
            return tResult;
        }
        HashMap<String, StandardApiDataName> tFatherMap = new HashMap<String, StandardApiDataName>();
        ParseExcelHelper tParseExcelHelper = new ParseExcelHelper();
        int tMsgType = 0;
        Boolean[] tOnlyAddOnce = new Boolean[]{true};
        for (int tRowNumber = 3; tRowNumber < pSheet.getPhysicalNumberOfRows(); ++tRowNumber) {
            Row tRow = pSheet.getRow(tRowNumber);
            if ((tRow == null || tRow.getCell(1, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL) == null) && (tRow == null || tRow.getCell(4, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL) == null)) continue;
            if (!StringUtil.isEmptyOrSpace((Object)tRow.getCell(1))) {
                switch (tRow.getCell(1).getStringCellValue()) {
                    case "Request": {
                        tMsgType = 1;
                        tParseExcelHelper.setTitleRowNum(tRowNumber += 2);
                        tParseExcelHelper.setPhysicalNumberOfRequestTitleCells(pSheet.getRow(tRowNumber).getPhysicalNumberOfCells());
                        tFatherMap.clear();
                        break;
                    }
                    case "Response success": {
                        tMsgType = 2;
                        tParseExcelHelper.setPhysicalNumberOfReponseSuccessTitleCells(pSheet.getRow(tRowNumber += 2).getPhysicalNumberOfCells());
                        tFatherMap.clear();
                        break;
                    }
                    case "Response failed": {
                        tMsgType = 3;
                        tParseExcelHelper.setPhysicalNumberOfReponseFailedTitleCells(pSheet.getRow(tRowNumber += 2).getPhysicalNumberOfCells());
                        tFatherMap.clear();
                        break;
                    }
                    default: {
                        if (tMsgType == 0) {
                            this.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_SHEET_FORMAT.toString(), null, null, tRow.getRowNum(), -1, pLocale);
                            return tResult;
                        }
                        this.setStandardApiDataNameByRow(pStandardApi, pSheet, tRow, tMsgType, tFatherMap, tParseExcelHelper, pDataNameMap, isNew, tResult, tOnlyAddOnce, pLocale);
                        break;
                    }
                }
                continue;
            }
            this.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), null, null, tRow.getRowNum(), 1, pLocale);
        }
        return tResult;
    }

    public void addDataName(String pDataName, String pDescriptionZhTW, String pDescriptionZhCN, String pDescriptionEnUs, long pApprovedStatus, String tBuildAcct, String pLoginAcct, LocalDateTime pBuildTime) {
        StandardDataName tStandardDataName = new StandardDataName();
        tStandardDataName.setDataName(pDataName);
        tStandardDataName.setDescriptionZhTw(pDescriptionZhTW);
        tStandardDataName.setDescriptionZhCn(pDescriptionZhCN);
        tStandardDataName.setDescriptionEnUs(pDescriptionEnUs);
        tStandardDataName.setApprovedStatus(pApprovedStatus);
        tStandardDataName.setApprovedAcct(pLoginAcct);
        tStandardDataName.setApprovedTime(LocalDateTime.now());
        tStandardDataName.setBuildTime(pBuildTime);
        tStandardDataName.setBuildAcct(tBuildAcct);
        tStandardDataName.setDirty(false);
        this.standardDataNameDao.saveOrupdate(tStandardDataName);
    }

    private String getExcelColumnName(int colNum) {
        StringBuilder colName = new StringBuilder();
        while (colNum > 0) {
            char tColumnValue;
            if (colNum > 26) {
                tColumnValue = (char)(colNum / 26 + 64);
                colNum %= 26;
            } else {
                tColumnValue = (char)(colNum % 26 + 1 + 64);
                colNum -= 26;
            }
            colName.append(tColumnValue);
        }
        return colName.toString();
    }

    public void uploadCheckResult(List<Map<String, String>> pResult, String pReason, Long pSolutionId, String pApiName, int pRowNumber, int pColumnNumber, String pLocale) {
        int tRowValue = pRowNumber + 1;
        String tRow = String.valueOf(tRowValue);
        String tColumn = this.getExcelColumnName(pColumnNumber);
        HashMap<String, String> tErrorLog = new HashMap<String, String>();
        if (pApiName == null) {
            tErrorLog.put("data_name", "");
        } else {
            tErrorLog.put("data_name", pApiName);
        }
        if (pRowNumber == 0 && pColumnNumber == 0) {
            tErrorLog.put("position", "");
        } else {
            tErrorLog.put("position", tColumn + "," + tRow);
        }
        if (pSolutionId != null) {
            WrongDescription tWrongDescription = (WrongDescription)this.wrongDescriptionDao.get(pSolutionId);
            switch (pLocale) {
                case "zh_CN": {
                    tErrorLog.put("description", tWrongDescription.getWrongDescChs());
                    tErrorLog.put("solution", tWrongDescription.getSolutionChs());
                    break;
                }
                case "en_US": {
                    tErrorLog.put("description", tWrongDescription.getWrongDescEn());
                    tErrorLog.put("solution", tWrongDescription.getSolutionEn());
                    break;
                }
                default: {
                    tErrorLog.put("description", tWrongDescription.getWrongDescCht());
                    tErrorLog.put("solution", tWrongDescription.getSolutionCht());
                    break;
                }
            }
        } else if (pReason.equals(APIExportImportEnums.INCORRECT_SHEET_FORMAT.toString())) {
            tErrorLog.put("description", "\u6a21\u7248\u683c\u5f0f\u6709\u8aa4\uff0c\u8acb\u53c3\u8003\u7bc4\u4f8b\u6a21\u7248");
        } else if (pReason.equals(APIExportImportEnums.APINAME_WRONG.toString())) {
            tErrorLog.put("description", "API\u540d\u7a31\u4e0d\u6b63\u78ba\uff0c\u9808\u7531\u300c\u5c0f\u5beb\u82f1\u6587\u300d\u3001\u300c\u6578\u5b57\u300d\u3001\u300c_\u300d\u548c\u300c.\u300d\u7d44\u6210\uff0c\u4e0d\u53ef\u6709\u5176\u5b83\u7b26\u865f\u6216\u7a7a\u683c");
        } else if (pReason.equals(APIExportImportEnums.OPEN_API_NAME_WRONG.toString())) {
            tErrorLog.put("description", "API\u540d\u7a31\u4e0d\u6b63\u78ba\uff0c\u9808\u7531\u300c\u5927\u5c0f\u5beb\u82f1\u6587\u300d\u3001\u300c\u6578\u5b57\u300d\u3001\u300c_\u300d\u548c\u300c.\u300d\u7d44\u6210\uff0c\u4e0d\u53ef\u6709\u5176\u5b83\u7b26\u865f\u6216\u7a7a\u683c");
        } else if (pReason.equals(APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString())) {
            tErrorLog.put("description", "\u8cc7\u6599\u683c\u5f0f/\u5167\u5bb9\u6709\u8aa4\uff0c\u8acb\u53c3\u8003\u7bc4\u4f8b\u6a21\u7248");
        } else if (pReason.equals(APIExportImportEnums.CAN_NOT_PAGING.toString())) {
            tErrorLog.put("description", "\u975eget\u985e\u578b\u7684API\uff0c\u4e0d\u53ef\u4f7f\u7528\u5206\u9801\u6a5f\u5236\u300c2.\u50c5\u652f\u6301\u5206\u9801\u300d\u3001\u300c3.\u540c\u6642\u652f\u6301\u300d");
        } else if (pReason.equals(APIExportImportEnums.CAN_NOT_BATCH.toString())) {
            tErrorLog.put("description", "\u975eget\u985e\u578b\u7684API\uff0c\u4e0d\u53ef\u4f7f\u7528\u5206\u5305\u6a5f\u5236");
        } else if (pReason.equals(APIExportImportEnums.REQUIRED.toString())) {
            tErrorLog.put("description", "\u5fc5\u8981\u6b04\u4f4d\u672a\u586b\u5beb");
        } else if (pReason.equals(APIExportImportEnums.FATHER_REQUIRED.toString())) {
            tErrorLog.put("description", "\u6b04\u4f4d\u300c\u985e\u578b\u300d\u70baHF\u3001MF\u3001D\u3001DF\u3001SD\u6216SDF\u4e00\u5b9a\u8981\u6709\u300c\u6240\u5c6c\u55ae\u982d/\u8eab\u300d");
        } else if (pReason.equals(APIExportImportEnums.DATANAME_NOT_EXIST.toString())) {
            tErrorLog.put("description", "\u300c\u8fad\u5f59\u4ee3\u865f\u300d\u4e0d\u5b58\u5728");
        } else if (pReason.equals(APIExportImportEnums.LIST_ENUM_FORMAT_ERROR.toString())) {
            tErrorLog.put("description", "\u5217\u8209\u503c\u6b04\u4f4d\u683c\u5f0f\u932f\u8aa4");
        } else if (pReason.equals(APIExportImportEnums.NO_INPUT_PROD_NAME.toString())) {
            tErrorLog.put("description", "\u9577\u5ea6\u7cbe\u5ea6\u8cc7\u8a0a\u672a\u8f38\u5165\u7522\u54c1\u540d\u7a31");
        } else if (pReason.equals(APIExportImportEnums.INCORRECT_FORMAT_OF_PRECISION.toString())) {
            tErrorLog.put("description", "\u9577\u5ea6\u7cbe\u5ea6\u683c\u5f0f\u932f\u8aa4");
        } else if (pReason.equals(APIExportImportEnums.INVALID_PROD_NAME.toString())) {
            tErrorLog.put("description", "\u7121\u6548\u7684\u7522\u54c1\u540d\u7a31");
        } else if (pReason.equals(APIExportImportEnums.CAN_NOT_FIND_FATHER.toString())) {
            tErrorLog.put("description", "\u672a\u627e\u5230\u5c0d\u61c9\u7684\u300c\u6240\u5c6c\u55ae\u982d/\u8eab\u300d");
        } else if (pReason.equals(APIExportImportEnums.DUPLICATE_DATANAME.toString())) {
            tErrorLog.put("description", "\u300c\u8fad\u5f59\u4ee3\u865f\u300d\u5df2\u5b58\u5728\u65bc\u76f8\u540c\u300c\u6240\u5c6c\u55ae\u982d/\u8eab\u300d\u4e0b");
        } else if (pReason.equals(APIExportImportEnums.API_VERSION_IS_EXIST.toString())) {
            tErrorLog.put("description", "\u5f53\u524dAPI\u540d\u7a31\u4e0e\u7248\u672c\u5df2\u88ab\u4ed6\u4eba\u521b\u5efa");
        } else if (pReason.equals(APIExportImportEnums.PREVI_API_VERSION_IS_EXIST.toString())) {
            tErrorLog.put("description", "API\u4e0a\u4e00\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8acb\u78ba\u8a8d\u4e0a\u4e00\u7248\u662f\u5426\u5df2\u532f\u5165");
        } else if (pReason.equals(APIExportImportEnums.PREV_API_BRANCH_NOT_EXIST.toString())) {
            tErrorLog.put("description", "API\u4e0a\u4e00\u5206\u652f\u4e0d\u5b58\u5728\uff0c\u8acb\u78ba\u8a8d\u4e0a\u4e00\u7248\u662f\u5426\u5df2\u532f\u5165");
        } else if (pReason.equals(APIExportImportEnums.PREVI_IS_DEVELOPING.toString())) {
            tErrorLog.put("description", "API\u4e0a\u4e00\u7248\u672c\u70ba\u300c\u8349\u7a3f\u300d\u6216\u300c\u958b\u767c\u4e2d\u300d\uff0c\u8acb\u5b9a\u7248\u5f8c\u518d\u9032\u884c\u532f\u5165");
        } else if (pReason.equals(APIExportImportEnums.IS_BATCH_CAN_NOT_CHANGE.toString())) {
            tErrorLog.put("description", "\u300c\u9808\u5206\u5305\u300d\u8207\u4e0a\u4e00\u7248\u4e0d\u4e00\u81f4\uff0c\u300c\u9808\u5206\u5305\u300d\u4e0d\u53ef\u4ee5\u7570\u52d5");
        } else if (pReason.equals(APIExportImportEnums.SYNC_TYPE_CAN_NOT_CHANGE.toString())) {
            tErrorLog.put("description", " \u300c\u8abf\u7528\u6a21\u5f0f\u300d\u8207\u4e0a\u4e00\u7248\u4e0d\u4e00\u81f4\uff0c\u300c\u8abf\u7528\u6a21\u5f0f\u300d\u4e0d\u53ef\u4ee5\u7570\u52d5");
        } else if (pReason.equals(APIExportImportEnums.DATA_TYPE_WRONG.toString())) {
            tErrorLog.put("description", "\u8a72\u5b57\u6bb5\u985e\u578b\u4e0d\u53ef\u70baE");
        } else if (pReason.equals(APIExportImportEnums.CAN_NOT_INPUT_PRECISIONS.toString())) {
            tErrorLog.put("description", "\u8a72\u5b57\u6bb5\u7684\u8fad\u5f59\u578b\u614b\u4e0d\u53ef\u586b\u5beb\u9577\u5ea6\u548c\u7cbe\u5ea6\uff0c\u53ea\u6709\u8fad\u5f59\u578b\u614bstring\u548cnumeric\u5b57\u6bb5\u624d\u53ef\u586b\u5beb\u7522\u54c1\u7684\u5c0d\u61c9\u6b04\u4f4d\u7684\u9577\u5ea6\u548c\u7cbe\u5ea6");
        } else if (pReason.equals(APIExportImportEnums.OLD_SHEET_FORMAT.toString())) {
            tErrorLog.put("description", "\u5f53\u524d\u4e3a\u65e7\u6a21\u677f\uff0c\u8bf7\u4f7f\u7528\u65b0\u6a21\u677f");
        } else if (pReason.equals(APIExportImportEnums.API_VERSION_NOT_COMPLIANCE.toString())) {
            tErrorLog.put("description", "\u5f53\u524d\u7248\u672c\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        } else if (pReason.equals(APIExportImportEnums.PARENT_NAME_INCONSISTENT.toString())) {
            tErrorLog.put("description", "\u7236\u7c7bAPI\u4e0d\u4e00\u81f4\uff0c\u5efa\u8bae\u4e0d\u66f4\u6539\u7236\u7c7b");
        } else if (pReason.equals(APIExportImportEnums.PARENT_API_NOT_CONFIRMED.toString())) {
            tErrorLog.put("description", "\u7236\u7c7bAPI\u4e0d\u5b58\u5728|\u7236\u7c7bAPI\u4e0d\u5b58\u5728\u5df2\u5b9a\u7248\u7684\u7248\u672c");
        } else if (pReason.equals(APIExportImportEnums.PROJECT_NOT_EXIST.toString())) {
            tErrorLog.put("description", "\u5173\u8054\u7684\u4ea7\u54c1\u4e0d\u5b58\u5728");
        } else if (pReason.equals(APIExportImportEnums.PROJECT_VERSION_NOT_EXIST.toString())) {
            tErrorLog.put("description", "\u5173\u8054\u7684\u4ea7\u54c1\u7248\u672c\u4e0d\u5b58\u5728");
        }
        pResult.add(tErrorLog);
    }

    public void setStandardApiDataNameByRow(StandardApi pStandardApi, Sheet pSheet, Row pRow, Integer pMsgType, Map<String, StandardApiDataName> tFatherMap, ParseExcelHelper tParseExcelHelper, Map<String, StandardApiDataName> pDataNameMap, boolean pIsNew, List<Map<String, String>> pResult, Boolean[] tOnlyAddOnce, String pLocale) throws Exception {
        String tColumnType;
        Cell tCell;
        int tColumnNumber;
        StandardApiDataName tStandardApiDataName;
        String tFatherColumnType;
        boolean tFatherDataNameRequired;
        String tRemarkZhCN;
        String tRemarkZhTW;
        String tDescriptionZhCN;
        String tDescriptionZhTW;
        String tDataName;
        String tFatherDataName;
        int tRowNumber;
        block108: {
            tRowNumber = pRow.getRowNum();
            tFatherDataName = null;
            tDataName = null;
            tDescriptionZhTW = null;
            tDescriptionZhCN = null;
            tRemarkZhTW = null;
            tRemarkZhCN = null;
            tFatherDataNameRequired = false;
            tFatherColumnType = null;
            tStandardApiDataName = new StandardApiDataName();
            tColumnNumber = 0;
            tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (StringUtil.isEmptyOrSpace((Object)tCell)) {
                tStandardApiDataName.setIsBusinesskey(Boolean.FALSE);
            } else {
                String tIsBusinesskey = tCell.toString().trim();
                switch (tIsBusinesskey.toUpperCase()) {
                    case "Y": {
                        tStandardApiDataName.setIsBusinesskey(Boolean.TRUE);
                        break;
                    }
                    case "N": {
                        tStandardApiDataName.setIsBusinesskey(Boolean.FALSE);
                        break;
                    }
                    default: {
                        this.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), null, null, tRowNumber, tColumnNumber, pLocale);
                    }
                }
            }
            tStandardApiDataName.setNullable(false);
            tColumnNumber = 1;
            tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (StringUtil.isEmptyOrSpace((Object)tCell)) {
                this.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 24L, null, tRowNumber, tColumnNumber, pLocale);
            }
            tColumnType = tCell.toString().trim();
            try {
                ColumnTypeEnum.valueOf((String)tColumnType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                if (tColumnType.toUpperCase().matches("(S{1}|[0-9]+){0,1}D(F{0,1})")) break block108;
                this.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 24L, null, tRowNumber, tColumnNumber, pLocale);
            }
        }
        tStandardApiDataName.setColumnType(tColumnType);
        tColumnNumber = 2;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            if (tFatherDataNameRequired) {
                this.uploadCheckResult(pResult, APIExportImportEnums.FATHER_REQUIRED.toString(), null, null, tRowNumber, tColumnNumber, pLocale);
            }
        } else {
            tFatherDataName = tCell.toString().trim();
        }
        tColumnNumber = 3;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        tColumnNumber = 4;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 27L, null, tRowNumber, tColumnNumber, pLocale);
        } else {
            tDataName = tCell.toString().replaceAll("[ |\u3000]", "");
            if (tDataName.matches("[a-z0-9_]+") || Arrays.asList(ApimgmtConstant.ALLOW_API_DATA_NAME).contains(tDataName)) {
                tStandardApiDataName.setStandardDataName(tDataName);
            } else {
                this.uploadCheckResult(pResult, null, 37L, tDataName, tRowNumber, tColumnNumber, pLocale);
            }
        }
        tColumnNumber = 5;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!Arrays.asList(ApimgmtConstant.ALLOW_ARRAY_COLUMN_TYPE).contains(tColumnType.toUpperCase()) && !tColumnType.toUpperCase().matches("(S{1}|[0-9]+){0,1}D")) {
            if (StringUtil.isEmptyOrSpace((Object)tCell)) {
                this.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 29L, tDataName, tRowNumber, tColumnNumber, pLocale);
            } else {
                String tDataType = tCell.toString().trim();
                try {
                    DataTypeEnum.valueOf((String)tDataType.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 29L, tDataName, tRowNumber, tColumnNumber, pLocale);
                }
                tStandardApiDataName.setDataType(tDataType.toLowerCase());
            }
        }
        if (StringUtil.isEmptyOrSpace((Object)(tCell = pRow.getCell(tColumnNumber = 6, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
            tStandardApiDataName.setIsRequired(Boolean.FALSE);
        } else {
            String tIsRequired = tCell.toString().trim();
            switch (tIsRequired.toUpperCase()) {
                case "Y": {
                    tStandardApiDataName.setIsRequired(Boolean.TRUE);
                    break;
                }
                case "N": {
                    tStandardApiDataName.setIsRequired(Boolean.FALSE);
                    break;
                }
                default: {
                    this.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 30L, tDataName, tRowNumber, tColumnNumber, pLocale);
                }
            }
        }
        tColumnNumber = 7;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        boolean tIsDatakey = StringUtil.isEmptyOrSpace((Object)tCell) ? false : "Y".equals(tCell.toString());
        tStandardApiDataName.setIsDatakey(tIsDatakey);
        tColumnNumber = 8;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        boolean tIsArray = StringUtil.isEmptyOrSpace((Object)tCell) ? false : "Y".equals(tCell.toString());
        tStandardApiDataName.setIsArray(tIsArray);
        tColumnNumber = 9;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        boolean tCanSort = StringUtil.isEmptyOrSpace((Object)tCell) ? false : "Y".equals(tCell.toString());
        tStandardApiDataName.setCanSort(tCanSort);
        tColumnNumber = 10;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        boolean tCanFilter = StringUtil.isEmptyOrSpace((Object)tCell) ? false : "Y".equals(tCell.toString());
        tStandardApiDataName.setCanFilter(tCanFilter);
        tColumnNumber = 11;
        boolean tDescriptionZhTwEmpty = false;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tDescriptionZhTwEmpty = true;
        } else {
            tDescriptionZhTW = tCell.toString().trim();
            tStandardApiDataName.setDescriptionZhTw(tDescriptionZhTW);
        }
        tColumnNumber = 12;
        boolean tDescriptionZhCnEmpty = false;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tDescriptionZhCnEmpty = true;
        } else {
            tDescriptionZhCN = tCell.toString().trim();
            tStandardApiDataName.setDescriptionZhCn(tDescriptionZhCN);
        }
        if (tDescriptionZhTwEmpty && tDescriptionZhCnEmpty) {
            this.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 31L, tDataName, tRowNumber, tColumnNumber, pLocale);
        } else if (tDescriptionZhTwEmpty) {
            tDescriptionZhTW = this.localeTranslate(tDescriptionZhCN, LocaleEnum.ZH2HANT.getType());
            tStandardApiDataName.setDescriptionZhTw(tDescriptionZhTW);
        } else if (tDescriptionZhCnEmpty) {
            tDescriptionZhCN = this.localeTranslate(tDescriptionZhTW, LocaleEnum.ZH2HANS.getType());
            tStandardApiDataName.setDescriptionZhCn(tDescriptionZhCN);
        }
        tColumnNumber = 13;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            String tDescriptionEnUS = tCell.toString().trim();
            tStandardApiDataName.setDescriptionEnUs(tDescriptionEnUS);
        } else if (null != tDataName) {
            tStandardApiDataName.setDescriptionEnUs(tDataName.replace("_", " "));
        }
        tColumnNumber = 14;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            String tValue = tCell.toString().trim();
            tStandardApiDataName.setValue(tValue);
        }
        tColumnNumber = 15;
        boolean tRemarkZhTwEmpty = false;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tRemarkZhTwEmpty = true;
        } else {
            tRemarkZhTW = tCell.toString().trim();
            tStandardApiDataName.setRemarkZhTw(tRemarkZhTW);
        }
        tColumnNumber = 16;
        boolean tRemarkZhCnEmpty = false;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            tRemarkZhCnEmpty = true;
        } else {
            tRemarkZhCN = tCell.toString().trim();
            tStandardApiDataName.setRemarkZhCn(tRemarkZhCN);
        }
        if (!tRemarkZhTwEmpty || !tRemarkZhCnEmpty) {
            if (tRemarkZhTwEmpty) {
                tRemarkZhTW = this.localeTranslate(tRemarkZhCN, LocaleEnum.ZH2HANT.getType());
                tStandardApiDataName.setRemarkZhTw(tRemarkZhTW);
            } else if (tRemarkZhCnEmpty) {
                tRemarkZhCN = this.localeTranslate(tRemarkZhTW, LocaleEnum.ZH2HANS.getType());
                tStandardApiDataName.setRemarkZhCn(tRemarkZhCN);
            }
        }
        if (StringUtil.isEmptyOrSpace((Object)(tCell = pRow.getCell(tColumnNumber = 17, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
            tStandardApiDataName.setRemarkEnUs(tRemarkZhTW);
        } else {
            String tRemarkEnUS = tCell.toString().trim();
            tStandardApiDataName.setRemarkEnUs(tRemarkEnUS);
        }
        if (!pIsNew) {
            tColumnNumber = 18;
            tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
                String tListEnumString = tCell.toString().trim();
                if (tListEnumString.matches("zh_TW:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\][\\t\\n\\r\\s]*zh_CN:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\][\\t\\n\\r\\s]*en_US:\\[([^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)(;[^.;\\[\\]]+(\\.[^.;\\[\\]]+)+)*\\]")) {
                    tStandardApiDataName.setListEnumZhTw(tListEnumString.split("zh_TW:")[1].split("\\[")[1].split("\\]")[0]);
                    tStandardApiDataName.setListEnumZhCn(tListEnumString.split("zh_CN:")[1].split("\\[")[1].split("\\]")[0]);
                    tStandardApiDataName.setListEnumEn(tListEnumString.split("en_US:")[1].split("\\[")[1].split("\\]")[0]);
                } else {
                    this.uploadCheckResult(pResult, APIExportImportEnums.LIST_ENUM_FORMAT_ERROR.toString(), 32L, tDataName, tRowNumber, tColumnNumber, pLocale);
                }
            }
        } else {
            tColumnNumber = 18;
            tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
                String tListEnumZhTw = tCell.toString().trim();
                tStandardApiDataName.setListEnumZhTw(tListEnumZhTw);
            }
            if (!StringUtil.isEmptyOrSpace((Object)(tCell = pRow.getCell(tColumnNumber = 19, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
                String tListEnumZhCN = tCell.toString().trim();
                tStandardApiDataName.setListEnumZhCn(tListEnumZhCN);
            }
            if (!StringUtil.isEmptyOrSpace((Object)(tCell = pRow.getCell(tColumnNumber = 20, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
                String tListEnumEnUS = tCell.toString().trim();
                tStandardApiDataName.setListEnumEn(tListEnumEnUS);
            }
        }
        tColumnNumber = pIsNew ? 21 : 19;
        tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        String tUpdateHistoryString = StringUtil.isEmptyOrSpace((Object)tCell) ? null : tCell.toString().trim();
        tStandardApiDataName.setUpdateHistory(tUpdateHistoryString);
        tColumnNumber = pIsNew ? 22 : 20;
        int tMaxNum = -1;
        if (pMsgType == 1) {
            tMaxNum = tParseExcelHelper.getPhysicalNumberOfRequestTitleCells();
        }
        if (pMsgType == 2) {
            tMaxNum = tParseExcelHelper.getPhysicalNumberOfReponseSuccessTitleCells();
        }
        if (pMsgType == 3) {
            tMaxNum = tParseExcelHelper.getPhysicalNumberOfReponseFailedTitleCells();
        }
        while (tColumnNumber < tMaxNum) {
            Object tProductApiDataName = new ProductApiDataName();
            Cell tCellPro = pSheet.getRow(tParseExcelHelper.getTitleRowNum().intValue()).getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (!StringUtil.isEmptyOrSpace((Object)tCellPro)) {
                String tProdName = tCellPro.toString().trim();
                if (!this.productDao.exists(tProdName)) {
                    if (tOnlyAddOnce[0].booleanValue()) {
                        this.uploadCheckResult(pResult, APIExportImportEnums.INVALID_PROD_NAME.toString(), 33L, tDataName, tCellPro.getRowIndex(), tCellPro.getColumnIndex(), pLocale);
                        tOnlyAddOnce[0] = false;
                    }
                } else {
                    Product tProduct = (Product)this.productDao.get(tProdName);
                    ((ProductApiDataName)tProductApiDataName).setProduct(tProduct);
                    ((ProductApiDataName)tProductApiDataName).setApiDataName(tStandardApiDataName);
                    tStandardApiDataName.addProductApiDataName((ProductApiDataName)tProductApiDataName);
                }
            }
            if (!StringUtil.isEmptyOrSpace((Object)(tCell = pRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
                tCell.setCellType(CellType.STRING);
                try {
                    if ("string".equals(tStandardApiDataName.getDataType())) {
                        ((ProductApiDataName)tProductApiDataName).setLength(Integer.parseInt(tCell.toString().trim()));
                    } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                        ((ProductApiDataName)tProductApiDataName).setLength(Integer.parseInt(tCell.toString().trim().split(",")[0]));
                        ((ProductApiDataName)tProductApiDataName).setPrecision(Integer.parseInt(tCell.toString().trim().split(",")[1]));
                    } else {
                        this.uploadCheckResult(pResult, APIExportImportEnums.CAN_NOT_INPUT_PRECISIONS.toString(), 36L, tDataName, tRowNumber, tColumnNumber, pLocale);
                    }
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                    this.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OF_PRECISION.toString(), 34L, tDataName, tRowNumber, tColumnNumber, pLocale);
                }
                if (StringUtil.isEmptyOrSpace((Object)tCellPro) && tOnlyAddOnce[0].booleanValue()) {
                    this.uploadCheckResult(pResult, APIExportImportEnums.NO_INPUT_PROD_NAME.toString(), 33L, tDataName, tRowNumber, tColumnNumber, pLocale);
                    tOnlyAddOnce[0] = false;
                }
            }
            ++tColumnNumber;
        }
        if (pStandardApi.getStandardApiVersions().size() == 0) {
            return;
        }
        tStandardApiDataName.setStandardApiVersion(pStandardApi.getStandardApiVersions().get(0));
        tStandardApiDataName.setMsgType(pMsgType);
        tStandardApiDataName.setApiVer("apiVersion");
        if (tColumnType.equals(ColumnTypeEnum.E.toString()) && !ArrayUtils.contains((Object[])ApimgmtConstant.COLUMN_TYPE_E_DATA_NAME, (Object)tDataName)) {
            this.uploadCheckResult(pResult, APIExportImportEnums.DATA_TYPE_WRONG.toString(), 35L, tDataName, tRowNumber, 1, pLocale);
        }
        if (!ArrayUtils.contains((Object[])ApimgmtConstant.DATANAME_FATHER_UNREQUIRED, (Object)tColumnType.toUpperCase())) {
            tFatherDataNameRequired = true;
            switch (tColumnType) {
                case "HF": {
                    tFatherColumnType = ColumnTypeEnum.H.toString();
                    break;
                }
                case "MF": 
                case "D": {
                    tFatherColumnType = ColumnTypeEnum.M.toString();
                    break;
                }
                case "DF": 
                case "SD": {
                    tFatherColumnType = ColumnTypeEnum.D.toString();
                    break;
                }
                case "SDF": 
                case "4D": {
                    tFatherColumnType = ColumnTypeEnum.SD.toString();
                    break;
                }
                default: {
                    if (tColumnType.endsWith("DF")) {
                        tFatherColumnType = tColumnType.replace("F", "");
                        break;
                    }
                    if (!tColumnType.endsWith("D")) break;
                    int level = Integer.parseInt(tColumnType.toUpperCase().replace("D", ""));
                    tFatherColumnType = level - 1 + "D";
                }
            }
            StandardApiDataName tFatherStandardApiDataName = tFatherMap.get(tFatherColumnType + tFatherDataName + pMsgType);
            if (tFatherStandardApiDataName == null) {
                this.uploadCheckResult(pResult, APIExportImportEnums.CAN_NOT_FIND_FATHER.toString(), 25L, tDataName, tRowNumber, 2, pLocale);
            } else {
                for (StandardApiDataName tExistDataName : tFatherStandardApiDataName.getChildrens()) {
                    if (null == tDataName || !tDataName.equals(tExistDataName.getStandardDataName())) continue;
                    this.uploadCheckResult(pResult, APIExportImportEnums.DUPLICATE_DATANAME.toString(), 28L, tDataName, tRowNumber, 4, pLocale);
                }
                tFatherStandardApiDataName.addChildren(tStandardApiDataName);
                tStandardApiDataName.setParent(tFatherStandardApiDataName);
                pDataNameMap.put(tColumnType + tDataName + pMsgType + tFatherDataName, tStandardApiDataName);
            }
            if (tColumnType.endsWith("D")) {
                tFatherMap.put(tColumnType + tDataName + pMsgType, tStandardApiDataName);
            }
        } else {
            StandardApiDataName tDataName2;
            if ((tColumnType.toUpperCase().equals(ColumnTypeEnum.DATAKEY.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.P.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.E.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.M.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.H.toString())) && (tDataName2 = pDataNameMap.get(tColumnType + tDataName + pMsgType)) != null) {
                this.uploadCheckResult(pResult, APIExportImportEnums.DUPLICATE_DATANAME.toString(), 28L, tDataName, tRowNumber, 4, pLocale);
            }
            if (tColumnType.toUpperCase().equals(ColumnTypeEnum.H.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.M.toString())) {
                tFatherMap.put(tColumnType + tDataName + pMsgType, tStandardApiDataName);
            }
            pStandardApi.getStandardApiVersions().get(0).addStandardApiDataName(tStandardApiDataName);
            pDataNameMap.put(tColumnType + tDataName + pMsgType, tStandardApiDataName);
        }
    }

    public void addDuplicateDescription(Workbook pWorkbook, Sheet pSheet, String pDuplicateType, String pOtherUser) {
        int firstRowNumber = 0;
        int firstCellNumber = 0;
        Row row = pSheet.getRow(firstRowNumber);
        Cell cell = row.getCell(firstCellNumber);
        String tDuplicateDescription = "";
        switch (String.valueOf(pDuplicateType)) {
            case "1": {
                tDuplicateDescription = "\u5c0e\u5165\u5931\u6557\u539f\u56e0\uff1a\u5c0d\u61c9API\u6b63\u5728\u8349\u7a3f\u4e2d";
                break;
            }
            case "2": {
                tDuplicateDescription = "\u5c0e\u5165\u5931\u6557\u539f\u56e0\uff1a\u5c0d\u61c9API\u6b63\u5728\u5ba1\u6838\u4e2d";
                break;
            }
            case "3": {
                tDuplicateDescription = "\u5c0e\u5165\u5931\u6557\u539f\u56e0\uff1a\u5c0d\u61c9API\u6b63\u5728\u5f00\u53d1\u4e2d";
                break;
            }
            case "4": {
                tDuplicateDescription = "\u5c0e\u5165\u5931\u6557\u539f\u56e0\uff1a\u5c0d\u61c9API\u5df2\u5b9a\u7248";
                break;
            }
            case "5": {
                tDuplicateDescription = "\u5c0e\u5165\u5931\u6557\u539f\u56e0\uff1a\u5176\u4ed6\u4f7f\u7528\u8005(" + pOtherUser + ")\u5df2\u7d93\u532f\u5165\u904e\u6b64API\u7248\u672c";
                break;
            }
        }
        CellStyle style = pWorkbook.createCellStyle();
        Font font = pWorkbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        style.setWrapText(true);
        style.setFont(font);
        cell.setCellStyle(style);
        cell.setCellValue(tDuplicateDescription);
    }

    public void writeImportErrorFile(Sheet pSheet, Map<String, List<Map<String, String>>> pTotalApiErrorMap) {
        Row row = pSheet.createRow(0);
        row.createCell(0).setCellValue("\u670d\u52d9\u540d\u7a31");
        row.createCell(1).setCellValue("\u7248\u672c");
        row.createCell(2).setCellValue("\u4f4d\u7f6e");
        row.createCell(3).setCellValue("\u8fad\u5f59\u4ee3\u865f");
        row.createCell(4).setCellValue("\u554f\u984c\u8aaa\u660e");
        row.createCell(5).setCellValue("\u89e3\u6c7a\u65b9\u6848");
        int rownum = 1;
        for (String tKey : pTotalApiErrorMap.keySet()) {
            for (Map<String, String> tError : pTotalApiErrorMap.get(tKey)) {
                String[] tApiInfo = tKey.split("/");
                Row tRow = pSheet.createRow(rownum);
                tRow.createCell(0).setCellValue(tApiInfo[0]);
                tRow.createCell(1).setCellValue(tApiInfo.length > 1 ? tApiInfo[1] : "");
                if (tError.get("position") != null) {
                    tRow.createCell(2).setCellValue(tError.get("position"));
                }
                if (tError.get("data_name") != null) {
                    tRow.createCell(3).setCellValue(tError.get("data_name"));
                }
                if (tError.get("description") != null) {
                    tRow.createCell(4).setCellValue(tError.get("description"));
                }
                if (tError.get("solution") != null) {
                    tRow.createCell(5).setCellValue(tError.get("solution"));
                }
                ++rownum;
            }
        }
    }

    public Map<String, String> setStandardApiBasicInfo(StandardApi pStandardApi, String pApplicant, Sheet pSheet) {
        int tRowNumber = 0;
        int tColumnNumber = 1;
        StandardApiVersion tStandardApiVersion = new StandardApiVersion();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, String> tResult = new HashMap<String, String>();
        Row tRow = pSheet.getRow(tRowNumber);
        if (tRow == null || tRow.getCell(1, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL) == null || !tRow.getCell(1).getStringCellValue().equals("StandardAPI")) {
            this.uploadCheckResult(result, APIExportImportEnums.INCORRECT_SHEET_FORMAT.toString(), null, null, tRowNumber, tColumnNumber, null);
            tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            return tResult;
        }
        tRowNumber = 2;
        tRow = pSheet.getRow(tRowNumber);
        Cell tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(result, APIExportImportEnums.REQUIRED.toString(), null, null, tRowNumber, tColumnNumber, null);
            tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            return tResult;
        }
        String tApiName = tCell.toString().trim();
        pStandardApi.setName(tApiName);
        tColumnNumber = 5;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(result, APIExportImportEnums.REQUIRED.toString(), null, null, tRowNumber, tColumnNumber, null);
            tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            return tResult;
        }
        String tVersion = tCell.toString().trim();
        if (!tVersion.matches("\\d+\\.\\d+")) {
            this.uploadCheckResult(result, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), null, null, tRowNumber, tColumnNumber, null);
            tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            return tResult;
        }
        pStandardApi.addStandardApiVersion(tStandardApiVersion);
        pStandardApi.setBranch(ApiVersionServiceUtil.getBranchFromVersion(tVersion));
        tStandardApiVersion.setStandardApi(pStandardApi);
        tStandardApiVersion.setVersion(tVersion);
        tStandardApiVersion.setApplicant(pApplicant);
        ApprovedStatus approvedStatus = (ApprovedStatus)this.approvedStatusDao.get(1L);
        tStandardApiVersion.setApprovedStatus(approvedStatus);
        tColumnNumber = 8;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            this.uploadCheckResult(result, APIExportImportEnums.REQUIRED.toString(), null, null, tRowNumber, tColumnNumber, null);
            tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            return tResult;
        }
        String tRequester = tCell.toString().replaceAll("[ |\u3000]", "");
        pStandardApi.setRequester(tRequester);
        tColumnNumber = 20;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            tCell.setCellType(CellType.STRING);
            pStandardApi.setTenantId(tCell.toString().trim());
        } else {
            pStandardApi.setTenantId("");
        }
        tColumnNumber = 21;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
            pStandardApi.setPackageName(tCell.toString().trim());
        }
        if (StringUtil.isEmptyOrSpace((Object)(tCell = tRow.getCell(tColumnNumber = 8, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
            this.uploadCheckResult(result, APIExportImportEnums.REQUIRED.toString(), null, null, tRowNumber, tColumnNumber, null);
            tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            return tResult;
        }
        tRequester = tCell.toString().replaceAll("[ |\u3000]", "");
        pStandardApi.setRequester(tRequester);
        tColumnNumber = 24;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (StringUtil.isEmptyOrSpace((Object)tCell)) {
            pStandardApi.setApiType("esp");
        } else {
            pStandardApi.setApiType(ApiTypeConstants.getCodeByName((String)tCell.toString()));
        }
        if ("openapi".equals(pStandardApi.getApiType())) {
            tColumnNumber = 25;
            tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (!StringUtil.isEmptyOrSpace((Object)tCell)) {
                pStandardApi.setApiPath(tCell.toString());
            }
            if (StringUtil.isEmptyOrSpace((Object)(tCell = tRow.getCell(tColumnNumber = 26, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
                pStandardApi.setRequestMethod("POST");
            } else {
                pStandardApi.setRequestMethod(tCell.toString());
            }
        }
        if (StringUtil.isEmptyOrSpace((Object)(tCell = tRow.getCell(tColumnNumber = 27, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)))) {
            pStandardApi.setProjectId(1L);
        } else {
            List<Project> projectList = this.projectDao.getByName(tCell.toString().trim());
            if (CollUtil.isEmpty(projectList)) {
                this.uploadCheckResult(result, APIExportImportEnums.PROJECT_NOT_EXIST.toString(), null, null, 2, 29, null);
                tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            } else {
                pStandardApi.setProjectId(projectList.get(0).getProjectId());
            }
        }
        tColumnNumber = 28;
        tCell = tRow.getCell(tColumnNumber, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (!StringUtil.isEmptyOrSpace((Object)tCell) && ObjectUtil.isNotNull((Object)pStandardApi.getProjectId())) {
            String[] split = tCell.toString().trim().split(",");
            List<String> projectVersionNames = Arrays.stream(split).distinct().collect(Collectors.toList());
            if (!ProjectVersionServiceUtil.judgeProjectVersionNames(pStandardApi.getProjectId(), projectVersionNames)) {
                this.uploadCheckResult(result, APIExportImportEnums.PROJECT_VERSION_NOT_EXIST.toString(), null, null, 2, 30, null);
                tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
            }
        }
        this.standardApiPostProcess(tResult, result, pStandardApi, null);
        if (!this.apiVersionService.judgeNewBranch(tVersion).booleanValue()) {
            if (ApiVersionServiceUtil.judgeVersion(tVersion).booleanValue()) {
                String tPreviousVersion = ApiVersionServiceUtil.getPreviousVersion(tVersion);
                List<StandardApiVersion> tPreviousStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, pStandardApi.getTenantId(), tPreviousVersion);
                if (tPreviousStandardApiVersions.isEmpty()) {
                    this.uploadCheckResult(result, APIExportImportEnums.PREVI_API_VERSION_IS_EXIST.toString(), null, null, 2, 5, null);
                    tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
                    return tResult;
                }
                if (CollUtil.isNotEmpty(tPreviousStandardApiVersions) && tPreviousStandardApiVersions.get(0).getApprovedStatus().getId() != 4L) {
                    this.uploadCheckResult(result, APIExportImportEnums.PREVI_IS_DEVELOPING.toString(), null, null, 2, 5, null);
                    tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
                    return tResult;
                }
            } else {
                this.uploadCheckResult(result, APIExportImportEnums.API_VERSION_NOT_COMPLIANCE.toString(), null, null, 2, 5, null);
                tResult.put(APIExportImportEnums.RESULT_MESSAGE.toString(), (String)((Map)result.get(0)).get("description"));
                return tResult;
            }
        }
        return tResult;
    }
}

