package com.digiwin.athena.apimgmt.facade.dto;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiMgmtApiKeyDTO {

    private String apiName;

    private String tenantId;

    private String version;

    public static ApiMgmtApiKeyDTO of(String apiName, String tenantId) {
        return of(apiName, tenantId, null);
    }

    public static ApiMgmtApiKeyDTO of(String apiName, String tenantId, String version) {
        ApiMgmtApiKeyDTO dto = new ApiMgmtApiKeyDTO();
        dto.setApiName(apiName);
        dto.setTenantId(tenantId);
        dto.setVersion(version);

        return dto;
    }

    public String getBranch() {
        if (StrUtil.isNotBlank(version)) {
            return ApiVersionServiceUtil.getBranchFromVersion(version);
        }

        return null;
    }

}
