/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiSearchVersionService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSearchVersionService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;

    public ApiSearchVersionService() {
        this.jsonSchemaFileName = "api_search_version_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String description = tStateCode.getDescription();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String tenantId = tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        Boolean isNew = Optional.ofNullable(tRequestJsonNode.get(ApiAttributeEnum.isNew.toString())).map(JsonNode::asBoolean).orElse(false);
        String branch = ObjectUtil.isNotNull((Object)tRequestJsonNode.get(ApiAttributeEnum.branch.toString())) ? tRequestJsonNode.get(ApiAttributeEnum.branch.toString()).asText() : "1.0";
        String tVersion = "1.0";
        String parentApiName = null;
        String parentBranch = null;
        String parentApiTenantId = null;
        StandardApi standardApi = this.standardApiDao.getByNameAndBranchAndTenantId(tApiName, branch, tenantId);
        if (ObjectUtil.isNull((Object)standardApi)) {
            tVersion = branch;
        } else if (isNew.booleanValue()) {
            tStateCode = this.getStateCode(ValidateStateEnum.API_NAME_EXISTS.getCode());
            description = String.format(tStateCode.getDescription(), tApiName);
            tVersion = null;
        } else {
            List<StandardApiVersion> standardApiVersionList = this.standardApiVersionDao.getVersionListByApiId(standardApi.getId());
            if (CollUtil.isNotEmpty(standardApiVersionList)) {
                standardApiVersionList.sort((o1, o2) -> o2.getApprovedTime().compareTo(o1.getApprovedTime()));
                StandardApiVersion standardApiVersion = standardApiVersionList.get(0);
                if (standardApiVersion.getApprovedStatus().getId() != 4L) {
                    tStateCode = this.getStateCode(ValidateStateEnum.API_PERV_VER_NOT_FIX.getCode());
                    description = String.format(tStateCode.getDescription(), tApiName, standardApiVersion.getVersion());
                    tVersion = null;
                } else {
                    try {
                        tVersion = ApiVersionServiceUtil.getNextVersion(standardApiVersion.getVersion());
                        parentApiName = standardApiVersion.getStandardApi().getParentApiName();
                        parentBranch = standardApiVersion.getStandardApi().getParentBranch();
                        parentApiTenantId = standardApiVersion.getStandardApi().getParentApiTenantId();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        tStateCode = this.getStateCode(ValidateStateEnum.API_VERSION_EXCEEDS_LIMIT.getCode());
                        description = tStateCode.getDescription();
                        tVersion = null;
                    }
                }
            }
        }
        tResponse.put("code", tStateCode.getCode());
        tResponse.put("description", description);
        tResponse.put(ApiAttributeEnum.version.toString(), tVersion);
        tResponse.put(ApiAttributeEnum.parentApiName.toString(), parentApiName);
        tResponse.put(ApiAttributeEnum.parentBranch.toString(), parentBranch);
        tResponse.put(ApiAttributeEnum.parentApiTenantId.toString(), parentApiTenantId);
        return tResponse;
    }
}

