/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@TableName(value="standard_api_version", resultMap="BaseResultMap")
public class StandardApiVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(value="approved_status")
    private Integer approvedStatusCode;
    @TableField(value="approved_acct")
    private String approvedAcct;
    @TableField(value="applicant")
    private String applicant;
    @TableField(value="user_id")
    private String userId;
    @TableField(value="idempotency")
    private Boolean idempotency;
    @TableField(exist=false)
    private ApprovedStatus approvedStatus;
    @TableField(value="approved_time")
    private LocalDateTime approvedTime;
    private String version;
    @TableField(exist=false)
    private List<StandardApiDataName> standardApiDataNames = new ArrayList<StandardApiDataName>();
    @TableField(value="api_id")
    private Long apiId;
    @TableField(exist=false)
    private StandardApi standardApi;
    @TableField(value="update_history")
    private String updateHistory;

    public void setId(Long id) {
        this.id = id;
        if (this.standardApiDataNames != null) {
            this.standardApiDataNames.forEach(v -> v.setStandardApiVersion(this));
        }
    }

    public void setStandardApi(StandardApi standardApi) {
        this.standardApi = standardApi;
        if (standardApi != null) {
            this.apiId = standardApi.getId();
        }
    }

    public void setApprovedStatus(ApprovedStatus approvedStatus) {
        this.approvedStatus = approvedStatus;
        if (approvedStatus != null) {
            this.approvedStatusCode = Optional.ofNullable(approvedStatus.getId()).map(Long::intValue).orElse(null);
        }
    }

    public StandardApiDataName addStandardApiDataName(StandardApiDataName standardApiDataName) {
        this.getStandardApiDataNames().add(standardApiDataName);
        standardApiDataName.setStandardApiVersion(this);
        return standardApiDataName;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Integer getApprovedStatusCode() {
        return this.approvedStatusCode;
    }

    @Generated
    public String getApprovedAcct() {
        return this.approvedAcct;
    }

    @Generated
    public String getApplicant() {
        return this.applicant;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public Boolean getIdempotency() {
        return this.idempotency;
    }

    @Generated
    public ApprovedStatus getApprovedStatus() {
        return this.approvedStatus;
    }

    @Generated
    public LocalDateTime getApprovedTime() {
        return this.approvedTime;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public List<StandardApiDataName> getStandardApiDataNames() {
        return this.standardApiDataNames;
    }

    @Generated
    public StandardApi getStandardApi() {
        return this.standardApi;
    }

    @Generated
    public String getUpdateHistory() {
        return this.updateHistory;
    }

    @Generated
    public void setApprovedStatusCode(Integer approvedStatusCode) {
        this.approvedStatusCode = approvedStatusCode;
    }

    @Generated
    public void setApprovedAcct(String approvedAcct) {
        this.approvedAcct = approvedAcct;
    }

    @Generated
    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setIdempotency(Boolean idempotency) {
        this.idempotency = idempotency;
    }

    @Generated
    public void setApprovedTime(LocalDateTime approvedTime) {
        this.approvedTime = approvedTime;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setStandardApiDataNames(List<StandardApiDataName> standardApiDataNames) {
        this.standardApiDataNames = standardApiDataNames;
    }

    @Generated
    public void setUpdateHistory(String updateHistory) {
        this.updateHistory = updateHistory;
    }

    @Generated
    public String toString() {
        return "StandardApiVersion(id=" + this.getId() + ", approvedStatusCode=" + this.getApprovedStatusCode() + ", approvedAcct=" + this.getApprovedAcct() + ", applicant=" + this.getApplicant() + ", userId=" + this.getUserId() + ", idempotency=" + this.getIdempotency() + ", approvedStatus=" + this.getApprovedStatus() + ", approvedTime=" + this.getApprovedTime() + ", version=" + this.getVersion() + ", standardApiDataNames=" + this.getStandardApiDataNames() + ", apiId=" + this.getApiId() + ", updateHistory=" + this.getUpdateHistory() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardApiVersion)) {
            return false;
        }
        StandardApiVersion other = (StandardApiVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$approvedStatusCode = this.getApprovedStatusCode();
        Integer other$approvedStatusCode = other.getApprovedStatusCode();
        if (this$approvedStatusCode == null ? other$approvedStatusCode != null : !((Object)this$approvedStatusCode).equals(other$approvedStatusCode)) {
            return false;
        }
        Boolean this$idempotency = this.getIdempotency();
        Boolean other$idempotency = other.getIdempotency();
        if (this$idempotency == null ? other$idempotency != null : !((Object)this$idempotency).equals(other$idempotency)) {
            return false;
        }
        Long this$apiId = this.getApiId();
        Long other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !((Object)this$apiId).equals(other$apiId)) {
            return false;
        }
        String this$approvedAcct = this.getApprovedAcct();
        String other$approvedAcct = other.getApprovedAcct();
        if (this$approvedAcct == null ? other$approvedAcct != null : !this$approvedAcct.equals(other$approvedAcct)) {
            return false;
        }
        String this$applicant = this.getApplicant();
        String other$applicant = other.getApplicant();
        if (this$applicant == null ? other$applicant != null : !this$applicant.equals(other$applicant)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        ApprovedStatus this$approvedStatus = this.getApprovedStatus();
        ApprovedStatus other$approvedStatus = other.getApprovedStatus();
        if (this$approvedStatus == null ? other$approvedStatus != null : !this$approvedStatus.equals(other$approvedStatus)) {
            return false;
        }
        LocalDateTime this$approvedTime = this.getApprovedTime();
        LocalDateTime other$approvedTime = other.getApprovedTime();
        if (this$approvedTime == null ? other$approvedTime != null : !((Object)this$approvedTime).equals(other$approvedTime)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$updateHistory = this.getUpdateHistory();
        String other$updateHistory = other.getUpdateHistory();
        return !(this$updateHistory == null ? other$updateHistory != null : !this$updateHistory.equals(other$updateHistory));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StandardApiVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $approvedStatusCode = this.getApprovedStatusCode();
        result = result * 59 + ($approvedStatusCode == null ? 43 : ((Object)$approvedStatusCode).hashCode());
        Boolean $idempotency = this.getIdempotency();
        result = result * 59 + ($idempotency == null ? 43 : ((Object)$idempotency).hashCode());
        Long $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : ((Object)$apiId).hashCode());
        String $approvedAcct = this.getApprovedAcct();
        result = result * 59 + ($approvedAcct == null ? 43 : $approvedAcct.hashCode());
        String $applicant = this.getApplicant();
        result = result * 59 + ($applicant == null ? 43 : $applicant.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        ApprovedStatus $approvedStatus = this.getApprovedStatus();
        result = result * 59 + ($approvedStatus == null ? 43 : $approvedStatus.hashCode());
        LocalDateTime $approvedTime = this.getApprovedTime();
        result = result * 59 + ($approvedTime == null ? 43 : ((Object)$approvedTime).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $updateHistory = this.getUpdateHistory();
        result = result * 59 + ($updateHistory == null ? 43 : $updateHistory.hashCode());
        return result;
    }

    @Generated
    public Long getApiId() {
        return this.apiId;
    }

    @Generated
    public void setApiId(Long apiId) {
        this.apiId = apiId;
    }

    public static enum Status {
        DRAFT(1),
        UNDER_REVIEW(2),
        DEVELOPING(3),
        COMFIRMED(4),
        DEACTIVATE(5);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public static List<Integer> needVerifyAcct() {
            return ListUtil.of((Object[])new Integer[]{Status.UNDER_REVIEW.code});
        }

        public static List<Integer> notNeedVerifyAcct() {
            return ListUtil.of((Object[])new Integer[]{Status.DRAFT.code, Status.UNDER_REVIEW.code, Status.DEVELOPING.code, Status.COMFIRMED.code, Status.DEACTIVATE.code});
        }

        @Generated
        public int getCode() {
            return this.code;
        }
    }
}

