package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSymbolConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JsonLoader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 進階查詢  服务于标准API查询
 * /restful/standard/apimgmt/AdvanceSearchApiList/Get
 */
@Slf4j
@Service
@Deprecated
public class AdvanceSearchApiListGetService {

    @Autowired
    ApiMgmtStandardApiDao standardApiDao;

    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;

    public AdvanceSearchApiListGetService() {
        super();
    }

    /**
     * 进阶查询
     *
     * @param validatorResult validatorResult
     * @return arraylist
     * @throws Exception Exception
     */
    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass() +
                ", 原始訊息: " + validatorResult);
        // 取得語系
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        // header沒傳語系的話，默認回傳英文
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        ArrayList<Map<String, Object>> tResponse = new ArrayList<>();
        JsonNode tRequestJsonNode = JsonLoader.fromString(validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.CONDITION_LIST);
        ArrayList<Map<String, String>> tConditionList = new ArrayList<>();
        String tProvider = null;
        String tStatus = null;
        // 判斷租戶是否可查看全部API
        boolean tViewAllApi = tenantConfigDao.viewAllApiTenantExist(tTenantId);
        // 用戶所屬租戶
        Map<String, String> tTenantIdCondition = new HashMap<>();
        tTenantIdCondition.put(ApimgmtConstant.TENANT, tTenantId);
        tConditionList.add(tTenantIdCondition);
        if (tConditionArrayNode.isArray()) {
            for (JsonNode tConditionNode : tConditionArrayNode) {
                Map<String, String> tConditionMap = new HashMap<>();
                String tCondition = tConditionNode.get(ApimgmtConstant.CONDITION).asText();
                // 取得字段內容放入tConditionMap
                switch (tCondition) {
                    case ApimgmtConstant.API_NAME:
                        tConditionMap.put(ApimgmtConstant.API_NAME, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_NAME_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_TAG:
                        tConditionMap.put(ApimgmtConstant.API_TAG, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_TAG_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_DATANAME:
                        tConditionMap.put(ApimgmtConstant.API_DATANAME, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_DATANAME_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_DESC:
                        tConditionMap.put(ApimgmtConstant.API_DESC, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_DESC_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_REMARK:
                        tConditionMap.put(ApimgmtConstant.API_REMARK, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_REMARK_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_SYNC_TYPE:
                        tConditionMap.put(ApimgmtConstant.API_SYNC_TYPE, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.API_CATEGORY:
                        tConditionMap.put(ApimgmtConstant.API_CATEGORY, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.PROVIDER:
                        tProvider = tConditionNode.get(ApimgmtConstant.CONTENT).asText();
                        tConditionMap.put(ApimgmtConstant.PROVIDER, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.TENANT_ID:
                        tConditionMap.put(ApimgmtConstant.TENANT_ID, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.TENANT_ID_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    case ApimgmtConstant.API_STATUS:
                        tStatus = tConditionNode.get(ApimgmtConstant.CONTENT).asText();
                        tConditionMap.put(ApimgmtConstant.API_STATUS, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        break;
                    case ApimgmtConstant.API_BUILD_TIME:
                        tConditionMap.put(ApimgmtConstant.API_BUILD_TIME, tConditionNode.get(ApimgmtConstant.CONTENT).asText());
                        tConditionMap.put(ApimgmtConstant.API_BUILD_TIME_EQ, tConditionNode.get(ApimgmtConstant.EQUATION).asText());
                        break;
                    default:
                        log.info("条件输入不成立!");
                        break;
                }
                tConditionList.add(tConditionMap);
            }
        }
        List<StandardApi> tStandardApiList = standardApiDao.advanceSearch(tConditionList, teamType, false, tViewAllApi);
        setResponse(tStandardApiList, tProvider, tStatus, tLocale, tResponse);
        return tResponse;
    }

    public void setResponse(List<StandardApi> tStandardApiList, String tProvider,
                            String tStatus, String tLocale, ArrayList<Map<String, Object>> tResponse) {
        if (tStandardApiList != null) {
            for (StandardApi tStandardApi : tStandardApiList) {
                boolean tProviderBoolean = false;
                if (tProvider != null) {
                    String tProviders = tStandardApi.getProvider().trim();
                    String[] tProviderArr = tProviders.split(ApimgmtSymbolConstant.COMMA);
                    for (String s : tProviderArr) {
                        if (s.trim().equals(tProvider)) {
                            tProviderBoolean = true;
                            break;
                        }
                    }
                } else {
                    tProviderBoolean = true;
                }
                if (tProviderBoolean) {
                    Map<String, Object> tApiMap = new HashMap<>();
                    List<StandardApiVersion> tStandardApiVersions = standardApiVersionDao.getVersionListByApiId(tStandardApi.getId());
                    StandardApiVersion tStandardApiVersion;
                    if (tStatus != null) {
                        // 取得相同狀態的Api version
                        List<StandardApiVersion> tStatusVersions = getStatus(tStandardApiVersions, Long.valueOf(tStatus));
                        tStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStatusVersions);
                    } else {
                        tStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStandardApiVersions);
                    }
                    String tApprovedStatus;
                    long tApprovedStatusCode;
                    String tDescription;
                    String tRemark;
                    String tSyncType;
                    String tCategory;
                    switch (tLocale) {
                        case ApimgmtConstant.ZH_CN:
                            tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                            tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                            tDescription = tStandardApi.getDescriptionZhCn();
                            tRemark = tStandardApi.getRemarkZhCn();
                            tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                            tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                            break;
                        case ApimgmtConstant.ZH_TW:
                            tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                            tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                            tDescription = tStandardApi.getDescriptionZhTw();
                            tRemark = tStandardApi.getRemarkZhTw();
                            tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                            tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                            break;
                        case ApimgmtConstant.EN_US:
                        default:
                            tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                            tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                            tDescription = tStandardApi.getDescriptionEnUs();
                            tRemark = tStandardApi.getRemarkEnUs();
                            tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                            tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                            break;
                    }
                    // 組成回傳訊息
                    tApiMap.put(ApimgmtConstant.NAME, tStandardApi.getName());
                    tApiMap.put(ApimgmtConstant.VERSION, tStandardApiVersion.getVersion());
                    tApiMap.put(ApimgmtConstant.APPROVED_STATUS, tApprovedStatus);
                    tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime(tStandardApiVersion.getApprovedTime()));
                    tApiMap.put(ApimgmtConstant.APPROVED_STATUS_CODE, tApprovedStatusCode);
                    tApiMap.put(ApimgmtConstant.DESCRIPTION, tDescription);
                    tApiMap.put(ApimgmtConstant.REMARK, tRemark);
                    tApiMap.put(ApimgmtConstant.SYNC_TYPE, tSyncType);
                    tApiMap.put(ApimgmtConstant.CATEGORY_ID, tStandardApi.getStandardApiCategory().getId());
                    tApiMap.put(ApimgmtConstant.CATEGORY_NAME, tCategory);
                    tApiMap.put(ApimgmtConstant.MSG_FORMAT, tStandardApi.getMsgFormat());
                    tApiMap.put(ApimgmtConstant.PROVIDER, tStandardApi.getProvider());
                    tApiMap.put(ApimgmtConstant.TENANT_ID, tStandardApi.getTenantId());
                    tApiMap.put(ApimgmtConstant.API_BUILD_ACCT, tStandardApi.getBuildAcct());
                    tApiMap.put(ApimgmtConstant.API_BUILD_TIME, DateUtil.formatLocalDateTime(tStandardApi.getBuildTime()));
                    // by songwq 20230625 获取首次申请的版本以及最新的版本以及设计租户ID
                    StandardApiVersion firstStandardApiVersion = ApiVersionServiceUtil.getFirstVersion(tStandardApiVersions);
                    StandardApiVersion curStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStandardApiVersions);
                    String firstV = firstStandardApiVersion.getVersion();
                    String lastV = curStandardApiVersion.getVersion();
                    tApiMap.put(ApimgmtConstant.FIRST_APPLICANT, firstStandardApiVersion.getApplicant());
                    // 如果首次与最后一次版本号相同，则无最后一次申请人
                    if (firstV.equals(lastV)) {
                        tApiMap.put(ApimgmtConstant.LAST_APPLICANT, "");
                    } else {
                        tApiMap.put(ApimgmtConstant.LAST_APPLICANT, tStandardApiVersion.getApplicant());
                    }
                    tApiMap.put(ApimgmtConstant.DESIGN_TENANT_ID, tStandardApiVersion.getStandardApi().getDesignTenantId());
                    tResponse.add(tApiMap);
                }
            }
        }
    }

    private List<StandardApiVersion> getStatus(List<StandardApiVersion> tStandardApiVersions, Long pStatus) {
        List<StandardApiVersion> tStatusVersions = new ArrayList<>();
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersions) {
            if (tStandardApiVersion.getApprovedStatus().getId().equals(pStatus)) {
                tStatusVersions.add(tStandardApiVersion);
            }
        }
        return tStatusVersions;
    }

}
