package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.*;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.*;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 取得API規格下拉選項欄位與清單值
 * /restful/standard/apimgmt/DropdownMenu/Get
 */
@Slf4j
@Service
public class ApiMgmtDropdownMenuGetService {


	ObjectMapper mapper = new ObjectMapper();

	@Autowired
    ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;

	@Autowired
    ApiMgmtStandardApiPagingDao standardApiPagingDao;

	@Autowired
    ApiMgmtProductCategoryDao productCategoryDao;

	@Autowired
    ApiMgmtStandardApiGroupDao standardApiGroupDao;

	@Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;

	@Autowired
    ApiMgmtRequiredDataNameDao requiredDataNameDao;

	public Map<String, Object> execute(String validatorResult) {
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口：" + this.getClass() + "，原始訊息：" + validatorResult);
		String tLocale = ApiMgmtServiceContextHolder.getLocale();
		// header沒傳語系的話，默認回傳英文
		tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
		Map<String, Object> tResponse = new HashMap<>();
		Map<String, Object> tDropdownMenuMap = new HashMap<>();
		List<StandardApiSyncType> tStandardApiSyncTypeList = standardApiSyncTypeDao.getAll();
		List<StandardApiPaging> tStandardApiPagingList = standardApiPagingDao.getAll();
		List<ProductCategory> tProductCategoryList = productCategoryDao.getAll();
		List<StandardApiGroup> tStandardApiGroupList = standardApiGroupDao.getAll();
		List<StandardApiCategory> tStandardApiCategoryList = standardApiCategoryDao.getAll();
		List<RequiredDataName> tRequiredDataNameList = requiredDataNameDao.getAll();
		List<StandardApiDataName> tStandardApiDataNameList = into(tRequiredDataNameList);
		// 同步模式
		ArrayList<Map<String, Object>> tApiSyncTypeArr = new ArrayList<>();
		for (StandardApiSyncType tStandardApiSyncType : tStandardApiSyncTypeList) {
			Map<String, Object> tMap = new HashMap<>();
			String tSyncTypeName;
			switch (tLocale) {
				case ApimgmtConstant.ZH_CN:
					tSyncTypeName = tStandardApiSyncType.getNameZhCn();
					break;
				case ApimgmtConstant.ZH_TW:
					tSyncTypeName = tStandardApiSyncType.getNameZhTw();
					break;
				case ApimgmtConstant.EN_US:
				default:
					tSyncTypeName = tStandardApiSyncType.getNameEnUs();
					break;
			}
			if (tStandardApiSyncType.getId() == 1) {
				tMap.put(ApimgmtConstant.ID, ApimgmtConstant.SYNC);
			} else if (tStandardApiSyncType.getId() == 2) {
				tMap.put(ApimgmtConstant.ID, ApimgmtConstant.FASYNC);
			}
			tMap.put(ApimgmtConstant.NAME, tSyncTypeName);
			tApiSyncTypeArr.add(tMap);
		}
		tDropdownMenuMap.put(ApimgmtConstant.API_SYNC_TYPE, tApiSyncTypeArr);
		// 分頁模式
		ArrayList<Map<String, Object>> tApiPagingArr = new ArrayList<>();
		for (StandardApiPaging tStandardApiPaging : tStandardApiPagingList) {
			Map<String, Object> tMap = new HashMap<>();
			String tPagingName;
			switch (tLocale) {
				case ApimgmtConstant.ZH_CN:
					tPagingName = tStandardApiPaging.getNameZhCn();
					break;
				case ApimgmtConstant.ZH_TW:
					tPagingName = tStandardApiPaging.getNameZhTw();
					break;
				case ApimgmtConstant.EN_US:
				default:
					tPagingName = tStandardApiPaging.getNameEnUs();
					break;
			}
			tMap.put(ApimgmtConstant.ID, tStandardApiPaging.getId());
			tMap.put(ApimgmtConstant.NAME, tPagingName);
			tApiPagingArr.add(tMap);
		}
		tDropdownMenuMap.put(ApimgmtConstant.API_PAGING, tApiPagingArr);
		// 發起方、接收方
		ArrayList<String> tProductArr = new ArrayList<>();
		for (ProductCategory tProductCategory : tProductCategoryList) {
			String tProductName;
			switch (tLocale) {
				case ApimgmtConstant.ZH_CN:
					tProductName = tProductCategory.getNameZhCn();
					break;
				case ApimgmtConstant.ZH_TW:
					tProductName = tProductCategory.getNameZhTw();
					break;
				case ApimgmtConstant.EN_US:
				default:
					tProductName = tProductCategory.getNameEnUs();
					break;
			}
			tProductArr.add(tProductName);
		}
		tDropdownMenuMap.put(ApimgmtConstant.REQUESTER, tProductArr);
		tDropdownMenuMap.put(ApimgmtConstant.PROVIDER, tProductArr);
		// 須分包
		ArrayList<String> tIsBatchArr = new ArrayList<>();
		tIsBatchArr.add(ApimgmtConstant.YES);
		tIsBatchArr.add(ApimgmtConstant.NO);
		tDropdownMenuMap.put(ApimgmtConstant.IS_BATCH, tIsBatchArr);
		// 信息大類
		ArrayList<Map<String, Object>> tApiGroupArr = new ArrayList<>();
		for (StandardApiGroup tStandardApiGroup : tStandardApiGroupList) {
			Map<String, Object> tMap = new HashMap<>();
			tMap.put(ApimgmtConstant.ID, tStandardApiGroup.getId());
			switch (tLocale) {
				case ApimgmtConstant.ZH_CN:
					tMap.put(ApimgmtConstant.NAME, tStandardApiGroup.getNameZhCn());
					break;
				case ApimgmtConstant.ZH_TW:
					tMap.put(ApimgmtConstant.NAME, tStandardApiGroup.getNameZhTw());
					break;
				case ApimgmtConstant.EN_US:
				default:
					tMap.put(ApimgmtConstant.NAME, tStandardApiGroup.getNameEnUs());
					break;
			}
			tApiGroupArr.add(tMap);
		}
		tDropdownMenuMap.put(ApimgmtConstant.API_GROUP, tApiGroupArr);
		// 信息類別
		ArrayList<Map<String, Object>> tApiCategoryArr = new ArrayList<>();
		for (StandardApiCategory tStandardApiCategory : tStandardApiCategoryList) {
			Map<String, Object> tMap = new HashMap<>();
			String tCategoryName;
			if (tLocale != null) {
				switch (tLocale) {
					case ApimgmtConstant.ZH_CN:
						tCategoryName = tStandardApiCategory.getNameZhCn();
						break;
					case ApimgmtConstant.ZH_TW:
						tCategoryName = tStandardApiCategory.getNameZhTw();
						break;
					case ApimgmtConstant.EN_US:
					default:
						tCategoryName = tStandardApiCategory.getNameEnUs();
						break;
				}
			} else {
				tCategoryName = tStandardApiCategory.getNameZhTw();
			}
			tMap.put(ApimgmtConstant.ID, tStandardApiCategory.getId());
			tMap.put(ApimgmtConstant.NAME, tCategoryName);
			tApiCategoryArr.add(tMap);
		}
		tDropdownMenuMap.put(ApimgmtConstant.API_CATEGORY, tApiCategoryArr);
		// 須分包
		ArrayList<String> tMsgFormatArr = new ArrayList<>();
		tMsgFormatArr.add(ApimgmtConstant.XML);
		tMsgFormatArr.add(ApimgmtConstant.JSON);
		tDropdownMenuMap.put(ApimgmtConstant.MSG_FORMAT, tMsgFormatArr);
		// 類型
		tDropdownMenuMap.put(ApimgmtConstant.COLUMN_TYPE, Arrays.asList(ApimgmtConstant.COLUMN_TYPE_ARRAY));
		// 型態
		tDropdownMenuMap.put(ApimgmtConstant.DATA_TYPE, Arrays.asList(ApimgmtConstant.DATE_TYPE_ARRAY));
		tResponse.put(ApimgmtConstant.DROPDOWN_MENU, tDropdownMenuMap);
		ObjectNode tResponseNode = mapper.createObjectNode();
		// Request信息内容
		ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.requestMessageSpec.toString(), 1, tLocale);
		// Response信息内容（成功）
		ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageSuccessSpec.toString(), 2, tLocale);
		// Response信息内容（失敗）
		ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageFailedSpec.toString(), 3, tLocale);
		Map<String, Object> tMessageSpecMap = converJsonNodeToMap(tResponseNode);
		for (String tKey : tMessageSpecMap.keySet()) {
			tResponse.put(tKey, tMessageSpecMap.get(tKey));
		}
		return tResponse;
	}

	private List<StandardApiDataName> into(List<RequiredDataName> pRequiredDataNameList) {
		List<StandardApiDataName> tStandardApiDataNameList = new ArrayList<>();
		for (RequiredDataName tRequiredDataName : pRequiredDataNameList) {
			StandardApiDataName tStandardApiDataName = new StandardApiDataName();
			tStandardApiDataName.setId(tRequiredDataName.getId());
			tStandardApiDataName.setMsgType(tRequiredDataName.getMsgType());
			tStandardApiDataName.setColumnType(tRequiredDataName.getColumnType());
			tStandardApiDataName.setStandardDataName(tRequiredDataName.getDataName());
			tStandardApiDataName.setDescriptionZhTw(tRequiredDataName.getDescriptionZhTw());
			tStandardApiDataName.setDescriptionZhCn(tRequiredDataName.getDescriptionZhCn());
			tStandardApiDataName.setDescriptionEnUs(tRequiredDataName.getDescriptionEnUs());
			tStandardApiDataName.setDataType(tRequiredDataName.getDataType());
			tStandardApiDataName.setIsRequired(tRequiredDataName.getIsRequired());
			tStandardApiDataName.setValue(tRequiredDataName.getValue());
			tStandardApiDataName.setRemarkZhTw(tRequiredDataName.getRemarkZhTw());
			tStandardApiDataName.setRemarkZhCn(tRequiredDataName.getRemarkZhCn());
			tStandardApiDataName.setRemarkEnUs(tRequiredDataName.getRemarkEnUs());
			tStandardApiDataName.setIsDatakey(tRequiredDataName.getIsDatakey());
			tStandardApiDataName.setIsArray(tRequiredDataName.getIsArray());
			tStandardApiDataName.setCanSort(tRequiredDataName.getCanSort());
			tStandardApiDataName.setCanFilter(tRequiredDataName.getCanFilter());
			tStandardApiDataName.setIsBusinesskey(tRequiredDataName.getIsBusinesskey());
			tStandardApiDataName.setListEnumZhTw(tRequiredDataName.getListEnumZhTw());
			tStandardApiDataName.setListEnumZhCn(tRequiredDataName.getListEnumZhCn());
			tStandardApiDataName.setListEnumEn(tRequiredDataName.getListEnumEn());
			tStandardApiDataNameList.add(tStandardApiDataName);
		}
		return tStandardApiDataNameList;
	}

	private Map<String, Object> converJsonNodeToMap(JsonNode pJsonNode) {
		return mapper.convertValue(pJsonNode, new TypeReference<Map<String, Object>>() {
		});
	}
}
