/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.apimgmt.dao.GenericDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.BaseMapperPlus;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class GenericDaoMybatisImpl<M extends BaseMapperPlus<T>, T, PK extends Serializable>
implements GenericDao<T, PK> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericDaoMybatisImpl.class);
    protected M baseMapper;
    protected ServiceImpl<M, T> batchService;
    protected Class<T> entityClass = ReflectionKit.getSuperClassGenericType(this.getClass(), GenericDaoMybatisImpl.class, (int)1);

    @Override
    public List<T> getAll() {
        return this.baseMapper.selectList(null);
    }

    @Override
    public T get(PK id) {
        Object entity = this.baseMapper.selectById(id);
        if (entity == null) {
            log.warn("Uh oh, '{}' object with id '{}' not found...", this.entityClass, id);
            throw new RuntimeException("Entity not found with id: " + id);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        return this.baseMapper.selectById(id) != null;
    }

    @Override
    @Transactional
    public T save(T object) {
        if (null != object) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
            Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
            Object idVal = tableInfo.getPropertyValue(object, tableInfo.getKeyProperty());
            if (StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.baseMapper.selectById((Serializable)idVal))) {
                this.baseMapper.insert(object);
            } else {
                this.baseMapper.updateById(object);
            }
            return object;
        }
        return null;
    }

    @Override
    public void remove(PK id) {
        this.baseMapper.deleteById(id);
    }

    @Override
    @Transactional
    public void saveOrupdate(T object) {
        this.save(object);
    }

    @Autowired
    public void setBaseMapper(M baseMapper) {
        this.baseMapper = baseMapper;
        this.batchService = new BatchService(this, baseMapper);
    }

    public static class BatchService
    extends ServiceImpl<M, T> {
        final /* synthetic */ GenericDaoMybatisImpl this$0;

        public BatchService(M baseMapper) {
            this.this$0 = this$0;
            this.baseMapper = baseMapper;
        }

        protected Class<M> currentMapperClass() {
            return this.this$0.baseMapper.getClass().getInterfaces()[0];
        }

        protected Class<T> currentModelClass() {
            return ReflectionKit.getSuperClassGenericType(this.this$0.baseMapper.getClass(), BaseMapperPlus.class, (int)0);
        }
    }
}

