/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.auth.IApiMgmtIdentityService;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtIamVerifyService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiDetailGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDetailGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;
    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;
    @Autowired
    private ApiMgmtProjectDao projectDao;
    @Autowired
    private ApiMgmtIamVerifyService iamVerifyService;
    @Autowired
    private ApiMgmtProp prop;
    @Autowired
    private ApiMgmtProjectVersionDao projectVersionDao;
    @Autowired
    private IApiMgmtIdentityService identityService;

    public ApiDetailGetService() {
        this.jsonSchemaFileName = "api_detail_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String tVersion = "";
        String branch = "1.0";
        if (tRequestJsonNode.has(ApiAttributeEnum.version.toString())) {
            tVersion = tRequestJsonNode.get(ApiAttributeEnum.version.toString()).asText();
            branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        }
        String tTenant = "";
        if (tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        String pTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        boolean tViewAllApi = this.tenantConfigDao.viewAllApiTenantExist(pTenantId);
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, pTenantId, tTenant, teamType, tViewAllApi);
        StandardApiVersion tStandardApiVersion = null;
        if (CollUtil.isEmpty(tStandardApiVersionList) && this.prop.isEnvType() && !tApiName.startsWith("dw.paas.")) {
            tApiName = "dw.paas." + tApiName;
            tStandardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, pTenantId, tTenant, teamType, tViewAllApi);
        }
        if (StrUtil.isNotBlank((CharSequence)tVersion)) {
            for (StandardApiVersion standardApiVersion : tStandardApiVersionList) {
                if (!standardApiVersion.getVersion().equals(tVersion)) continue;
                tStandardApiVersion = standardApiVersion;
            }
        } else if (CollUtil.isNotEmpty(tStandardApiVersionList)) {
            tStandardApiVersionList.sort((o1, o2) -> o2.getApprovedTime().compareTo(o1.getApprovedTime()));
            tStandardApiVersion = tStandardApiVersionList.get(0);
        }
        if (tStandardApiVersion != null) {
            String tCategoryName;
            String tGroupName;
            String tApiTag;
            String tApiRemark;
            String tApiDescription;
            String tApprovedStatus;
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            String apiType = tStandardApi.getApiType();
            String protocol = tStandardApi.getProtocol();
            String apiPath = tStandardApi.getApiPath();
            String requestMethod = tStandardApi.getRequestMethod();
            String tApiNameResponse = tStandardApi.getName();
            String tParentApiNameResponse = tStandardApi.getParentApiName();
            String tParentBranchResponse = tStandardApi.getParentBranch();
            String tParentApiTenantIdResponse = tStandardApi.getParentApiTenantId();
            String tApiVersionString = tStandardApiVersion.getVersion();
            String tApplicant = tStandardApiVersion.getApplicant();
            String tEditHistory = tStandardApiVersion.getUpdateHistory() == null ? "" : tStandardApiVersion.getUpdateHistory();
            String tInvokeType = tStandardApi.getStandardApiSyncType().getNameEnUs();
            String tRequester = tStandardApi.getRequester();
            String tProvider = tStandardApi.getProvider();
            Long tPaging = tStandardApi.getStandardApiPaging().getId();
            int tStatusId = tStandardApiVersion.getApprovedStatus().getId().intValue();
            String approvedTime = DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime());
            int tCategoryId = tStandardApi.getStandardApiCategory().getId().intValue();
            int tGroup = tStandardApi.getStandardApiGroup().getId().intValue();
            String tIsBatch = tStandardApi.getIsBatch() != false ? "Y" : "N";
            String tIdempotency = tStandardApiVersion.getIdempotency() != false ? "Y" : "N";
            String tMsgFormat = tStandardApi.getMsgFormat();
            String tTenantId = tStandardApi.getTenantId() != null || StringUtil.isEmptyOrSpace((Object)tStandardApi.getTenantId()) ? tStandardApi.getTenantId() : "";
            switch (tLocale) {
                case "zh_CN": {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                    tApiDescription = tStandardApi.getDescriptionZhCn();
                    tApiRemark = tStandardApi.getRemarkZhCn();
                    tApiTag = tStandardApi.getTagZhCn() == null ? "" : tStandardApi.getTagZhCn();
                    tGroupName = tStandardApi.getStandardApiGroup().getNameZhCn();
                    tCategoryName = tStandardApi.getStandardApiCategory().getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                    tApiDescription = tStandardApi.getDescriptionZhTw();
                    tApiRemark = tStandardApi.getRemarkZhTw();
                    tApiTag = tStandardApi.getTagZhTw() == null ? "" : tStandardApi.getTagZhTw();
                    tGroupName = tStandardApi.getStandardApiGroup().getNameZhTw();
                    tCategoryName = tStandardApi.getStandardApiCategory().getNameZhTw();
                    break;
                }
                default: {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                    tApiDescription = tStandardApi.getDescriptionEnUs();
                    tApiRemark = tStandardApi.getRemarkEnUs();
                    tApiTag = tStandardApi.getTagEnUs() == null ? "" : tStandardApi.getTagEnUs();
                    tGroupName = tStandardApi.getStandardApiGroup().getNameEnUs();
                    tCategoryName = tStandardApi.getStandardApiCategory().getNameEnUs();
                }
            }
            ObjectNode tApiDescriptionMultilingualNode = this.mapper.createObjectNode();
            tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getDescriptionZhTw());
            tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getDescriptionZhCn());
            tApiDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getDescriptionEnUs());
            tResponseNode.set(ApiAttributeEnum.apiDescriptionMultilingual.toString(), (JsonNode)tApiDescriptionMultilingualNode);
            ObjectNode tApiRemarkMultilingualNode = this.mapper.createObjectNode();
            tApiRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getRemarkZhTw());
            tApiRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getRemarkZhCn());
            tApiRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getRemarkEnUs());
            tResponseNode.set(ApiAttributeEnum.apiRemarkMultilingual.toString(), (JsonNode)tApiRemarkMultilingualNode);
            ObjectNode tApiTagMultilingualNode = this.mapper.createObjectNode();
            tApiTagMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getTagZhTw() == null ? "" : tStandardApi.getTagZhTw());
            tApiTagMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getTagZhCn() == null ? "" : tStandardApi.getTagZhCn());
            tApiTagMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getTagEnUs() == null ? "" : tStandardApi.getTagEnUs());
            tResponseNode.set(ApiAttributeEnum.apiTagMultilingual.toString(), (JsonNode)tApiTagMultilingualNode);
            tResponseNode.put(ApiAttributeEnum.apiName.toString(), tApiNameResponse);
            tResponseNode.put(ApiAttributeEnum.apiId.toString(), tStandardApi.getId());
            tResponseNode.put(ApiAttributeEnum.apiType.toString(), apiType);
            tResponseNode.put(ApiAttributeEnum.branch.toString(), branch);
            tResponseNode.put(ApiAttributeEnum.apiPath.toString(), apiPath);
            tResponseNode.put(ApiAttributeEnum.protocol.toString(), protocol);
            tResponseNode.put(ApiAttributeEnum.requestMethod.toString(), requestMethod);
            List<ProjectVersionRelation> projectVersionRelationList = this.projectVersionRelationDao.getByApiId(tStandardApiVersion.getStandardApi().getId());
            if (CollUtil.isNotEmpty(projectVersionRelationList)) {
                ProjectVersionRelation projectVersionRelation = projectVersionRelationList.get(0);
                tResponseNode.put(ApiAttributeEnum.projectId.toString(), projectVersionRelation.getProjectId());
                tResponseNode.put(ApiAttributeEnum.projectName.toString(), ((Project)this.projectDao.get(projectVersionRelation.getProjectId())).getProjectName());
                tResponseNode.put(ApiAttributeEnum.hasVersions.toString(), !this.projectVersionDao.getByProjectId(projectVersionRelation.getProjectId()).isEmpty());
                List<Long> projectVersionIdList = projectVersionRelationList.stream().map(ProjectVersionRelation::getProjectVersionId).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(projectVersionIdList)) {
                    ArrayNode projectVersionIdArrayNode = this.mapper.createArrayNode();
                    Iterator iterator = projectVersionIdList.iterator();
                    while (iterator.hasNext()) {
                        Long projectVersionId = (Long)iterator.next();
                        projectVersionIdArrayNode.add(projectVersionId);
                    }
                    tResponseNode.set(ApiAttributeEnum.projectVersionIdList.toString(), (JsonNode)projectVersionIdArrayNode);
                    List<ProjectVersion> projectVersionList = this.projectVersionDao.queryProjectVersionByIdList(projectVersionIdList);
                    ArrayNode projectVersionNameArrayNode = this.mapper.createArrayNode();
                    for (ProjectVersion projectVersion : projectVersionList) {
                        projectVersionNameArrayNode.add(projectVersion.getProjectVersionName());
                    }
                    tResponseNode.set(ApiAttributeEnum.projectVersionNameList.toString(), (JsonNode)projectVersionNameArrayNode);
                }
            } else {
                tResponseNode.put(ApiAttributeEnum.projectId.toString(), 1L);
                tResponseNode.put(ApiAttributeEnum.projectName.toString(), "Athena");
            }
            tResponseNode.put(ApiAttributeEnum.parentApiName.toString(), tParentApiNameResponse);
            tResponseNode.put(ApiAttributeEnum.parentBranch.toString(), tParentBranchResponse);
            tResponseNode.put(ApiAttributeEnum.parentApiTenantId.toString(), tParentApiTenantIdResponse);
            tResponseNode.put(ApiAttributeEnum.apiDescription.toString(), tApiDescription);
            tResponseNode.put(ApiAttributeEnum.apiTag.toString(), tApiTag);
            tResponseNode.put(ApiAttributeEnum.apiRemark.toString(), tApiRemark);
            tResponseNode.put(ApiAttributeEnum.apiVersion.toString(), tApiVersionString);
            tResponseNode.put(ApiAttributeEnum.tenantId.toString(), tTenantId);
            tResponseNode.put(ApiAttributeEnum.applicant.toString(), tApplicant);
            tResponseNode.put(ApiAttributeEnum.approvedStatus.toString(), tApprovedStatus);
            tResponseNode.put(ApiAttributeEnum.approvedTime.toString(), approvedTime);
            tResponseNode.put(ApiAttributeEnum.editHistory.toString(), tEditHistory);
            tResponseNode.put(ApiAttributeEnum.requester.toString(), tRequester);
            tResponseNode.put(ApiAttributeEnum.provider.toString(), tProvider);
            tResponseNode.put(ApiAttributeEnum.idempotency.toString(), tIdempotency);
            tResponseNode.put(ApiAttributeEnum.invokeType.toString(), tInvokeType);
            tResponseNode.put(ApiAttributeEnum.paging.toString(), tPaging);
            tResponseNode.put(ApiAttributeEnum.statusId.toString(), tStatusId);
            tResponseNode.put(ApiAttributeEnum.categoryId.toString(), tCategoryId);
            tResponseNode.put(ApiAttributeEnum.categoryName.toString(), tCategoryName);
            tResponseNode.put(ApiAttributeEnum.group.toString(), tGroup);
            tResponseNode.put(ApiAttributeEnum.groupName.toString(), tGroupName);
            tResponseNode.put(ApiAttributeEnum.isBatch.toString(), tIsBatch);
            tResponseNode.put(ApiAttributeEnum.msgFormat.toString(), tMsgFormat);
            tResponseNode.put(ApiAttributeEnum.designTenantId.toString(), tStandardApi.getDesignTenantId());
            if (StrUtil.isNotBlank((CharSequence)tStandardApi.getDesignTenantId())) {
                try {
                    tResponseNode.put(ApiAttributeEnum.designTenantName.toString(), this.identityService.getTenantName(tStandardApi.getDesignTenantId()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayNode tApiVersionListAryNode = this.mapper.createArrayNode();
            for (StandardApiVersion standardApiVersion : tStandardApiVersionList) {
                tApiVersionListAryNode.add(standardApiVersion.getVersion());
            }
            tResponseNode.set(ApiAttributeEnum.apiVersionList.toString(), (JsonNode)tApiVersionListAryNode);
            ObjectNode tMessageExampleDownloadNode = this.mapper.createObjectNode();
            ObjectNode tRequesterSideNode = this.mapper.createObjectNode();
            ObjectNode tProviderSideNode = this.mapper.createObjectNode();
            ArrayNode tHostProductAryNode = this.mapper.createArrayNode();
            ArrayNode tServiceProductAryNode = this.mapper.createArrayNode();
            ArrayNode tMsgFormatAryNode = this.mapper.createArrayNode();
            tResponseNode.set(ApiAttributeEnum.messageExampleDownload.toString(), (JsonNode)tMessageExampleDownloadNode);
            tMessageExampleDownloadNode.set(ApiAttributeEnum.requesterSide.toString(), (JsonNode)tRequesterSideNode);
            tMessageExampleDownloadNode.set(ApiAttributeEnum.providerSide.toString(), (JsonNode)tProviderSideNode);
            tRequesterSideNode.set(ApiAttributeEnum.hostProduct.toString(), (JsonNode)tHostProductAryNode);
            tRequesterSideNode.set(ApiAttributeEnum.serviceProduct.toString(), (JsonNode)tServiceProductAryNode);
            tRequesterSideNode.set(ApiAttributeEnum.msgFormat.toString(), (JsonNode)tMsgFormatAryNode);
            tProviderSideNode.set(ApiAttributeEnum.hostProduct.toString(), (JsonNode)tHostProductAryNode);
            tProviderSideNode.set(ApiAttributeEnum.serviceProduct.toString(), (JsonNode)tServiceProductAryNode);
            tProviderSideNode.set(ApiAttributeEnum.msgFormat.toString(), (JsonNode)tMsgFormatAryNode);
            String[] tRequesterProducts = tStandardApi.getRequester().split(",");
            String[] tProviderProducts = tStandardApi.getProvider().split(",");
            for (String tRequester1 : tRequesterProducts) {
                tHostProductAryNode.add(tRequester1);
            }
            for (String tProvider1 : tProviderProducts) {
                tServiceProductAryNode.add(tProvider1);
            }
            if (StrUtil.isNotBlank((CharSequence)tMsgFormat)) {
                Arrays.stream(tMsgFormat.split(",")).forEach(s -> tMsgFormatAryNode.add(s));
            }
            List<StandardApiDataName> tStandardApiDataNameList = this.standardApiDataNameDao.getByApiVerId(tStandardApiVersion.getId(), true);
            tStandardApiDataNameList = tStandardApiDataNameList.stream().distinct().collect(Collectors.toList());
            ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.requestMessageSpec.toString(), 1, tLocale);
            ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageSuccessSpec.toString(), 2, tLocale);
            ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageFailedSpec.toString(), 3, tLocale);
        } else {
            tStateCode = this.getStateCode(ValidateStateEnum.API_NAME_VER_NOTFOUND.getCode());
        }
        String tDescription = tStateCode.getDescription();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

