/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.DeveloperRoleEnum;
import com.digiwin.athena.apimgmt.enums.GeneratedApiMessageComponentEnum;
import com.digiwin.athena.apimgmt.enums.GeneratedApiMessageMockValEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.MessageTextSampleTypeEnum;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.util.DigestUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardApiMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiMessageService.class);
    @Autowired
    private ApiMgmtStandardApiVersionDao apiVersionDao;
    @Autowired
    private ApiMgmtStandardApiDataNameDao apiDataNameDao;
    public final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public Map<Integer, List<StandardApiDataName>> getMsgTypeMap(Map<String, StandardApiDataName> pAddDataName) {
        ArrayList<StandardApiDataName> tAddDataNameList = new ArrayList<StandardApiDataName>();
        for (String tKey : pAddDataName.keySet()) {
            tAddDataNameList.add(pAddDataName.get(tKey));
        }
        return this.getMsgTypeMap(tAddDataNameList);
    }

    public Map<Integer, List<StandardApiDataName>> getMsgTypeMap(List<StandardApiDataName> plistOfNodes) {
        HashMap<Integer, List<StandardApiDataName>> tMap = new HashMap<Integer, List<StandardApiDataName>>();
        ArrayList<StandardApiDataName> tlistOfHierarchyNodesRequest = new ArrayList<StandardApiDataName>();
        ArrayList<StandardApiDataName> tlistOfHierarchyNodesResponseSuccess = new ArrayList<StandardApiDataName>();
        ArrayList<StandardApiDataName> tlistOfHierarchyNodesResponseFailed = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tApiDataName : plistOfNodes) {
            switch (tApiDataName.getMsgType()) {
                case 1: {
                    tlistOfHierarchyNodesRequest.add(tApiDataName);
                    break;
                }
                case 2: {
                    tlistOfHierarchyNodesResponseSuccess.add(tApiDataName);
                    break;
                }
                case 3: {
                    tlistOfHierarchyNodesResponseFailed.add(tApiDataName);
                    break;
                }
            }
        }
        tMap.put(1, tlistOfHierarchyNodesRequest);
        tMap.put(2, tlistOfHierarchyNodesResponseSuccess);
        tMap.put(3, tlistOfHierarchyNodesResponseFailed);
        return tMap;
    }

    public List<StandardApiDataName> generateListOfHierarchyNodes(List<StandardApiDataName> pListOfNodes, Long pApVerid) {
        ArrayList<StandardApiDataName> listOfHierarchyNodes = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tApiDataName : pListOfNodes) {
            if (tApiDataName.getParentId() != null) continue;
            if (null != pApVerid) {
                this.addAllNodes(tApiDataName, pListOfNodes);
            }
            listOfHierarchyNodes.add(tApiDataName);
        }
        return listOfHierarchyNodes;
    }

    public Map<String, String> generateStandardApiMessage(Long pApVerid, StandardApi pStandardApi, String pMsgFormat, String pHostProd, String pServiceProd, String tSampleType, String pDeveloperRole, String pCustomUUID, String tLocale) {
        String tApiVersionNumber;
        StandardApi tStandardApi;
        Integer tMessageType = MessageTextSampleTypeEnum.toStdApiDataNameMsgType((String)tSampleType);
        MessageTextSampleTypeEnum tMessageTextSampleTypeEnum = MessageTextSampleTypeEnum.toEnum((String)tSampleType);
        List<Object> listOfNodes = new ArrayList();
        if (pApVerid == null && pStandardApi != null) {
            for (StandardApiDataName tStandardApiDataName : pStandardApi.getStandardApiVersions().get(0).getStandardApiDataNames()) {
                if (!tStandardApiDataName.getMsgType().equals(tMessageType)) continue;
                listOfNodes.add(tStandardApiDataName);
            }
            tStandardApi = pStandardApi;
            tApiVersionNumber = tStandardApi.getStandardApiVersions().get(0).getVersion();
        } else {
            tStandardApi = ((StandardApiVersion)this.apiVersionDao.get(pApVerid)).getStandardApi();
            tApiVersionNumber = ((StandardApiVersion)this.apiVersionDao.get(pApVerid)).getVersion();
            listOfNodes = this.apiDataNameDao.getByApiVerIdAndMsgType(pApVerid, tMessageType, true);
        }
        String tApiName = tStandardApi.getName();
        List<StandardApiDataName> listOfHierarchyNodes = this.generateListOfHierarchyNodes(listOfNodes, pApVerid);
        String tMessageGenerated = null;
        if (pMsgFormat.equals(MessageFormatEnum.XML.getMsgFormat())) {
            tMessageGenerated = this.transTreeNodeToXMLString(tStandardApi, tMessageTextSampleTypeEnum, listOfHierarchyNodes, tApiName, pHostProd, pServiceProd, pDeveloperRole, tStandardApi.getIsBatch(), tStandardApi.getMsgMdata(), pCustomUUID, tLocale);
        } else if (pMsgFormat.equals(MessageFormatEnum.JSON.getMsgFormat())) {
            tMessageGenerated = this.transTreeNodeToJSONString(tStandardApi, tMessageTextSampleTypeEnum, listOfHierarchyNodes, tApiName, pHostProd, pServiceProd, pDeveloperRole, tStandardApi.getIsBatch(), pCustomUUID, GeneratedApiMessageComponentEnum.ALL, GeneratedApiMessageMockValEnum.DESCRIPTION, null, tLocale);
        } else if (pMsgFormat.equals(MessageFormatEnum.JSON10.getMsgFormat())) {
            tMessageGenerated = this.transTreeNodeToV1JSONString(tStandardApi, tMessageTextSampleTypeEnum, listOfHierarchyNodes, tApiName, pHostProd, pServiceProd, GeneratedApiMessageMockValEnum.DESCRIPTION, null, tLocale);
        }
        HashMap<String, String> tMessageMap = new HashMap<String, String>();
        tMessageMap.put("MESSAGE_GENERATED", tMessageGenerated);
        tMessageMap.put("API_NAME", tApiName);
        tMessageMap.put("API_VERSION_NUMBER", tApiVersionNumber);
        return tMessageMap;
    }

    public void addAllNodes(StandardApiDataName pParent, List<StandardApiDataName> pListOfNodes) {
        ArrayList<StandardApiDataName> tChildrens = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tApiDataName : pListOfNodes) {
            if (tApiDataName.getParentId() == null || !pParent.getId().equals(tApiDataName.getParentId())) continue;
            tChildrens.add(tApiDataName);
            this.addAllNodes(tApiDataName, pListOfNodes);
        }
        pParent.setChildrens(tChildrens);
    }

    public String transTreeNodeToXMLString(StandardApi standardApi, MessageTextSampleTypeEnum tMessageTextSampleTypeEnum, List<StandardApiDataName> pStandardApiDataNames, String pApiName, String pHostProd, String pServiceProd, String pDeveloperRole, boolean pIsBatch, boolean pMsgMdata, String pCustomUUID, String tLocale) {
        Document tDocument = DocumentHelper.createDocument();
        if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
            Element tRootElement = tDocument.addElement("request");
            if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
                tRootElement.addAttribute("key", "");
                if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
                    tRootElement.addAttribute("type", "sync");
                } else {
                    tRootElement.addAttribute("type", "fasync");
                }
            } else if (DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
                tRootElement.addAttribute("id", pCustomUUID);
            }
            Element hostElement = tRootElement.addElement("host");
            hostElement.addAttribute("prod", pHostProd);
            hostElement.addAttribute("ver", "1.0");
            hostElement.addAttribute("ip", "10.40.71.91");
            hostElement.addAttribute("acct", "user01");
            hostElement.addAttribute("timestamp", "20151211123204361");
            Element serviceElement = tRootElement.addElement("service");
            serviceElement.addAttribute("prod", pServiceProd);
            serviceElement.addAttribute("name", pApiName);
            Element datakeyElement = tRootElement.addElement("datakey");
            Element payloadElement = tRootElement.addElement("payload");
            if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
                String tSecurityKey = "28682266";
                Pattern tRegexP = Pattern.compile("<host[\\s]*[\\w=\"\\s\\./\\-+,:%\\*@\\|#!$\\[\\]^()\\{\\}~\\?;']*>[\\s]*<service[\\s]*[\\w=\"\\s\\./\\-+,:%\\*@\\|#!$\\[\\]^()\\{\\}~\\?;']*>");
                Matcher tMatch = tRegexP.matcher(tDocument.asXML());
                Object tSrcStr = "X";
                if (tMatch.find()) {
                    tSrcStr = tMatch.group();
                }
                String tHashCode = DigestUtil.getDigestCode((String)"MD5", (String)((String)tSrcStr + tSecurityKey));
                tRootElement.addAttribute("key", tHashCode);
            }
            Element paramElement = payloadElement.addElement("param");
            paramElement.addAttribute("key", "std_data");
            paramElement.addAttribute("type", "xml");
            Element dataRequestElement = paramElement.addElement("data_request");
            Element dataInfoElement = dataRequestElement.addElement("datainfo");
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                Element parameterElement;
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    parameterElement = dataInfoElement.addElement("parameter");
                    if (pMsgMdata) {
                        parameterElement.addAttribute("key", tStandardApiDataName.getStandardDataName() + "_data");
                    } else {
                        parameterElement.addAttribute("key", tStandardApiDataName.getStandardDataName());
                    }
                    parameterElement.addAttribute("type", "data");
                    Element dataElement = parameterElement.addElement("data");
                    dataElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        Element rowElement = dataElement.addElement("row");
                        rowElement.addAttribute("seq", "1");
                        this.generateAllSubNodeXmlString(tStandardApiDataName, rowElement, datakeyElement, tLocale);
                        continue;
                    }
                    this.generateAllSubNodeXmlString(tStandardApiDataName, dataElement, datakeyElement, tLocale);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    parameterElement = dataInfoElement.addElement("parameter");
                    parameterElement.addAttribute("key", tStandardApiDataName.getStandardDataName());
                    parameterElement.addAttribute("type", tStandardApiDataName.getDataType());
                    this.setValue(tStandardApiDataName, tLocale, parameterElement);
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    Element keyElement = datakeyElement.addElement("key");
                    keyElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                    this.setValue(tStandardApiDataName, tLocale, keyElement);
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                Element keyElement = datakeyElement.addElement("key");
                keyElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                this.setValue(tStandardApiDataName, tLocale, keyElement);
            }
            if (datakeyElement.elements().size() == 0) {
                tRootElement.remove(datakeyElement);
            }
        } else if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_FAILED.equals((Object)tMessageTextSampleTypeEnum)) {
            boolean paramResExist = false;
            boolean datainfoExit = false;
            Element tResponseElement = tDocument.addElement("response");
            if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
                if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum)) {
                    Element codeElement = tResponseElement.addElement("code");
                    codeElement.addText("019");
                    Element messageElement = tResponseElement.addElement("message");
                    messageElement.setText("EAI Response:\u5e73\u53f0\u56de\u8986\u540c\u6b65\u7d50\u679c");
                }
                Element reqIdElement = tResponseElement.addElement("reqid");
                reqIdElement.addText(pCustomUUID);
            }
            Element srvverElement = tResponseElement.addElement("srvver");
            srvverElement.addText("1.0");
            Element srvcodeElement = tResponseElement.addElement("srvcode");
            Element datakeyElement = tResponseElement.addElement("datakey");
            if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum)) {
                srvcodeElement.addText("000");
            } else {
                srvcodeElement.addText("100");
            }
            Element payloadElement = tResponseElement.addElement("payload");
            Element dataResponseElement = null;
            Element dataInfoResElement = null;
            Element statusElement = null;
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                Element parameterElement;
                if (!paramResExist) {
                    Element paramElement = payloadElement.addElement("param");
                    paramElement.addAttribute("key", "std_data");
                    paramElement.addAttribute("type", "xml");
                    dataResponseElement = paramElement.addElement("data_response");
                    Element exeElement = dataResponseElement.addElement("execution");
                    statusElement = exeElement.addElement("status");
                    paramResExist = true;
                }
                if (!tStandardApiDataName.getColumnType().equals("E") && !datainfoExit) {
                    dataInfoResElement = dataResponseElement.addElement("datainfo");
                    datainfoExit = true;
                }
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    parameterElement = dataInfoResElement.addElement("parameter");
                    if (pMsgMdata) {
                        parameterElement.addAttribute("key", tStandardApiDataName.getStandardDataName() + "_data");
                    } else {
                        parameterElement.addAttribute("key", tStandardApiDataName.getStandardDataName());
                    }
                    parameterElement.addAttribute("type", "data");
                    Element dataElement = parameterElement.addElement("data");
                    dataElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                    if (pIsBatch) {
                        dataElement.addAttribute("cnt", "\u7576\u524d\u56de\u50b3\u8cc7\u6599\u7b46\u6578");
                        dataElement.addAttribute("tt_cnt", "\u61c9\u56de\u50b3\u7684\u8cc7\u6599\u7e3d\u7b46\u6578");
                    }
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        Element rowElement = dataElement.addElement("row");
                        rowElement.addAttribute("seq", "1");
                        this.generateAllSubNodeXmlString(tStandardApiDataName, rowElement, datakeyElement, tLocale);
                        continue;
                    }
                    this.generateAllSubNodeXmlString(tStandardApiDataName, dataElement, datakeyElement, tLocale);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    parameterElement = dataInfoResElement.addElement("parameter");
                    parameterElement.addAttribute("key", tStandardApiDataName.getStandardDataName());
                    parameterElement.addAttribute("type", tStandardApiDataName.getDataType());
                    this.setValue(tStandardApiDataName, tLocale, parameterElement);
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    Element keyElement = datakeyElement.addElement("key");
                    keyElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                    this.setValue(tStandardApiDataName, tLocale, keyElement);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("E")) {
                    statusElement.addAttribute(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                Element keyElement = datakeyElement.addElement("key");
                keyElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                this.setValue(tStandardApiDataName, tLocale, keyElement);
            }
            if (datakeyElement.elements().size() == 0) {
                tResponseElement.remove(datakeyElement);
            }
        }
        StringWriter tOsw = new StringWriter();
        OutputFormat tOpf = new OutputFormat("    ", true, "UTF-8");
        tOpf.setNewLineAfterDeclaration(false);
        XMLWriter writer = new XMLWriter((Writer)tOsw, tOpf);
        try {
            writer.write(tDocument.getRootElement());
            writer.close();
            String tXML = ((Object)tOsw).toString();
            while (tXML.startsWith("\n") || tXML.startsWith("\r")) {
                tXML = tXML.replaceFirst("[\n\r]", "");
            }
            return tXML;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String transTreeNodeToV1JSONString(StandardApi standardApi, MessageTextSampleTypeEnum tMessageTextSampleTypeEnum, List<StandardApiDataName> pStandardApiDataNames, String pApiName, String pHostProd, String pServiceProd, GeneratedApiMessageMockValEnum pMockValEnum, Map<String, String> pMapMockVal, String tLocale) {
        String tMessageReturned = null;
        if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
            boolean payloadExist = false;
            JsonObject tMainObject = new JsonObject();
            JsonObject tHostObject = new JsonObject();
            JsonObject tDatakeyObject = new JsonObject();
            JsonObject tPayloadObject = new JsonObject();
            JsonObject tStdDataObject = new JsonObject();
            JsonObject tParameterObject = new JsonObject();
            tHostObject.addProperty("prod", pHostProd);
            tHostObject.addProperty("ip", "10.20.88.30");
            tHostObject.addProperty("lang", "zh_TW");
            tHostObject.addProperty("timestamp", "20161018132542116");
            tHostObject.addProperty("acct", "tiptop");
            JsonObject tServiceObject = new JsonObject();
            tServiceObject.addProperty("prod", pServiceProd);
            tServiceObject.addProperty("name", pApiName);
            tServiceObject.addProperty("ip", "10.20.88.75");
            tServiceObject.addProperty("id", "topprod");
            String tSecurityKey = "28682266";
            String tSrcStr = tHostObject.toString() + tServiceObject.toString();
            String tHashCode = DigestUtil.getDigestCode((String)"MD5", (String)(tSrcStr + tSecurityKey));
            tMainObject.addProperty("key", tHashCode);
            if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
                tMainObject.addProperty("type", "sync");
            } else {
                tMainObject.addProperty("type", "fasync");
            }
            tMainObject.add("host", (JsonElement)tHostObject);
            tMainObject.add("service", (JsonElement)tServiceObject);
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                if (!tStandardApiDataName.getColumnType().equals("datakey") && !payloadExist) {
                    tPayloadObject.add("std_data", (JsonElement)tStdDataObject);
                    tStdDataObject.add("parameter", (JsonElement)tParameterObject);
                    payloadExist = true;
                }
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    JsonArray tArray = new JsonArray();
                    JsonObject tObject = new JsonObject();
                    this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDatakeyObject, pMockValEnum, pMapMockVal, tLocale);
                    tArray.add((JsonElement)tObject);
                    tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    tParameterObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    tDatakeyObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                tDatakeyObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
            }
            if (tDatakeyObject.entrySet().size() != 0) {
                tMainObject.add("datakey", (JsonElement)tDatakeyObject);
            }
            if (payloadExist) {
                tMainObject.add("payload", (JsonElement)tPayloadObject);
            }
            tMessageReturned = this.GSON.toJson((JsonElement)tMainObject);
        } else if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_FAILED.equals((Object)tMessageTextSampleTypeEnum)) {
            boolean parameterExist = false;
            boolean stdDataExist = false;
            boolean executionExist = false;
            JsonObject tMainObject = new JsonObject();
            JsonObject tStdDataObject = new JsonObject();
            JsonObject tDatakeyObject = new JsonObject();
            JsonObject tParameterObject = new JsonObject();
            JsonObject tExecutionObject = new JsonObject();
            JsonObject tPayloadObject = new JsonObject();
            if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum)) {
                tMainObject.addProperty("srvver", "1.0");
                tMainObject.addProperty("srvcode", "000");
            } else if (MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum)) {
                tMainObject.addProperty("srvver", "1.0");
                tMainObject.addProperty("srvcode", "100");
            }
            tStdDataObject.add("execution", (JsonElement)tExecutionObject);
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                if (!stdDataExist) {
                    tMainObject.add("payload", (JsonElement)tPayloadObject);
                    tPayloadObject.add("std_data", (JsonElement)tStdDataObject);
                    stdDataExist = true;
                }
                if (!tStandardApiDataName.getColumnType().equals("E") && !parameterExist) {
                    tStdDataObject.add("parameter", (JsonElement)tParameterObject);
                    parameterExist = true;
                }
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    JsonArray tArray = new JsonArray();
                    JsonObject tObject = new JsonObject();
                    this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDatakeyObject, pMockValEnum, pMapMockVal, tLocale);
                    tArray.add((JsonElement)tObject);
                    tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    tParameterObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    tDatakeyObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("E")) continue;
                tExecutionObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, tLocale));
                executionExist = true;
            }
            if (!executionExist) {
                tStdDataObject.remove("execution");
            }
            if (tDatakeyObject.entrySet().size() != 0) {
                tMainObject.add("datakey", (JsonElement)tDatakeyObject);
            }
            tMessageReturned = this.GSON.toJson((JsonElement)tMainObject);
        }
        return tMessageReturned;
    }

    public String transTreeNodeToJSONString(StandardApi standardApi, MessageTextSampleTypeEnum tMessageTextSampleTypeEnum, List<StandardApiDataName> pStandardApiDataNames, String pApiName, String pHostProd, String pServiceProd, String pDeveloperRole, boolean pIsBatch, String pCustomUUID, GeneratedApiMessageComponentEnum pComponentEnum, GeneratedApiMessageMockValEnum pMockValEnum, Map<String, String> pMapMockVal, String tLocale) {
        String tMessageReturned = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{standardApi.getApiType()}) && !"esp".equals(standardApi.getApiType())) {
            return this.transTreeNodeToJSONString4OpenAPI(standardApi, tMessageTextSampleTypeEnum, pStandardApiDataNames, pApiName, pHostProd, pServiceProd, pDeveloperRole, pIsBatch, pCustomUUID, pComponentEnum, pMockValEnum, pMapMockVal, tLocale);
        }
        if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
            StringBuilder tBuilder = new StringBuilder();
            tBuilder.append("Content-Type:application/json; charset=utf-8\r");
            tBuilder.append("digi-protocol: raw\r");
            JsonObject tHostObject = new JsonObject();
            tHostObject.addProperty("prod", pHostProd);
            tHostObject.addProperty("ip", "10.20.88.30");
            tHostObject.addProperty("lang", "zh_TW");
            tHostObject.addProperty("timestamp", "20161018132542116");
            tHostObject.addProperty("acct", "tiptop");
            JsonObject tServiceObject = new JsonObject();
            tServiceObject.addProperty("prod", pServiceProd);
            tServiceObject.addProperty("name", pApiName);
            tServiceObject.addProperty("ip", "10.20.88.75");
            tServiceObject.addProperty("id", "topprod");
            if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
                if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
                    tBuilder.append("digi-type: sync\r");
                } else {
                    tBuilder.append("digi-type: fasync\r");
                }
                String tSecurityKey = "28682266";
                String tSrcStr = tHostObject.toString() + tServiceObject.toString();
                String tHashCode = DigestUtil.getDigestCode((String)"MD5", (String)(tSrcStr + tSecurityKey));
                tBuilder.append("digi-key: ").append(tHashCode).append("\r");
            } else if (DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
                tBuilder.append("digi-reqid: ").append(pCustomUUID).append("\r");
            }
            tBuilder.append("digi-host: ").append(tHostObject.toString()).append("\r");
            tBuilder.append("digi-service: ").append(tServiceObject.toString()).append("\r");
            JsonObject tBodyObject = new JsonObject();
            JsonObject tStdDataObject = new JsonObject();
            JsonObject tParameterObject = new JsonObject();
            JsonObject tDataKeyObject = new JsonObject();
            HashMap<String, String> tNonStandardHeader = new HashMap<String, String>();
            tBodyObject.add("std_data", (JsonElement)tStdDataObject);
            tStdDataObject.add("parameter", (JsonElement)tParameterObject);
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    JsonObject tObject = new JsonObject();
                    this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        JsonArray tArray = new JsonArray();
                        tArray.add((JsonElement)tObject);
                        tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                        continue;
                    }
                    tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tObject);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    this.addJsonObjectProperty(tParameterObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("H")) {
                    String tNonStandardHeaderValue;
                    String tNonStandardHeaderName;
                    if (tStandardApiDataName.getValue() != null) {
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tStandardApiDataName.getValue();
                    } else {
                        JsonObject tObject = new JsonObject();
                        this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tObject.size() == 0 ? "" : tObject.toString();
                    }
                    tNonStandardHeader.put(tNonStandardHeaderName, tNonStandardHeaderValue);
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
            }
            if (tDataKeyObject.entrySet().size() != 0) {
                tBuilder.append("digi-datakey: ").append(tDataKeyObject.toString()).append("\r");
            }
            if (!tNonStandardHeader.isEmpty()) {
                for (String tString : tNonStandardHeader.keySet()) {
                    tBuilder.append(tString).append(": ").append((String)tNonStandardHeader.get(tString)).append("\r");
                }
            }
            if (GeneratedApiMessageComponentEnum.ALL.equals((Object)pComponentEnum)) {
                tMessageReturned = tBuilder.append(this.GSON.toJson((JsonElement)tBodyObject)).append("\r").toString();
            } else if (GeneratedApiMessageComponentEnum.BODY.equals((Object)pComponentEnum)) {
                tMessageReturned = this.GSON.toJson((JsonElement)tBodyObject);
            } else if (GeneratedApiMessageComponentEnum.DATAKEY.equals((Object)pComponentEnum)) {
                tMessageReturned = tDataKeyObject.entrySet().size() != 0 ? tDataKeyObject.toString() : "";
            }
        } else if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_FAILED.equals((Object)tMessageTextSampleTypeEnum)) {
            boolean parameterExist = false;
            boolean stdDataExist = false;
            boolean executionExist = false;
            StringBuilder tBuilder = new StringBuilder();
            tBuilder.append("Content-Type:application/json; charset=utf-8\r");
            if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole) && (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum))) {
                tBuilder.append("digi-code:  019\r");
                tBuilder.append("digi-message:  RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWQjOatpee1kOaenA==\r");
                tBuilder.append("digi-reqid:  ").append(pCustomUUID).append("\r");
            } else if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole) && (MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_FAILED.equals((Object)tMessageTextSampleTypeEnum))) {
                tBuilder.append("digi-reqid:  ").append(pCustomUUID).append("\r");
            } else if (DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole) && (MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_FAILED.equals((Object)tMessageTextSampleTypeEnum))) {
                tBuilder.append("digi-reqid:  ").append(pCustomUUID).append("\r");
            }
            tBuilder.append("digi-protocol: raw\r");
            tBuilder.append("digi-srvver:  1.0\r");
            if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum)) {
                tBuilder.append("digi-srvcode:  000\r");
            } else {
                tBuilder.append("digi-srvcode:  100\r");
            }
            JsonObject tBodyObject = new JsonObject();
            JsonObject tStdDataObject = new JsonObject();
            JsonObject tParameterObject = new JsonObject();
            JsonObject tExecutionObject = new JsonObject();
            JsonObject tDataKeyObject = new JsonObject();
            tStdDataObject.add("execution", (JsonElement)tExecutionObject);
            HashMap<String, String> tNonStandardHeader = new HashMap<String, String>();
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                if (!tStandardApiDataName.getColumnType().equals("H") && !stdDataExist) {
                    tBodyObject.add("std_data", (JsonElement)tStdDataObject);
                    stdDataExist = true;
                }
                if (!(tStandardApiDataName.getColumnType().equals("H") || tStandardApiDataName.getColumnType().equals("E") || parameterExist)) {
                    tStdDataObject.add("parameter", (JsonElement)tParameterObject);
                    parameterExist = true;
                }
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    if (pIsBatch) {
                        JsonObject tAttrObject = new JsonObject();
                        tAttrObject.addProperty("cnt", "\u7576\u524d\u56de\u50b3\u8cc7\u6599\u7b46\u6578");
                        tAttrObject.addProperty("tt_cnt", "\u61c9\u56de\u50b3\u7684\u8cc7\u6599\u7e3d\u7b46\u6578");
                        tParameterObject.add(tStandardApiDataName.getStandardDataName() + "_attr", (JsonElement)tAttrObject);
                    }
                    JsonObject tObject = new JsonObject();
                    this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        JsonArray tArray = new JsonArray();
                        tArray.add((JsonElement)tObject);
                        tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                        continue;
                    }
                    tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tObject);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    this.addJsonObjectProperty(tParameterObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("H")) {
                    String tNonStandardHeaderValue;
                    String tNonStandardHeaderName;
                    if (tStandardApiDataName.getValue() != null) {
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tStandardApiDataName.getValue();
                    } else {
                        JsonObject tObject = new JsonObject();
                        this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tObject.size() == 0 ? "" : tObject.toString();
                    }
                    tNonStandardHeader.put(tNonStandardHeaderName, tNonStandardHeaderValue);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("E")) {
                    this.addJsonObjectProperty(tExecutionObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    executionExist = true;
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
            }
            if (tDataKeyObject.entrySet().size() != 0) {
                tBuilder.append("digi-datakey: ").append(tDataKeyObject.toString()).append("\r");
            }
            if (!executionExist) {
                tStdDataObject.remove("execution");
            }
            if (!tNonStandardHeader.isEmpty()) {
                for (String tString : tNonStandardHeader.keySet()) {
                    tBuilder.append(tString).append(": ").append((String)tNonStandardHeader.get(tString)).append("\r");
                }
            }
            tMessageReturned = tBuilder.append(this.GSON.toJson((JsonElement)tBodyObject)).append("\r").toString();
        } else if (MessageTextSampleTypeEnum.FASYNC_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-code:  0E9\rdigi-srvver:  1.0\rdigi-srvcode:  000\rdigi-reqid:  " + pCustomUUID + "\r" + "digi-message" + ": " + " RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOeVsOatpeiri+axguaOpeaUtueLgOaFiw==" + "\r";
        } else if (MessageTextSampleTypeEnum.FASYNC_CALLBACK_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-srvcode:  000\r";
        } else if (MessageTextSampleTypeEnum.FASYNC_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-srvver:  1.0\rdigi-srvcode:  000\r";
        } else if (MessageTextSampleTypeEnum.FASYNC_CALLBACK_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-code:  0EG\rdigi-message:  RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOeVsOatpee1kOaenOaOpeaUtueLgOaFiw==\rdigi-srvcode:  000\r";
        }
        return tMessageReturned;
    }

    private String transTreeNodeToJSONString4OpenAPI(StandardApi standardApi, MessageTextSampleTypeEnum tMessageTextSampleTypeEnum, List<StandardApiDataName> pStandardApiDataNames, String pApiName, String pHostProd, String pServiceProd, String pDeveloperRole, boolean pIsBatch, String pCustomUUID, GeneratedApiMessageComponentEnum pComponentEnum, GeneratedApiMessageMockValEnum pMockValEnum, Map<String, String> pMapMockVal, String tLocale) {
        String tMessageReturned = null;
        if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
            StringBuilder tBuilder = new StringBuilder();
            String message = String.format("%s %S://IP:PORT%S", standardApi.getRequestMethod(), standardApi.getProtocol(), standardApi.getApiPath());
            tBuilder.append(message);
            tBuilder.append("\r");
            if (DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
                if (MessageTextSampleTypeEnum.SYNC_REQUEST.equals((Object)tMessageTextSampleTypeEnum)) {
                    tBuilder.append("digi-type: sync\r");
                } else {
                    tBuilder.append("digi-type: fasync\r");
                }
            } else if (DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
                tBuilder.append("digi-reqid: ").append(pCustomUUID).append("\r");
            }
            JsonObject tParameterObject = new JsonObject();
            JsonObject tDataKeyObject = new JsonObject();
            HashMap<String, String> tNonStandardHeader = new HashMap<String, String>();
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    JsonObject tObject = new JsonObject();
                    this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        JsonArray tArray = new JsonArray();
                        tArray.add((JsonElement)tObject);
                        tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                        continue;
                    }
                    tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tObject);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    this.addJsonObjectProperty(tParameterObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("H")) {
                    String tNonStandardHeaderValue;
                    String tNonStandardHeaderName;
                    if (tStandardApiDataName.getValue() != null) {
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tStandardApiDataName.getValue();
                    } else {
                        JsonObject tObject = new JsonObject();
                        this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tObject.size() == 0 ? "" : tObject.toString();
                    }
                    tNonStandardHeader.put(tNonStandardHeaderName, tNonStandardHeaderValue);
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
            }
            if (tDataKeyObject.entrySet().size() != 0) {
                tBuilder.append("digi-datakey: ").append(tDataKeyObject.toString()).append("\r");
            }
            if (!tNonStandardHeader.isEmpty()) {
                for (String tString : tNonStandardHeader.keySet()) {
                    tBuilder.append(tString).append(": ").append((String)tNonStandardHeader.get(tString)).append("\r");
                }
            }
            if (GeneratedApiMessageComponentEnum.ALL.equals((Object)pComponentEnum)) {
                tMessageReturned = tBuilder.append(this.GSON.toJson((JsonElement)tParameterObject)).append("\r").toString();
            } else if (GeneratedApiMessageComponentEnum.BODY.equals((Object)pComponentEnum)) {
                tMessageReturned = this.GSON.toJson((JsonElement)tParameterObject);
            } else if (GeneratedApiMessageComponentEnum.DATAKEY.equals((Object)pComponentEnum)) {
                tMessageReturned = tDataKeyObject.entrySet().size() != 0 ? tDataKeyObject.toString() : "";
            }
        } else if (MessageTextSampleTypeEnum.SYNC_RESPONSE_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.SYNC_RESPONSE_FAILED.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_SUCCESS.equals((Object)tMessageTextSampleTypeEnum) || MessageTextSampleTypeEnum.FASYNC_CALLBACK_FAILED.equals((Object)tMessageTextSampleTypeEnum)) {
            StringBuilder tBuilder = new StringBuilder();
            tBuilder.append("Content-Type:application/json; charset=utf-8\r");
            tBuilder.append("digi-protocol: raw\r");
            tBuilder.append("digi-srvver:  1.0\r");
            JsonObject tParameterObject = new JsonObject();
            JsonObject tExecutionObject = new JsonObject();
            JsonObject tDataKeyObject = new JsonObject();
            HashMap<String, String> tNonStandardHeader = new HashMap<String, String>();
            for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
                if (tStandardApiDataName.getColumnType().equals("M")) {
                    if (pIsBatch) {
                        JsonObject tAttrObject = new JsonObject();
                        tAttrObject.addProperty("cnt", "\u7576\u524d\u56de\u50b3\u8cc7\u6599\u7b46\u6578");
                        tAttrObject.addProperty("tt_cnt", "\u61c9\u56de\u50b3\u7684\u8cc7\u6599\u7e3d\u7b46\u6578");
                        tParameterObject.add(tStandardApiDataName.getStandardDataName() + "_attr", (JsonElement)tAttrObject);
                    }
                    JsonObject tObject = new JsonObject();
                    this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        JsonArray tArray = new JsonArray();
                        tArray.add((JsonElement)tObject);
                        tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                        continue;
                    }
                    tParameterObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tObject);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("P")) {
                    this.addJsonObjectProperty(tParameterObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                    this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("H")) {
                    String tNonStandardHeaderValue;
                    String tNonStandardHeaderName;
                    if (tStandardApiDataName.getValue() != null) {
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tStandardApiDataName.getValue();
                    } else {
                        JsonObject tObject = new JsonObject();
                        this.generateAllSubNodeJSONString(tStandardApiDataName, tObject, tDataKeyObject, pMockValEnum, pMapMockVal, tLocale);
                        tNonStandardHeaderName = tStandardApiDataName.getStandardDataName();
                        tNonStandardHeaderValue = tObject.size() == 0 ? "" : tObject.toString();
                    }
                    tNonStandardHeader.put(tNonStandardHeaderName, tNonStandardHeaderValue);
                    continue;
                }
                if (tStandardApiDataName.getColumnType().equals("E")) {
                    this.addJsonObjectProperty(tExecutionObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    this.addJsonObjectProperty(tParameterObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
                    continue;
                }
                if (!tStandardApiDataName.getColumnType().equals("datakey")) continue;
                this.addJsonObjectProperty(tDataKeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, tLocale);
            }
            if (tDataKeyObject.entrySet().size() != 0) {
                tBuilder.append("digi-datakey: ").append(tDataKeyObject.toString()).append("\r");
            }
            if (!tNonStandardHeader.isEmpty()) {
                for (String tString : tNonStandardHeader.keySet()) {
                    tBuilder.append(tString).append(": ").append((String)tNonStandardHeader.get(tString)).append("\r");
                }
            }
            tMessageReturned = tBuilder.append(this.GSON.toJson((JsonElement)tParameterObject)).append("\r").toString();
        } else if (MessageTextSampleTypeEnum.FASYNC_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-code:  0E9\rdigi-srvver:  1.0\rdigi-srvcode:  000\rdigi-reqid:  " + pCustomUUID + "\r" + "digi-message" + ": " + " RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOeVsOatpeiri+axguaOpeaUtueLgOaFiw==" + "\r";
        } else if (MessageTextSampleTypeEnum.FASYNC_CALLBACK_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.REQUESTER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-srvcode:  000\r";
        } else if (MessageTextSampleTypeEnum.FASYNC_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-srvver:  1.0\rdigi-srvcode:  000\r";
        } else if (MessageTextSampleTypeEnum.FASYNC_CALLBACK_RESPONSE.equals((Object)tMessageTextSampleTypeEnum) && DeveloperRoleEnum.PROVIDER.toString().equals(pDeveloperRole)) {
            tMessageReturned = "Content-Type:application/json; charset=utf-8\rdigi-code:  0EG\rdigi-message:  RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOeVsOatpee1kOaenOaOpeaUtueLgOaFiw==\rdigi-srvcode:  000\r";
        }
        return tMessageReturned;
    }

    public void generateAllSubNodeXmlString(StandardApiDataName pStandardApiDataName, Element pParentElement, Element pDatakeyElement, String tLocale) {
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataName.getChildrens()) {
            Element keyElement;
            if (tStandardApiDataName.getColumnType().equals("MF")) {
                Element MFElement = pParentElement.addElement("field");
                MFElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                MFElement.addAttribute("type", tStandardApiDataName.getDataType());
                this.setValue(tStandardApiDataName, tLocale, MFElement);
                if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                keyElement = pDatakeyElement.addElement("key");
                keyElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                this.setValue(tStandardApiDataName, tLocale, keyElement);
                continue;
            }
            if (tStandardApiDataName.getColumnType().endsWith("D")) {
                Element detailElement = pParentElement.addElement("detail");
                detailElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
                if (tStandardApiDataName.getIsArray().booleanValue()) {
                    Element rowElement = detailElement.addElement("row");
                    this.generateAllSubNodeXmlString(tStandardApiDataName, rowElement, pDatakeyElement, tLocale);
                    continue;
                }
                this.generateAllSubNodeXmlString(tStandardApiDataName, detailElement, pDatakeyElement, tLocale);
                continue;
            }
            if (!tStandardApiDataName.getColumnType().endsWith("DF")) continue;
            Element DFElement = pParentElement.addElement("field");
            DFElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
            DFElement.addAttribute("type", tStandardApiDataName.getDataType());
            this.setValue(tStandardApiDataName, tLocale, DFElement);
            if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
            keyElement = pDatakeyElement.addElement("key");
            keyElement.addAttribute("name", tStandardApiDataName.getStandardDataName());
            this.setValue(tStandardApiDataName, tLocale, keyElement);
        }
    }

    public void generateAllSubNodeJSONString(StandardApiDataName pStandardApiDataName, JsonObject pParentElement, JsonObject pDatakeyObject, GeneratedApiMessageMockValEnum pMockValEnum, Map<String, String> pMapMockVal, String pLocal) {
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataName.getChildrens()) {
            if (tStandardApiDataName.getColumnType().endsWith("D")) {
                JsonObject tDetailObject = new JsonObject();
                this.generateAllSubNodeJSONString(tStandardApiDataName, tDetailObject, pDatakeyObject, pMockValEnum, pMapMockVal, pLocal);
                if (tStandardApiDataName.getIsArray().booleanValue()) {
                    JsonArray tDetailArray = new JsonArray();
                    tDetailArray.add((JsonElement)tDetailObject);
                    pParentElement.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tDetailArray);
                    continue;
                }
                pParentElement.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tDetailObject);
                continue;
            }
            if (tStandardApiDataName.getColumnType().equals("MF") || tStandardApiDataName.getColumnType().endsWith("DF")) {
                this.addJsonObjectProperty(pParentElement, tStandardApiDataName, pMockValEnum, pMapMockVal, pLocal);
                if (!tStandardApiDataName.getIsDatakey().booleanValue()) continue;
                this.addJsonObjectProperty(pDatakeyObject, tStandardApiDataName, pMockValEnum, pMapMockVal, pLocal);
                continue;
            }
            if (!tStandardApiDataName.getColumnType().equals("HF")) continue;
            this.addJsonObjectProperty(pParentElement, tStandardApiDataName, pMockValEnum, pMapMockVal, pLocal);
        }
    }

    public void addJsonObjectProperty(JsonObject tJsonObject, StandardApiDataName tStandardApiDataName, GeneratedApiMessageMockValEnum tMockValEnum, Map<String, String> pMapMockVal, String pLocal) {
        if (GeneratedApiMessageMockValEnum.MOCK.equals((Object)tMockValEnum)) {
            String tKey = tStandardApiDataName.getId().toString();
            String tVal = pMapMockVal.get(tKey).trim();
            if (!StringUtils.isBlank((CharSequence)tVal)) {
                String tDataType = tStandardApiDataName.getDataType();
                if ("numeric".equals(tDataType)) {
                    double tDouble = Double.parseDouble(tVal);
                    if (tDouble == Math.floor(tDouble)) {
                        if (tStandardApiDataName.getIsArray().booleanValue()) {
                            JsonArray tArray = new JsonArray();
                            tArray.add((Number)Integer.parseInt(tVal));
                            tJsonObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                        } else {
                            tJsonObject.addProperty(tStandardApiDataName.getStandardDataName(), (Number)Integer.parseInt(tVal));
                        }
                    } else if (tStandardApiDataName.getIsArray().booleanValue()) {
                        JsonArray tArray = new JsonArray();
                        tArray.add((Number)Double.parseDouble(tVal));
                        tJsonObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                    } else {
                        tJsonObject.addProperty(tStandardApiDataName.getStandardDataName(), (Number)Double.parseDouble(tVal));
                    }
                } else if ("boolean".equals(tDataType)) {
                    if (tStandardApiDataName.getIsArray().booleanValue()) {
                        JsonArray tArray = new JsonArray();
                        tArray.add(Boolean.valueOf(Boolean.parseBoolean(tVal)));
                        tJsonObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                    } else {
                        tJsonObject.addProperty(tStandardApiDataName.getStandardDataName(), Boolean.valueOf(Boolean.parseBoolean(tVal)));
                    }
                } else if (tStandardApiDataName.getIsArray().booleanValue()) {
                    JsonArray tArray = new JsonArray();
                    tArray.add(this.getValue(tStandardApiDataName, pLocal));
                    tJsonObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
                } else {
                    tJsonObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, pLocal));
                }
            }
        } else if (tStandardApiDataName.getIsArray().booleanValue()) {
            JsonArray tArray = new JsonArray();
            tArray.add(this.getValue(tStandardApiDataName, pLocal));
            tJsonObject.add(tStandardApiDataName.getStandardDataName(), (JsonElement)tArray);
        } else {
            tJsonObject.addProperty(tStandardApiDataName.getStandardDataName(), this.getValue(tStandardApiDataName, pLocal));
        }
    }

    private void setValue(StandardApiDataName tStandardApiDataName, String tLocale, Element element) {
        if (tStandardApiDataName.getValue() != null) {
            element.addText(tStandardApiDataName.getValue());
        } else if ("zh_TW".equals(tLocale) && tStandardApiDataName.getDescriptionZhTw() != null) {
            element.addText(tStandardApiDataName.getDescriptionZhTw());
        } else if ("zh_CN".equals(tLocale) && tStandardApiDataName.getDescriptionZhCn() != null) {
            element.addText(tStandardApiDataName.getDescriptionZhCn());
        } else if ("en_US".equals(tLocale) && tStandardApiDataName.getDescriptionEnUs() != null) {
            element.addText(tStandardApiDataName.getDescriptionEnUs());
        }
    }

    private String getValue(StandardApiDataName tStandardApiDataName, String tLocale) {
        String value = "";
        if ("zh_TW".equals(tLocale) && tStandardApiDataName.getDescriptionZhTw() != null) {
            value = tStandardApiDataName.getDescriptionZhTw();
        } else if ("zh_CN".equals(tLocale) && tStandardApiDataName.getDescriptionZhCn() != null) {
            value = tStandardApiDataName.getDescriptionZhCn();
        } else if ("en_US".equals(tLocale) && tStandardApiDataName.getDescriptionEnUs() != null) {
            value = tStandardApiDataName.getDescriptionEnUs();
        } else if (tStandardApiDataName.getValue() != null) {
            value = tStandardApiDataName.getValue();
        }
        return value;
    }
}

