package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProjectMapper;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.model.Project;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;

@Primary
@Repository
@Transactional
public class ApiMgmtProjectDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtProjectMapper, Project, Long>
        implements ApiMgmtProjectDao {

    public ApiMgmtProjectDaoMybatisImpl() {
        super();
    }

    @Override
    public List<Project> getByName(String pName) {
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Project::getProjectName, pName);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<Project> queryByIdList(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }

        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(Project::getProjectId, idList);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<Project> selectPageable(PageReqCondition<String> pageReqCondition) {
        MpPage<Project> page = MpPage.from(pageReqCondition);
        return baseMapper.selectPageable(pageReqCondition, page);
    }

    @Override
    public Long pageCount(PageReqCondition<String> pageReqCondition) {
        return baseMapper.pageCount(pageReqCondition);
    }

    @Override
    public Project selectById(Long projectId) {
        return baseMapper.selectById(projectId);
    }

    @Override
    public List<Project> selectAll() {
        return baseMapper.selectList(
                Wrappers.lambdaQuery(Project.class)
                        .orderByAsc(Project::getCreateTime)
        );
    }

    @Override
    public Long countByName(String projectName) {
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Project::getProjectName, projectName);
        return baseMapper.selectCount(wrapper);
    }

    @Override
    public void deleteById(Long projectId) {
        baseMapper.deleteById(projectId);
    }

}
