package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiDataNameMapper;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Primary
@Repository
public class ApiMgmtStandardApiDataNameDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtStandardApiDataNameMapper, StandardApiDataName, Integer>
        implements ApiMgmtStandardApiDataNameDao {

    protected ApiMgmtProductApiDataNameDaoMybatisImpl productApiDataNameDao;

    public ApiMgmtStandardApiDataNameDaoMybatisImpl() {
        super();
    }

    @Override
    public List<StandardApiDataName> getByApiVerId(Long pApiId, Boolean pShowField) {
        return baseMapper.getByApiVerId(pApiId, pShowField);
    }

    @Override
    public List<StandardApiDataName> getByApiVerIdAndMsgType(Long pApiId, Integer pMsgType, Boolean pShowField) {
        return baseMapper.getByApiVerIdAndMsgType(pApiId, pMsgType, pShowField);
    }

    @Override
    public List<StandardApiDataName> selectByVersionIds(List<Long> subIdList) {
        return baseMapper.selectByVersionIds(subIdList);
    }

    @Override
    public void batchSave(List<StandardApiDataName> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }

        List<StandardApiDataName> allList = list.stream()
                .flatMap(StandardApiDataName::flatten).collect(Collectors.toList());

        List<ProductApiDataName> productApiDataNameList = allList.stream()
                .flatMap(v -> v.getProductApiDataNames().stream())
                .collect(Collectors.toList());

        batchService.saveBatch(allList, 200);
        productApiDataNameDao.batchSave(productApiDataNameList);
    }

    @Override
    public int deleteByApiVerId(Long apiVerId) {
        return baseMapper.deleteByApiVerId(apiVerId);
    }

    @Autowired
    public void setProductApiDataNameMapper(ApiMgmtProductApiDataNameDaoMybatisImpl productApiDataNameDao) {
        this.productApiDataNameDao = productApiDataNameDao;
    }
}
