package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProductMapper;
import com.digiwin.athena.apimgmt.model.Product;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;

@Primary
@Repository
public class ApimgmtProductDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtProductMapper, Product, String>
    implements ApimgmtProductDao {

    public ApimgmtProductDaoMybatisImpl() {
        super();
    }

    @Override
    public List<Product> getByName(String pName) {
        LambdaQueryWrapper<Product> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Product::getName, pName);
        return baseMapper.selectList(wrapper);
    }
}
