package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Data
@ToString(exclude = "standardApi")
@TableName(value = "project_version_relation", resultMap = "BaseResultMap")
public class ProjectVersionRelation implements Serializable{
    /** 主键 */
    @TableId(type = IdType.AUTO)
    private Long relationId ;

    @Getter
    @Setter
    @TableField(value = "api_id")
    private Long apiId;

    /** API的ID */
    @TableField(exist = false)
    private StandardApi standardApi;

    @TableField("project_id")
    private Long projectId;

    @TableField("project_version_id")
    private Long projectVersionId;
    @TableField("CREATED_BY")
    private String createdBy;

    @TableField("CREATED_TIME")
    private Date createdTime;

    public void setStandardApi(StandardApi standardApi) {
        this.standardApi = standardApi;
        if (standardApi != null) {
            this.apiId = standardApi.getId();
        }
    }

}