/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.facade;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.facade.IApiInfoFacadeService;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiInfoFacadeService
implements IApiInfoFacadeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiInfoFacadeService.class);
    private final ObjectMapper mapper;
    private final AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;

    @Override
    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) {
        return CollUtil.split(apiKeys, (int)50).stream().flatMap(subKeys -> {
            Map<String, Object> resultMap;
            if (CollUtil.isEmpty((Collection)subKeys)) {
                return Stream.empty();
            }
            String queryJson = this.buildQueryJson((List<ApiMgmtApiKeyDTO>)subKeys);
            log.info("Query API by keys, json: {}", (Object)queryJson);
            try {
                resultMap = this.advanceSearchApiListGetOtherService.execute(queryJson);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            return this.convertToApiInfoDTOList(resultMap).stream();
        }).collect(Collectors.toList());
    }

    protected String buildQueryJson(List<ApiMgmtApiKeyDTO> apiKeys) {
        ObjectNode rootNode = this.mapper.createObjectNode();
        ArrayNode conditionList = this.mapper.createArrayNode();
        int order = 0;
        for (int i = 0; i < apiKeys.size(); ++i) {
            ApiMgmtApiKeyDTO key = apiKeys.get(i);
            String mark = i == 0 ? "and" : "or";
            String openBracket = "(";
            String closeBracket = ")";
            ObjectNode apiNameNode = this.mapper.createObjectNode();
            apiNameNode.put("condition", "apiName");
            apiNameNode.put("equation", "=");
            apiNameNode.put("content", key.getApiName());
            apiNameNode.put("mark", mark);
            apiNameNode.put("order", order++);
            apiNameNode.put("bracket", openBracket);
            conditionList.add((JsonNode)apiNameNode);
            if (key.getBranch() != null) {
                ObjectNode apiVersionNode = this.mapper.createObjectNode();
                apiVersionNode.put("condition", "apiBranch");
                apiVersionNode.put("equation", "=");
                apiVersionNode.put("content", key.getBranch());
                apiVersionNode.put("mark", "and");
                apiVersionNode.put("order", order++);
                apiVersionNode.put("bracket", "");
                conditionList.add((JsonNode)apiVersionNode);
            }
            if (key.getTenantId() != null) {
                ObjectNode tenantIdNode = this.mapper.createObjectNode();
                tenantIdNode.put("condition", "tenantId");
                tenantIdNode.put("equation", "=");
                tenantIdNode.put("content", key.getTenantId());
                tenantIdNode.put("mark", "and");
                tenantIdNode.put("order", order++);
                tenantIdNode.put("bracket", closeBracket);
                conditionList.add((JsonNode)tenantIdNode);
                continue;
            }
            if (key.getBranch() != null) {
                ObjectNode lastNode = (ObjectNode)conditionList.get(conditionList.size() - 1);
                lastNode.put("bracket", closeBracket);
                continue;
            }
            apiNameNode.put("bracket", "");
        }
        rootNode.set("conditionList", (JsonNode)conditionList);
        rootNode.put("type", false);
        rootNode.put("statusId", "");
        rootNode.put("pageSize", apiKeys.size());
        rootNode.put("pageNum", 1);
        return rootNode.toString();
    }

    protected List<ApiMgmtApiInfoDTO> convertToApiInfoDTOList(Map<String, Object> resultMap) {
        ArrayList<ApiMgmtApiInfoDTO> result = new ArrayList<ApiMgmtApiInfoDTO>();
        if (resultMap == null || !resultMap.containsKey("value")) {
            return result;
        }
        List valueList = (List)resultMap.get("value");
        if (CollUtil.isEmpty((Collection)valueList)) {
            return result;
        }
        return valueList.stream().map(ApiMgmtApiInfoDTO::fromMap).collect(Collectors.toList());
    }

    @Generated
    public ApiInfoFacadeService(ObjectMapper mapper, AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService) {
        this.mapper = mapper;
        this.advanceSearchApiListGetOtherService = advanceSearchApiListGetOtherService;
    }
}

