package com.digiwin.athena.apimgmt.facade.dto;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiMgmtApiInfoDTO {

    private Long apiId;

    private String name;

    private String version;

    private String approvedStatus;

    private String approvedTime;

    private Long approvedStatusCode;

    private String description;

    private String remark;

    private String syncType;

    private Long categoryId;

    private String categoryName;

    private String msgFormat;

    private String requester;

    private String provider;

    private String tenantId;

    private String apiBuildAcct;

    private String apiBuildTime;

    private String designTenantId;

    private String teamId;

    private Long statusId;

    private String apiType;

    /**
     * 关联产品（英文，standardApi.project_name）
     */
    private String projectCode;

    /**
     * 关联产品版本
     */
    private Boolean projectHasVersions;

    /**
     * 关联产品版本名称
     */
    private List<String> projectVersionNameList;

    private String projectVersionNameListStr;

    private String firstApplicant;

    private String lastApplicant;

    public static ApiMgmtApiInfoDTO fromMap(Map<String, Object> map) {
        return ApiMgmtApiInfoDTO.builder()
                .apiId(MapUtil.getLong(map, ApimgmtConstant.API_ID))
                .name(MapUtil.getStr(map, ApimgmtConstant.NAME))
                .version(MapUtil.getStr(map, ApimgmtConstant.VERSION))
                .approvedStatus(MapUtil.getStr(map, ApimgmtConstant.APPROVED_STATUS))
                .approvedTime(MapUtil.getStr(map, ApiAttributeEnum.approvedTime.toString()))
                .approvedStatusCode(MapUtil.getLong(map, ApimgmtConstant.APPROVED_STATUS_CODE))
                .description(MapUtil.getStr(map, ApimgmtConstant.DESCRIPTION))
                .remark(MapUtil.getStr(map, ApimgmtConstant.REMARK))
                .syncType(MapUtil.getStr(map, ApimgmtConstant.SYNC_TYPE))
                .categoryId(MapUtil.getLong(map, ApimgmtConstant.CATEGORY_ID))
                .categoryName(MapUtil.getStr(map, ApimgmtConstant.CATEGORY_NAME))
                .msgFormat(MapUtil.getStr(map, ApimgmtConstant.MSG_FORMAT))
                .requester(MapUtil.getStr(map, ApimgmtConstant.REQUESTER))
                .provider(MapUtil.getStr(map, ApimgmtConstant.PROVIDER))
                .tenantId(MapUtil.getStr(map, ApimgmtConstant.TENANT_ID))
                .apiBuildAcct(MapUtil.getStr(map, ApimgmtConstant.API_BUILD_ACCT))
                .apiBuildTime(MapUtil.getStr(map, ApimgmtConstant.API_BUILD_TIME))
                .designTenantId(MapUtil.getStr(map, ApimgmtConstant.DESIGN_TENANT_ID))
                .teamId(MapUtil.getStr(map, ApimgmtConstant.TEAM_ID))
                .statusId(MapUtil.getLong(map, ApimgmtConstant.STATUS_ID))
                .apiType(MapUtil.getStr(map, ApimgmtConstant.API_TYPE))
                .projectCode(MapUtil.getStr(map, ApimgmtConstant.PROJECT_NAME))
                .projectHasVersions(MapUtil.getBool(map, ApimgmtConstant.PROJECT_HAS_VERSIONS))
                .projectVersionNameList(getList(map, ApimgmtConstant.PROJECT_VERSION_NAME_LIST))
                .projectVersionNameListStr(MapUtil.getStr(map, ApimgmtConstant.PROJECT_VERSION_NAME_LIST_STR))
                .firstApplicant(MapUtil.getStr(map, ApimgmtConstant.FIRST_APPLICANT))
                .lastApplicant(MapUtil.getStr(map, ApimgmtConstant.LAST_APPLICANT))
                .build();
    }

    @SuppressWarnings("unchecked")
    protected static List<String> getList(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof List) {
            return (List<String>) value;
        }
        return null;
    }

    @SuppressWarnings("unused")
    public ApiMgmtApiKeyDTO toKey() {
        return ApiMgmtApiKeyDTO.of(name, tenantId, version);
    }
}
