package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ApiMgmtSyncMdcServiceProcessor {


    @Autowired
    private ApiMgmtSyncMdcAddService syncMdcAddService;

    @Autowired
    private ApiMgmtSyncMdcDeleteService syncMdcDeleteService;

    @Async
    public void runSyncMdcMetadata(List<Long> metadataList, String pSyncUrl, String tUserId, String tToken, String routerKey) {
        // 同步新增MDC元数据
        Map<String, String> result = syncMdcAddService.runSyncMdcMetadataAdd(metadataList, pSyncUrl, tUserId, tToken, routerKey);
        log.info("mdc同步結果：{}",result);
    }

    @Async
    public void runSyncMdcMetadataDel(List<Long> metadataList, String pSyncUrl, boolean sendMqJudge, String tUserId, String tToken, String routerKey) {
        // 同步删除MDC元数据
        syncMdcDeleteService.runSyncMdcMetadataDel(metadataList, pSyncUrl, sendMqJudge, tUserId, tToken, routerKey);
    }

    @Async
    public void reqSyncMdcMetadataAddCompensate(List<SyncMdcFailData> metadataList, String pSyncUrl) {
        syncMdcAddService.reqSyncMdcMetadataAddCompensate(metadataList, pSyncUrl);
    }

}
