package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 取得API規格檔或範例模板
 * /restful/standard/apimgmt/ApiSpecFile/Get
 */
@Slf4j
@Service
public class ApiSpecFileGetService extends AbstractApiService {

	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

	public ApiSpecFileGetService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_SPEC_FILE_GET_SCHEMA;
	}

	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
		// 取得request node
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		// 建立response node
		ObjectNode tResponseNode = mapper.createObjectNode();
		// 取得入參api名稱
		String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
		String tVersion = null;
		String tTenant = "";
		// 取得入參api版號
		if (tRequestJsonNode.get(ApiAttributeEnum.apiVersion.toString()) != null) {
			tVersion = tRequestJsonNode.get(ApiAttributeEnum.apiVersion.toString()).asText();
		}
		// 取得入參租戶id
		if (tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
			tTenant = tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
		}
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = tStateCode.getDescription();
		// 下載範例規格檔
		if (tApiName.equals(ApiAttributeEnum.template.toString())) {
			String tNewFilePath = StandardApiExportServiceUtil.getTemplate();
			DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tNewFilePath, ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME, false, 0);
		} else {
			// 下載API規格檔
			Map<String, String> tConditions = new HashMap<>();
			tConditions.put(ApiAttributeEnum.apiName.toString(), tApiName);
			tConditions.put(ApiAttributeEnum.version.toString(), tVersion);
			tConditions.put(ApiAttributeEnum.tenantId.toString(), tTenant);
			StandardApiVersion tStandardApiVersion = standardApiVersionDao.fetchApiVersion(tConditions);
			//查询Relation信息
			List<ProjectVersionRelation> projectVersionRelationList = projectVersionRelationDao.getByApiId(tStandardApiVersion.getStandardApi().getId());
			tStandardApiVersion.getStandardApi().setProjectVersionRelations(projectVersionRelationList);

			// 有查到對應版本的API資料
			if (tStandardApiVersion != null) {
				String tNewFilePath = null;
				try {
					tNewFilePath = StandardApiExportServiceUtil.exportStandardApi(tStandardApiVersion);
					String tNewFileName = StandardApiExportServiceUtil.getFileName(tNewFilePath);
					DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tNewFilePath, tNewFileName, false, 0);
				} catch (Exception e) {
					log.error(e.getMessage(), e);
				}finally {
					boolean b = StandardApiExportServiceUtil.removeFile(tNewFilePath);
					log.info("导出文件删除:{}" + b);
				}
			} else {
				// 沒有查到對應版本的API資料
				tStateCode = getStateCode(ValidateStateEnum.API_NAME_VER_NOTFOUND.getCode());
				tDescription = tStateCode.getDescription();
			}
		}
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}

}
