package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

/**
 * The persistent class for the standard_api_data_name database table.
 *
 */
@Data
@ToString(onlyExplicitlyIncluded = true)
@TableName(value = "standard_api_data_name", resultMap = "BaseResultMap")
@EqualsAndHashCode(exclude = {"standardApiVersion", "parent", "childrens", "productApiDataNames"})
public class StandardApiDataName implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Long id;

    @TableField("api_ver_id")
    private Long apiVerId;

    @TableField("api_ver")
    private String apiVer;

    @TableField("column_type")
    @Expose()
    private String columnType;

    @TableField("data_type")
    private String dataType;

    @TableField("msg_type")
    @Expose()
    private Integer msgType;

    @Deprecated
    @Expose()
    private Boolean nullable;

    @TableField("is_required")
    @Expose()
    private Boolean isRequired;

    @TableField("remark_en_us")
    @Expose()
    private String remarkEnUs;

    @TableField("remark_zh_cn")
    @Expose()
    private String remarkZhCn;

    @TableField("remark_zh_tw")
    @Expose()
    private String remarkZhTw;

    @TableField("description_en_us")
    @Expose()
    private String descriptionEnUs;

    @TableField("description_zh_cn")
    @Expose()
    private String descriptionZhCn;

    @TableField("description_zh_tw")
    @Expose()
    private String descriptionZhTw;

    @TableField("list_enum_zh_tw")
    @Expose()
    private String listEnumZhTw;

    @TableField("list_enum_zh_cn")
    @Expose()
    private String listEnumZhCn;

    @TableField("list_enum_en")
    @Expose()
    private String listEnumEn;

    @TableField("update_history")
    private String updateHistory;

    private String value;

    @TableField("is_datakey")
    @Expose()
    private Boolean isDatakey;

    @TableField("is_array")
    @Expose()
    private Boolean isArray;

    @TableField("can_sort")
    @Expose()
    private Boolean canSort;

    // by songwq 新增过滤字段
    @TableField("can_filter")
    @Expose()
    private Boolean canFilter;

    @TableField("is_businesskey")
    @Expose()
    private Boolean isBusinesskey;

    @TableField(exist = false)
    private StandardApiVersion standardApiVersion;

    @TableField("parent")
    private Long parentId;

    @TableField(exist = false)
    // bi-directional many-to-one association to StandardApiDataName
    private StandardApiDataName parent;

    // bi-directional many-to-one association to StandardApiDataName
    @Expose()
    @TableField(exist = false)
    private List<StandardApiDataName> childrens = new ArrayList<>();

    //bi-directional many-to-one association to StandardApiDataName
    @TableField(exist = false)
    private List<ProductApiDataName> productApiDataNames = new ArrayList<>();

    @TableField("data_name")
    @Expose()
    @SerializedName("dataName")
    private String standardDataName;

    public StandardApiDataName() {
    }

    public void setIsRequired(Boolean isRequired) {
        this.nullable = !isRequired;
        this.isRequired = isRequired;
    }

    public static boolean validateName(String apiType, String dataName) {
        if (ApiTypeConstants.OPENAPI_CODE.equals(apiType)) {
            return dataName.matches(ApimgmtConstant.REGEX_OPEN_API_DATA_NAME);
        } else {
            return dataName.matches(ApimgmtConstant.REGEX_API_DATA_NAME)
                    || Arrays.asList(ApimgmtConstant.ALLOW_API_DATA_NAME).contains(dataName);
        }
    }

    public void setId(Long id) {
        this.id = id;
        if (this.productApiDataNames != null) {
            productApiDataNames.forEach(v -> v.setApiDataName(this));
        }
    }

    public void setParent(StandardApiDataName parent) {
        this.parent = parent;
        if (parent != null) {
            this.parentId = parent.getId();
        }
    }

    public StandardApiDataName addChildren(StandardApiDataName standardApiDataName) {
        getChildrens().add(standardApiDataName);
        standardApiDataName.setParent(this);
        standardApiDataName.setStandardApiVersion(this.standardApiVersion);

        return standardApiDataName;
    }

    public ProductApiDataName addProductApiDataName(ProductApiDataName productApiDataName) {
        getProductApiDataNames().add(productApiDataName);
        productApiDataName.setApiDataName(this);

        return productApiDataName;
    }

    public void setStandardApiVersion(StandardApiVersion standardApiVersion) {
        this.standardApiVersion = standardApiVersion;
        if (standardApiVersion != null) {
            this.apiVerId = standardApiVersion.getId();
            CollUtil.emptyIfNull(childrens).forEach(v -> v.setStandardApiVersion(standardApiVersion));
        }
    }

    public Stream<StandardApiDataName> flatten() {
        return Stream.concat(
                Stream.of(this),
                CollUtil.emptyIfNull(getChildrens()).stream()
                        .flatMap(StandardApiDataName::flatten)
        );
    }
}