/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ApiDataNameService {
    public static List<String> dataNameList = new ArrayList<String>();
    ObjectMapper mapper = new ObjectMapper();

    public void setReaponseMessageSpec(ObjectNode pResponseNode, List<StandardApiDataName> pStandardApiDataNameList, String pMessageSpec, int pMsgType, String pLocale) {
        ArrayNode tSpecAryNode = this.mapper.createArrayNode();
        pResponseNode.set(pMessageSpec, (JsonNode)tSpecAryNode);
        for (StandardApiDataName standardApiDataName : pStandardApiDataNameList) {
            String tListEnum;
            String tDataRemark;
            String tDataDescription;
            if (standardApiDataName.getMsgType() != pMsgType) continue;
            ObjectNode tMessageSpecNode = this.mapper.createObjectNode();
            String tColumnType = standardApiDataName.getColumnType();
            long tId = standardApiDataName.getId();
            String tIsDataKey = standardApiDataName.getIsDatakey() != false ? "Y" : "N";
            String tIsRequired = standardApiDataName.getIsRequired() != false ? "Y" : "N";
            String tIsArray = standardApiDataName.getIsArray() != false ? "Y" : "N";
            String tCanSort = standardApiDataName.getCanSort() != false ? "Y" : "N";
            String tCanFilter = standardApiDataName.getCanFilter() != false ? "Y" : "N";
            String tIsBusinessKey = standardApiDataName.getIsBusinesskey() != false ? "Y" : "N";
            List<ProductApiDataName> productApiDataNames = standardApiDataName.getProductApiDataNames();
            ObjectNode productPrecision = this.mapper.createObjectNode();
            if (CollUtil.isNotEmpty(productApiDataNames)) {
                productApiDataNames.forEach(x -> {
                    String precision = null;
                    if (null != x.getLength()) {
                        precision = String.valueOf(x.getLength());
                    }
                    if (null != x.getPrecision()) {
                        precision = precision + "," + x.getPrecision();
                    }
                    productPrecision.put(x.getProduct().getName(), precision);
                });
            }
            String tDataType = standardApiDataName.getDataType() == null ? "" : standardApiDataName.getDataType();
            String tValue = standardApiDataName.getValue() == null ? "" : standardApiDataName.getValue();
            String tHistory = standardApiDataName.getUpdateHistory() == null ? "" : standardApiDataName.getUpdateHistory();
            switch (pLocale) {
                case "zh_CN": {
                    tDataDescription = standardApiDataName.getDescriptionZhCn();
                    tDataRemark = standardApiDataName.getRemarkZhCn() == null ? "" : standardApiDataName.getRemarkZhCn();
                    tListEnum = standardApiDataName.getListEnumZhCn() == null ? "" : standardApiDataName.getListEnumZhCn();
                    break;
                }
                case "zh_TW": {
                    tDataDescription = standardApiDataName.getDescriptionZhTw();
                    tDataRemark = standardApiDataName.getRemarkZhTw() == null ? "" : standardApiDataName.getRemarkZhTw();
                    tListEnum = standardApiDataName.getListEnumZhTw() == null ? "" : standardApiDataName.getListEnumZhTw();
                    break;
                }
                default: {
                    tDataDescription = standardApiDataName.getDescriptionEnUs();
                    tDataRemark = standardApiDataName.getRemarkEnUs() == null ? "" : standardApiDataName.getRemarkEnUs();
                    tListEnum = standardApiDataName.getListEnumEn() == null ? "" : standardApiDataName.getListEnumEn();
                }
            }
            ObjectNode tDataNameDescriptionMultilingualNode = this.mapper.createObjectNode();
            tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
            tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
            tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
            ObjectNode tDataRemarkMultilingualNode = this.mapper.createObjectNode();
            tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw() == null ? "" : standardApiDataName.getRemarkZhTw());
            tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn() == null ? "" : standardApiDataName.getRemarkZhCn());
            tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs() == null ? "" : standardApiDataName.getRemarkEnUs());
            ObjectNode tListEnumMultilingualNode = this.mapper.createObjectNode();
            tListEnumMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getListEnumZhTw() == null ? "" : standardApiDataName.getListEnumZhTw());
            tListEnumMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getListEnumZhCn() == null ? "" : standardApiDataName.getListEnumZhCn());
            tListEnumMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getListEnumEn() == null ? "" : standardApiDataName.getListEnumEn());
            String tDataName = standardApiDataName.getStandardDataName();
            if (standardApiDataName.getParentId() != null) {
                long tParentId = standardApiDataName.getParentId();
                tMessageSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
            }
            tMessageSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
            tMessageSpecNode.put(ApiAttributeEnum.id.toString(), tId);
            tMessageSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
            tMessageSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), (JsonNode)tDataNameDescriptionMultilingualNode);
            tMessageSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), (JsonNode)tDataRemarkMultilingualNode);
            tMessageSpecNode.set(ApiAttributeEnum.listEnumMultilingual.toString(), (JsonNode)tListEnumMultilingualNode);
            tMessageSpecNode.put(ApiAttributeEnum.dataDescription.toString(), tDataDescription);
            tMessageSpecNode.put(ApiAttributeEnum.dataNameRemark.toString(), tDataRemark);
            tMessageSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
            tMessageSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
            tMessageSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
            tMessageSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
            tMessageSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
            tMessageSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
            tMessageSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
            tMessageSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
            tMessageSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
            tMessageSpecNode.put(ApiAttributeEnum.editHistory.toString(), tHistory);
            tMessageSpecNode.set(ApiAttributeEnum.productPrecision.toString(), (JsonNode)productPrecision);
            tSpecAryNode.add((JsonNode)tMessageSpecNode);
        }
    }
}

