/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiBuilderUpdateService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiBuilderUpdateService.class);
    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public ApiBuilderUpdateService() {
        this.jsonSchemaFileName = "api_builder_update_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tenantId = "";
        String apiBuildAcct = tRequestJsonNode.get("apiBuildAcct").asText();
        String apiBuildName = tRequestJsonNode.get("apiBuildName").asText();
        HashMap<String, String> tConditionMap = new HashMap<String, String>();
        tConditionMap.put("apiName", tRequestJsonNode.get("apiName").asText());
        tConditionMap.put("version", tRequestJsonNode.get("apiVersion").asText());
        if (tRequestJsonNode.get("tenantId") != null) {
            tenantId = tRequestJsonNode.get("tenantId").asText();
        }
        tConditionMap.put("tenantId", tenantId);
        StandardApiVersion tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap);
        if (null != tStandardApiVersion) {
            tStandardApiVersion.setApprovedAcct(apiBuildAcct);
            tStandardApiVersion.setApplicant(apiBuildName);
            tStandardApiVersion.setUserId(apiBuildAcct);
            this.standardApiVersionDao.saveOrupdate(tStandardApiVersion);
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        tResponse.put("code", tStateCode.getCode());
        tResponse.put("description", tStateCode.getDescription());
        return tResponse;
    }
}

