/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.DeveloperRoleEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.MessageSampleArchiveTypeEnum;
import com.digiwin.athena.apimgmt.enums.MessageTextSampleTypeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.MessageSampleServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMessageExampleFileGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMessageExampleFileGetService.class);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;

    public ApiMessageExampleFileGetService() {
        this.jsonSchemaFileName = "api_message_example_file_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
        JsonNode tRequestNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tApiName = tRequestNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String branch = "1.0";
        String tServiceProduct = tRequestNode.get(ApiAttributeEnum.serviceProduct.toString()).asText();
        String tHostProduct = tRequestNode.get(ApiAttributeEnum.hostProduct.toString()).asText();
        String tMsgFormat = tRequestNode.get(ApiAttributeEnum.msgFormat.toString()).asText();
        String tDevelopRole = tRequestNode.get(ApiAttributeEnum.developRole.toString()).asText();
        String tMessageType = tRequestNode.get(ApiAttributeEnum.messageType.toString()).asText();
        String tTenant = "";
        if (tRequestNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        String tVersion = null;
        if (tRequestNode.get(ApiAttributeEnum.apiVersion.toString()) != null) {
            tVersion = tRequestNode.get(ApiAttributeEnum.apiVersion.toString()).asText();
            branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        }
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
        StandardApiVersion tTargetApiVersion = null;
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
            if (!tStandardApiVersion.getVersion().equals(tVersion)) continue;
            tTargetApiVersion = tStandardApiVersion;
        }
        if (tTargetApiVersion != null) {
            String tCustomUUID = UUID.randomUUID().toString();
            try {
                String tGenerateFileName = tMessageType.equals("all") ? MessageSampleServiceUtil.zipItAndGetZipFileName(tTargetApiVersion.getId(), tTargetApiVersion.getStandardApi(), tMsgFormat, tHostProduct, tServiceProduct, MessageSampleArchiveTypeEnum.ZIP.toString(), tTargetApiVersion.getStandardApi().getStandardApiSyncType().getNameEnUs(), tDevelopRole, tCustomUUID, tLocale) : MessageSampleServiceUtil.writeToFile(ApiMgmtApplicationParameter._FILE_EXPORT_PATH, tTargetApiVersion.getId(), tTargetApiVersion.getStandardApi(), MessageFormatEnum.valueOf((String)tMsgFormat), tHostProduct, tServiceProduct, MessageTextSampleTypeEnum.valueOf((String)tMessageType), DeveloperRoleEnum.valueOf((String)tDevelopRole), tCustomUUID, tLocale);
                String tFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tGenerateFileName;
                DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFilePath, tGenerateFileName, false, 0);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = tStateCode.getDescription();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

