/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.file.ApiMgmtFileService;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.MultipartFile;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtDmcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.util.DateUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMgmtFileDmcService
implements ApiMgmtFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtFileDmcService.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ApiMgmtDmcProp apiMgmtDmcProp;
    private final ApiMgmtProp prop;

    public String uploadFile(File file, String fileName) throws Exception {
        String tUserToken = this.login();
        String tFileId = "";
        if (!StringUtil.isEmptyOrSpace((Object)tUserToken)) {
            JsonNode tDataNode;
            String tDmcHost = this.apiMgmtDmcProp.getUrl();
            String tBucket = this.apiMgmtDmcProp.getBucket();
            String tDmcDirectoryId = this.apiMgmtDmcProp.getDirectoryId();
            String tUriStr = URLUtil.completeUrl((String)tDmcHost, (String)(String.format("/api/dmc/v2/file/%s/upload", tBucket) + "?bucket=" + tBucket));
            HttpRequest tPost = HttpRequest.ofPost((String)tUriStr);
            tPost.setHeader("digi-middleware-auth-user", (Object)tUserToken);
            tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tPost.setHeader("token", (Object)tUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            MultipartFile multipartFile = new MultipartFile("file", file);
            JsonObject tFileInfo = new JsonObject();
            tFileInfo.addProperty("directoryId", tDmcDirectoryId);
            tFileInfo.addProperty("displayName", fileName);
            tFileInfo.addProperty("fileName", fileName);
            tFileInfo.addProperty("expireDate", DateUtil.formatToSecond((Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L))));
            tPost.setEntity((Object)MapUtil.of((Object)"fileInfo", (Object)tFileInfo));
            String tResponse = (String)HttpUtil.uploadFile((HttpRequest)tPost, (MultipartFile)multipartFile, String.class);
            JsonNode tResponseNode = this.mapper.readTree(tResponse);
            if (tResponseNode.get("data") != null && (tDataNode = tResponseNode.get("data")).get("id") != null) {
                tFileId = tDataNode.get("id").asText();
            }
        }
        return tFileId;
    }

    public String generateDownloadLink(String fileId) throws Exception {
        String tUserToken = this.login();
        String tDownloadUrl = "";
        if (!StringUtil.isEmptyOrSpace((Object)tUserToken)) {
            JsonNode tDataNode;
            String tDmcHost = this.apiMgmtDmcProp.getUrl();
            String tBucket = this.apiMgmtDmcProp.getBucket();
            String tUriStr = URLUtil.completeUrl((String)tDmcHost, (String)(String.format("/api/dmc/v2/file/%s/share", tBucket) + "?bucket=" + tBucket));
            HttpRequest tPost = HttpRequest.ofPost((String)tUriStr);
            tPost.setHeader("digi-middleware-auth-user", (Object)tUserToken);
            tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tPost.setHeader("Content-Type", (Object)"application/json");
            tPost.setHeader("token", (Object)tUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            HashMap<String, String> tRequestBody = new HashMap<String, String>();
            tRequestBody.put("fileId", fileId);
            tRequestBody.put("expireDate", DateUtil.formatToSecond((Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L))));
            tPost.setEntity(tRequestBody);
            String tResponse = (String)HttpUtil.execute((HttpRequest)tPost, String.class);
            JsonNode tResponseNode = this.mapper.readTree(tResponse);
            if (tResponseNode.get("data") != null && (tDataNode = tResponseNode.get("data")).get("url") != null) {
                tDownloadUrl = tDataNode.get("url").asText();
            }
        }
        return tDownloadUrl;
    }

    public String uploadFileAndGenerateDownloadLink(File file, String fileName) throws Exception {
        String tFileId = this.uploadFile(file, fileName);
        String tDownloadLink = null;
        if (!StringUtil.isEmptyOrSpace((Object)tFileId)) {
            log.info("\u4e0a\u50b3API\u898f\u683c\u6a94\u81f3dmc\u6210\u529f\uff0c\u6a94\u6848\u540d\u7a31:" + fileName + " \u6a94\u6848ID:" + tFileId);
            tDownloadLink = this.generateDownloadLink(tFileId);
            if (!StringUtil.isEmptyOrSpace((Object)tDownloadLink)) {
                log.info("\u5206\u4eabAPI\u898f\u683c\u6a94\u81f3dmc\u6210\u529f\uff0c\u6a94\u6848\u540d\u7a31:" + fileName + " \u6a94\u6848ID:" + tFileId + " \u4e0b\u8f09\u9023\u7d50:" + tDownloadLink);
            }
        }
        return tDownloadLink;
    }

    String login() {
        String tToken = null;
        HttpRequest tPost = HttpRequest.ofPost((String)URLUtil.completeUrl((String)this.apiMgmtDmcProp.getUrl(), (String)"/api/dmc/v1/auth/login"));
        HashMap<String, String> tRequestBody = new HashMap<String, String>();
        tRequestBody.put("username", this.apiMgmtDmcProp.getUser());
        tRequestBody.put("pwdhash", this.apiMgmtDmcProp.getHashedPassword());
        tPost.setHeader("Content-Type", (Object)"application/json");
        tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
        if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
            tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
        }
        tPost.setEntity(tRequestBody);
        Map tResponse = (Map)HttpUtil.execute((HttpRequest)tPost, HashMap.class);
        if (null != tResponse && tResponse.get("userToken") != null) {
            tToken = (String)tResponse.get("userToken");
        }
        return tToken;
    }

    @Generated
    public ApiMgmtFileDmcService(ApiMgmtDmcProp apiMgmtDmcProp, ApiMgmtProp prop) {
        this.apiMgmtDmcProp = apiMgmtDmcProp;
        this.prop = prop;
    }
}

