package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProjectVersionRelationMapper;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;

@Primary
@Repository
public class ApiMgmtProjectVersionRelationDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtProjectVersionRelationMapper, ProjectVersionRelation, Long>
        implements ApiMgmtProjectVersionRelationDao {

    public ApiMgmtProjectVersionRelationDaoMybatisImpl() {
        super();
    }

    @Override
    public List<ProjectVersionRelation> getByProjectId(Long projectId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getProjectId, projectId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersionRelation> getByProjectVersionId(String projectVersionId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getProjectVersionId, projectVersionId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersionRelation> getByApiId(Long apiId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getApiId, apiId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public int deleteByApiId(Long apiId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getApiId, apiId);
        return baseMapper.delete(wrapper);
    }

    @Override
    public Long countByProjectId(Long projectId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getProjectId, projectId);
        return baseMapper.selectCount(wrapper);
    }

    @Override
    public Long countByProjectVersionId(List<Long> projectVersionIds) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProjectVersionRelation::getProjectVersionId, projectVersionIds);
        return baseMapper.selectCount(wrapper);
    }

    @Override
    public List<ProjectVersionRelation> selectByApiId(Long apiId) {
        LambdaQueryWrapper<ProjectVersionRelation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersionRelation::getApiId, apiId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public void batchSave(List<ProjectVersionRelation> newProjectVersionList) {
        CollUtil.split(newProjectVersionList, 100)
                .forEach(subList -> baseMapper.saveList(
                        subList,
                        CollUtil.getFirst(subList).getRelationId() != null)
                );
    }
}
