package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiDataNameMapper;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.stream.Collectors;

@Primary
@Repository
public class ApiMgmtStandardApiDataNameDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtStandardApiDataNameMapper, StandardApiDataName, Integer>
        implements ApiMgmtStandardApiDataNameDao {

    protected ApiMgmtProductApiDataNameDaoMybatisImpl productApiDataNameDao;

    public ApiMgmtStandardApiDataNameDaoMybatisImpl() {
        super();
    }

    @Override
    public List<StandardApiDataName> getByApiVerId(Long pApiId, Boolean pShowField) {
        return baseMapper.getByApiVerId(pApiId, pShowField);
    }

    @Override
    public List<StandardApiDataName> getByApiVerIdAndMsgType(Long pApiId, Integer pMsgType, Boolean pShowField) {
        return baseMapper.getByApiVerIdAndMsgType(pApiId, pMsgType, pShowField);
    }

    @Override
    public List<StandardApiDataName> selectByVersionIds(List<Long> subIdList) {
        return baseMapper.selectByVersionIds(subIdList);
    }

    @Override
    public void batchSave(List<StandardApiDataName> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }

        setParentId(null, list);
        List<StandardApiDataName> allList = list.stream()
                .flatMap(StandardApiDataName::flatten).collect(Collectors.toList());

        List<ProductApiDataName> productApiDataNameList = allList.stream()
                .flatMap(v -> v.getProductApiDataNames().stream())
                .collect(Collectors.toList());


        CollUtil.split(allList, 200)
                .forEach(v -> baseMapper.insertList(v));
        productApiDataNameDao.batchSave(productApiDataNameList);
    }

    protected void setParentId(StandardApiDataName parent, List<StandardApiDataName> list) {
        if (parent != null && parent.getId() == null) {
            parent.setId(IdUtil.getSnowflakeNextId());
        }

        CollUtil.emptyIfNull(list).forEach(v -> {
            v.setParent(parent);
            setParentId(v, v.getChildrens());
        });

    }

    @Override
    public int deleteByApiVerId(Long apiVerId) {
        productApiDataNameDao.deleteByApiVerId(apiVerId);
        return baseMapper.deleteByApiVerId(apiVerId);
    }

    @Autowired
    public void setProductApiDataNameMapper(ApiMgmtProductApiDataNameDaoMybatisImpl productApiDataNameDao) {
        this.productApiDataNameDao = productApiDataNameDao;
    }
}
