/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JsonLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class AdvanceSearchApiListGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvanceSearchApiListGetService.class);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;

    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        ArrayList<Map<String, Object>> tResponse = new ArrayList<Map<String, Object>>();
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode)tRequestJsonNode.get("conditionList");
        ArrayList<Map<String, String>> tConditionList = new ArrayList<Map<String, String>>();
        String tProvider = null;
        String tStatus = null;
        boolean tViewAllApi = this.tenantConfigDao.viewAllApiTenantExist(tTenantId);
        HashMap<String, String> tTenantIdCondition = new HashMap<String, String>();
        tTenantIdCondition.put("tenant", tTenantId);
        tConditionList.add(tTenantIdCondition);
        if (tConditionArrayNode.isArray()) {
            for (JsonNode tConditionNode : tConditionArrayNode) {
                String tCondition;
                HashMap<String, String> tConditionMap = new HashMap<String, String>();
                switch (tCondition = tConditionNode.get("condition").asText()) {
                    case "apiName": {
                        tConditionMap.put("apiName", tConditionNode.get("content").asText());
                        tConditionMap.put("apiName_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiTag": {
                        tConditionMap.put("apiTag", tConditionNode.get("content").asText());
                        tConditionMap.put("apiTag_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiDataName": {
                        tConditionMap.put("apiDataName", tConditionNode.get("content").asText());
                        tConditionMap.put("apiDataName_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiDescription": {
                        tConditionMap.put("apiDescription", tConditionNode.get("content").asText());
                        tConditionMap.put("apiDescription_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiRemark": {
                        tConditionMap.put("apiRemark", tConditionNode.get("content").asText());
                        tConditionMap.put("apiRemark_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiSyncType": {
                        tConditionMap.put("apiSyncType", tConditionNode.get("content").asText());
                        break;
                    }
                    case "apiCategory": {
                        tConditionMap.put("apiCategory", tConditionNode.get("content").asText());
                        break;
                    }
                    case "provider": {
                        tProvider = tConditionNode.get("content").asText();
                        tConditionMap.put("provider", tConditionNode.get("content").asText());
                        break;
                    }
                    case "tenantId": {
                        tConditionMap.put("tenantId", tConditionNode.get("content").asText());
                        tConditionMap.put("tenantId_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    case "apiStatus": {
                        tStatus = tConditionNode.get("content").asText();
                        tConditionMap.put("apiStatus", tConditionNode.get("content").asText());
                        break;
                    }
                    case "apiBuildTime": {
                        tConditionMap.put("apiBuildTime", tConditionNode.get("content").asText());
                        tConditionMap.put("apiBuildTime_eq", tConditionNode.get("equation").asText());
                        break;
                    }
                    default: {
                        log.info("\u6761\u4ef6\u8f93\u5165\u4e0d\u6210\u7acb!");
                    }
                }
                tConditionList.add(tConditionMap);
            }
        }
        List<StandardApi> tStandardApiList = this.standardApiDao.advanceSearch(tConditionList, teamType, false, tViewAllApi);
        this.setResponse(tStandardApiList, tProvider, tStatus, tLocale, tResponse);
        return tResponse;
    }

    public void setResponse(List<StandardApi> tStandardApiList, String tProvider, String tStatus, String tLocale, ArrayList<Map<String, Object>> tResponse) {
        if (tStandardApiList != null) {
            for (StandardApi tStandardApi : tStandardApiList) {
                String tCategory;
                String tSyncType;
                String tRemark;
                String tDescription;
                long tApprovedStatusCode;
                String tApprovedStatus;
                StandardApiVersion tStandardApiVersion;
                boolean tProviderBoolean = false;
                if (tProvider != null) {
                    String[] tProviderArr;
                    String tProviders = tStandardApi.getProvider().trim();
                    for (String s : tProviderArr = tProviders.split(",")) {
                        if (!s.trim().equals(tProvider)) continue;
                        tProviderBoolean = true;
                        break;
                    }
                } else {
                    tProviderBoolean = true;
                }
                if (!tProviderBoolean) continue;
                HashMap<String, Object> tApiMap = new HashMap<String, Object>();
                List<StandardApiVersion> tStandardApiVersions = this.standardApiVersionDao.getVersionListByApiId(tStandardApi.getId());
                if (tStatus != null) {
                    List<StandardApiVersion> tStatusVersions = this.getStatus(tStandardApiVersions, Long.valueOf(tStatus));
                    tStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStatusVersions);
                } else {
                    tStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStandardApiVersions);
                }
                switch (tLocale) {
                    case "zh_CN": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionZhCn();
                        tRemark = tStandardApi.getRemarkZhCn();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                        break;
                    }
                    case "zh_TW": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionZhTw();
                        tRemark = tStandardApi.getRemarkZhTw();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                        break;
                    }
                    default: {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                        tApprovedStatusCode = tStandardApiVersion.getApprovedStatus().getId();
                        tDescription = tStandardApi.getDescriptionEnUs();
                        tRemark = tStandardApi.getRemarkEnUs();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                        tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                    }
                }
                tApiMap.put("name", tStandardApi.getName());
                tApiMap.put("version", tStandardApiVersion.getVersion());
                tApiMap.put("approvedStatus", tApprovedStatus);
                tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime()));
                tApiMap.put("approvedStatusCode", tApprovedStatusCode);
                tApiMap.put("description", tDescription);
                tApiMap.put("remark", tRemark);
                tApiMap.put("syncType", tSyncType);
                tApiMap.put("categoryId", tStandardApi.getStandardApiCategory().getId());
                tApiMap.put("categoryName", tCategory);
                tApiMap.put("msgFormat", tStandardApi.getMsgFormat());
                tApiMap.put("provider", tStandardApi.getProvider());
                tApiMap.put("tenantId", tStandardApi.getTenantId());
                tApiMap.put("apiBuildAcct", tStandardApi.getBuildAcct());
                tApiMap.put("apiBuildTime", DateUtil.formatLocalDateTime((LocalDateTime)tStandardApi.getBuildTime()));
                StandardApiVersion firstStandardApiVersion = ApiVersionServiceUtil.getFirstVersion(tStandardApiVersions);
                StandardApiVersion curStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStandardApiVersions);
                String firstV = firstStandardApiVersion.getVersion();
                String lastV = curStandardApiVersion.getVersion();
                tApiMap.put("firstApplicant", firstStandardApiVersion.getApplicant());
                if (firstV.equals(lastV)) {
                    tApiMap.put("lastApplicant", "");
                } else {
                    tApiMap.put("lastApplicant", tStandardApiVersion.getApplicant());
                }
                tApiMap.put("designTenantId", tStandardApiVersion.getStandardApi().getDesignTenantId());
                tResponse.add(tApiMap);
            }
        }
    }

    private List<StandardApiVersion> getStatus(List<StandardApiVersion> tStandardApiVersions, Long pStatus) {
        ArrayList<StandardApiVersion> tStatusVersions = new ArrayList<StandardApiVersion>();
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersions) {
            if (!tStandardApiVersion.getApprovedStatus().getId().equals(pStatus)) continue;
            tStatusVersions.add(tStandardApiVersion);
        }
        return tStatusVersions;
    }
}

