package com.digiwin.athena.apimgmt.dao;

import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;

import java.util.List;

public interface ApiMgmtProjectVersionRelationDao extends GenericDao<ProjectVersionRelation, Long> {

	List<ProjectVersionRelation> getByProjectId(Long projectId);
	
	List<ProjectVersionRelation> getByProjectVersionId(String projectVersionId);
	
	List<ProjectVersionRelation> getByApiId(Long apiId);

	int deleteByApiId(Long apiId);

    Long countByProjectId(Long projectId);

	Long countByProjectVersionId(List<Long> projectVersionIds);

	List<ProjectVersionRelation> selectByApiId(Long apiId);

	void batchSave(List<ProjectVersionRelation> newProjectVersionList);

	List<ProjectVersionRelation> selectByApiIds(List<Long> apiIds);

	void fillRelationToVersion(List<StandardApiVersion> versions);

	void fillProjectVersionRelations(List<StandardApi> apiList);
}