package com.digiwin.athena.apimgmt.facade;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
@Service
@RequiredArgsConstructor
public class ApiInfoFacadeService implements IApiInfoFacadeService {

    private final ObjectMapper mapper;
    private final AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;

    @Override
    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) {
        return CollUtil.split(apiKeys, 50).stream()
                .flatMap(subKeys -> {
                    if (CollUtil.isEmpty(subKeys)) {
                        return Stream.empty();
                    }

                    String queryJson = buildQueryJson(subKeys);
                    log.info("Query API by keys, json: {}", queryJson);

                    Map<String, Object> resultMap;
                    try {
                        resultMap = advanceSearchApiListGetOtherService.execute(queryJson);
                    } catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e.getCause());
                    }

                    return convertToApiInfoDTOList(resultMap).stream();
                })
                .collect(Collectors.toList());
    }

    protected String buildQueryJson(List<ApiMgmtApiKeyDTO> apiKeys) {
        ObjectNode rootNode = mapper.createObjectNode();
        ArrayNode conditionList = mapper.createArrayNode();

        int order = 0;
        for (int i = 0; i < apiKeys.size(); i++) {
            ApiMgmtApiKeyDTO key = apiKeys.get(i);
            String mark = i == 0 ? ApimgmtConstant.MARK_AND : ApimgmtConstant.MARK_OR;
            String openBracket = "(";
            String closeBracket = ")";

            ObjectNode apiNameNode = mapper.createObjectNode();
            apiNameNode.put(ApimgmtConstant.CONDITION, "apiName");
            apiNameNode.put(ApimgmtConstant.EQUATION, "=");
            apiNameNode.put(ApimgmtConstant.CONTENT, key.getApiName());
            apiNameNode.put(ApimgmtConstant.MARK, mark);
            apiNameNode.put(ApimgmtConstant.ORDER, order++);
            apiNameNode.put(ApimgmtConstant.BRACKET, openBracket);
            conditionList.add(apiNameNode);

            if (key.getBranch() != null) {
                ObjectNode apiVersionNode = mapper.createObjectNode();
                apiVersionNode.put(ApimgmtConstant.CONDITION, "apiBranch");
                apiVersionNode.put(ApimgmtConstant.EQUATION, "=");
                apiVersionNode.put(ApimgmtConstant.CONTENT, key.getBranch());
                apiVersionNode.put(ApimgmtConstant.MARK, ApimgmtConstant.MARK_AND);
                apiVersionNode.put(ApimgmtConstant.ORDER, order++);
                apiVersionNode.put(ApimgmtConstant.BRACKET, "");
                conditionList.add(apiVersionNode);
            }

            if (key.getTenantId() != null) {
                ObjectNode tenantIdNode = mapper.createObjectNode();
                tenantIdNode.put(ApimgmtConstant.CONDITION, "tenantId");
                tenantIdNode.put(ApimgmtConstant.EQUATION, "=");
                tenantIdNode.put(ApimgmtConstant.CONTENT, key.getTenantId());
                tenantIdNode.put(ApimgmtConstant.MARK, ApimgmtConstant.MARK_AND);
                tenantIdNode.put(ApimgmtConstant.ORDER, order++);
                tenantIdNode.put(ApimgmtConstant.BRACKET, closeBracket);
                conditionList.add(tenantIdNode);
            } else {
                if (key.getBranch() != null) {
                    ObjectNode lastNode = (ObjectNode) conditionList.get(conditionList.size() - 1);
                    lastNode.put(ApimgmtConstant.BRACKET, closeBracket);
                } else {
                    apiNameNode.put(ApimgmtConstant.BRACKET, "");
                }
            }
        }

        rootNode.set(ApimgmtConstant.CONDITION_LIST, conditionList);
        rootNode.put(ApimgmtConstant.TYPE_STRING, false);
        rootNode.put("statusId", "");
        rootNode.put(ApimgmtConstant.PAGE_SIZE, apiKeys.size());
        rootNode.put(ApimgmtConstant.PAGE_NUM, 1);

        return rootNode.toString();
    }

    protected List<ApiMgmtApiInfoDTO> convertToApiInfoDTOList(Map<String, Object> resultMap) {
        List<ApiMgmtApiInfoDTO> result = new ArrayList<>();

        if (resultMap == null || !resultMap.containsKey(ApimgmtConstant.VALUE)) {
            return result;
        }

        //noinspection unchecked
        List<Map<String, Object>> valueList = (List<Map<String, Object>>) resultMap.get(ApimgmtConstant.VALUE);
        if (CollUtil.isEmpty(valueList)) {
            return result;
        }

        return valueList.stream()
                .map(ApiMgmtApiInfoDTO::fromMap)
                .collect(Collectors.toList());
    }
}
