/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtSyncMdcFailDataDao;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtMdcSyncContext;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import jakarta.annotation.PostConstruct;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtSyncMdcFailDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtSyncMdcFailDataService.class);
    @Autowired
    private ApiMgmtSyncMdcFailDataDao syncMdcFailDataDao;
    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    @Autowired
    private ApiMgmtProp apiMgmtProp;
    @Autowired
    private IApiMgmtMdcSyncContext mdcSyncContext;

    @PostConstruct
    public void initScheduledTask() {
        if (!this.apiMgmtProp.getSync().getMdc().isEnable()) {
            log.info("MDC\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u5df2\u5173\u95ed");
            return;
        }
        long interval = this.apiMgmtProp.getSync().getMdc().getInterval().getSeconds();
        log.info("MDC\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u5df2\u5f00\u542f\uff0c\u95f4\u9694\u65f6\u95f4: {} \u79d2", (Object)interval);
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(5);
        executorService.scheduleWithFixedDelay(() -> {
            long nextSyncTime;
            long startTime = System.currentTimeMillis();
            if (startTime < (nextSyncTime = this.mdcSyncContext.getNextSyncTime())) {
                return;
            }
            try {
                log.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f: " + Calendar.getInstance().getTime());
                List<SyncMdcFailData> list = this.syncMdcFailDataDao.getData();
                log.info("\u67e5\u8be2\u51fa\u7684\u6570\u636e\u91cf: " + list.size());
                if (CollUtil.isNotEmpty(list)) {
                    Map<String, List<SyncMdcFailData>> map = list.stream().collect(Collectors.groupingBy(SyncMdcFailData::getSyncFactory));
                    for (String syncFactory : map.keySet()) {
                        this.syncMdcServiceProcessor.reqSyncMdcMetadataAddCompensate(map.get(syncFactory), syncFactory);
                    }
                }
                log.info("\u8865\u507f\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }, 1L, interval, TimeUnit.SECONDS);
    }
}

