/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.enums.CommunicationEnum;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMailProp;
import com.digiwin.athena.apimgmt.util.StringUtil;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component(value="com.digiwin.dsms.service.MailService")
public class ApiMgmtMailService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtMailService.class);
    private final JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
    @Autowired
    private ApiMgmtMailProp mailProp;

    public void sendMail(String pTo, String pMailContent, String pSubject) throws MessagingException {
        MimeMessage tMailMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper tMessageHelper = new MimeMessageHelper(tMailMessage, true, "utf-8");
        tMessageHelper.setTo(pTo);
        tMessageHelper.setFrom(this.mailProp.getFrom());
        tMessageHelper.setSubject(pSubject);
        tMessageHelper.setText(pMailContent, true);
        log.info("Send email to: " + pTo);
        this.mailSender.send(tMailMessage);
    }

    public void sendMailToAdmin(String pMailContent, String pSubject) {
        String pTo = this.mailProp.getAlertAddress();
        try {
            this.sendMail(pTo, pMailContent, pSubject);
        }
        catch (Exception e) {
            log.error("Send Email message error.", (Throwable)e);
        }
    }

    protected void init() {
        log.info("Mail service start");
        this.mailSender.setHost(this.mailProp.getServer().getHostname());
        this.mailSender.setPort(this.mailProp.getServer().getPort().intValue());
        this.mailSender.setUsername(this.mailProp.getServer().getUsername());
        this.mailSender.setPassword(this.mailProp.getServer().getPassword());
        if (StringUtil.isEmptyOrSpace((Object)this.mailProp.getServer().getUsername())) {
            this.mailSender.setJavaMailProperties((Properties)new MailServiceProperties(this.mailProp, false));
        } else {
            this.mailSender.setJavaMailProperties((Properties)new MailServiceProperties(this.mailProp, true));
        }
    }

    public void afterPropertiesSet() {
        this.init();
    }

    static class MailServiceProperties
    extends Properties {
        private static final long serialVersionUID = -6985941591953133952L;

        public MailServiceProperties(ApiMgmtMailProp mailProp, boolean pIsSmtpAuth) {
            super.setProperty("mail.smtp.auth", String.valueOf(pIsSmtpAuth));
            String authentication = mailProp.getServer().getAuthentication();
            if (CommunicationEnum.TLS.getCode().equals(authentication)) {
                super.setProperty("mail.smtp.starttls.enable", "true");
            }
            if (CommunicationEnum.SSL.getCode().equals(authentication)) {
                super.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
        }
    }
}

