/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.dao.ApiMgmtSyncMdcFailDataDao;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.HttpResponse;
import com.digiwin.athena.apimgmt.infra.http.RequestOption;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import com.digiwin.athena.apimgmt.service.model.AddApiData;
import com.digiwin.athena.apimgmt.service.model.AddApiVer;
import com.digiwin.athena.apimgmt.service.model.MdcResponse;
import com.digiwin.athena.apimgmt.service.util.MailServiceUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtSyncMdcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtSyncMdcService.class);
    @Autowired
    private ApiMgmtSyncMdcFailDataDao syncMdcFailDataDao;

    @Async
    public void reqSyncMdcMetadataAdd(List<Long> data, AddApiData tAddApiData, String pSyncUrl, String tUserId, String tToken, String routerKey) {
        String tUrl = pSyncUrl + "/restful/standard/mdc/StdApiMetadata/Update";
        String tStrJsonRequestBody = "";
        int httpStatusCode = -1;
        try {
            tStrJsonRequestBody = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)tAddApiData);
            HttpRequest tHttpPost = HttpRequest.ofPost((String)tUrl);
            tHttpPost.setEntity((Object)tStrJsonRequestBody);
            tHttpPost.setHeader("userId", (Object)tUserId);
            tHttpPost.setHeader("token", (Object)tToken);
            if (null != routerKey) {
                tHttpPost.setHeader("routerKey", (Object)routerKey);
            }
            MdcResponse tResponse = (MdcResponse)HttpUtil.execute((HttpRequest)tHttpPost, MdcResponse.class);
            String tMdcStatCode = tResponse.getExecution().getCode();
            String tResponseMessage = tResponse.getExecution().getDescription();
            if (!"000".equals(tMdcStatCode)) {
                String tMailContent = MessageFormat.format("<HTML><BODY>{0} {1}<BR><BR>{2}<BR><BR><BR>\u8acb\u6c42MDC url: {3}<BR>request message body: {4}<BR>HTTP\u72c0\u614b\u78bc: {5}<BR>MDC\u56de\u61c9\u7684\u8a0a\u606f: {6}</BODY></HTML>", "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u65b0\u589e\u5931\u6557.", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()), this.genAddApiDataInfoStr(tAddApiData), tUrl, tStrJsonRequestBody, tMdcStatCode + "/" + httpStatusCode, tResponseMessage);
                MailServiceUtil.sendMailToAdmin(tMailContent, "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u65b0\u589e\u5931\u6557.");
            }
        }
        catch (Exception e) {
            String tResponseMessage;
            if (e instanceof HttpFailedException) {
                httpStatusCode = ((HttpFailedException)e).getStatusCode();
                tResponseMessage = ((HttpFailedException)e).getRespBody();
            } else {
                httpStatusCode = 500;
                tResponseMessage = e.getMessage();
            }
            for (Long apiVersionId : data) {
                SyncMdcFailData syncMdcFailData = new SyncMdcFailData();
                syncMdcFailData.setApiVerId(apiVersionId);
                syncMdcFailData.setSyncFactory(pSyncUrl);
                syncMdcFailData.setSuccessFlag(false);
                syncMdcFailData.setBuildTime(LocalDateTime.now());
                syncMdcFailData.setUpdateTime(LocalDateTime.now());
                this.syncMdcFailDataDao.save(syncMdcFailData);
            }
            String tMailContent = MessageFormat.format("<HTML><BODY>{0} {1}<BR><BR>{2}<BR><BR><BR>\u8acb\u6c42MDC url: {3}<BR>request message body: {4}<BR>HTTP\u72c0\u614b\u78bc: {5}<BR>MDC\u56de\u61c9\u7684\u8a0a\u606f: {6}</BODY></HTML>", "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u65b0\u589e\u5931\u6557.", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()), this.genAddApiDataInfoStr(tAddApiData), tUrl, tStrJsonRequestBody, httpStatusCode, tResponseMessage);
            MailServiceUtil.sendMailToAdmin(tMailContent, "\u540c\u6b65API\u5143\u6578\u64da\u81f3MDC\uff0c\u540c\u6b65\u65b0\u589e\u5931\u6557.");
        }
    }

    public void reqSyncMdcMetadataAddCompensate(List<SyncMdcFailData> syncMdcFailDataList, AddApiData tAddApiData, String pSyncUrl) {
        String tUrl = pSyncUrl + "/restful/standard/mdc/StdApiMetadata/Update";
        try {
            String tStrJsonRequestBody = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)tAddApiData);
            HttpRequest tHttpPost = HttpRequest.ofPost((String)tUrl);
            tHttpPost.setEntity((Object)tStrJsonRequestBody);
            tHttpPost.setHeader("userId", (Object)"compensation_task");
            String routerKeyValue = ApiMgmtServiceContextHolder.getRouterKey();
            if (null != routerKeyValue) {
                tHttpPost.setHeader("routerKey", (Object)routerKeyValue.toString());
            }
            HttpResponse tResponse = (HttpResponse)HttpUtil.execute((HttpRequest)tHttpPost, HttpResponse.class, (RequestOption)RequestOption.of().setRetryEnabled(false));
            int httpStatusCode = tResponse.getStatusCode();
            String tResponseMessage = tResponse.getBody();
            if (httpStatusCode == 200) {
                MdcResponse tMdcResponse = (MdcResponse)new Gson().fromJson(tResponseMessage, MdcResponse.class);
                String tMdcStatCode = tMdcResponse.getExecution().getCode();
                if ("000".equals(tMdcStatCode)) {
                    for (SyncMdcFailData syncMdcFailData : syncMdcFailDataList) {
                        syncMdcFailData.setSuccessFlag(true);
                        syncMdcFailData.setUpdateTime(LocalDateTime.now());
                        this.syncMdcFailDataDao.saveOrupdate(syncMdcFailData);
                    }
                }
            } else {
                log.error("\u8865\u507f\u540c\u6b65MDC\u5904\u7406\u54cd\u5e94\u7801\u5f02\u5e38\uff01status:{},msg:{}", (Object)httpStatusCode, (Object)tResponseMessage);
            }
        }
        catch (Exception e) {
            log.error("\u8865\u507f\u540c\u6b65MDC\u5904\u7406\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private String genAddApiDataInfoStr(AddApiData tAddApiData) {
        String tStr = "";
        try {
            for (AddApiVer tAddApiVer : tAddApiData.getApi_data()) {
                String tApiName = tAddApiVer.getApi_name();
                String tApiVer = tAddApiVer.getApi_version_info().get(0).getApi_version();
                String tTenantId = tAddApiVer.getTenant_id();
                tStr = MessageFormat.format("{0}{1}API\u540d\u7a31: {2}, API\u7248\u672c: {3}, \u79df\u6236ID: {4}", tStr, "<BR>", tApiName, tApiVer, tTenantId);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tStr;
    }
}

