package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 取得信息類別清單
 * /restful/standard/apimgmt/ApiCategory/Get
 */
@Slf4j
@Service
public class ApiCategoryGetService {

	@Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;
	
	public ArrayList<Map<String, Object>> execute(String validatorResult) {
		log.debug("[Thread.id " + Thread.currentThread().getId() + "]" + "接口：" + this.getClass() +
				"，原始訊息：" + validatorResult);
		// 取得語系
		String tLocale = ApiMgmtServiceContextHolder.getLocale();
		// header沒傳語系的話，默認回傳英文
		tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
		ArrayList<Map<String, Object>> tResponse = new ArrayList<>();
		List<StandardApiCategory> tStandardApiCategoryList = standardApiCategoryDao.getAll();
		// 組成回傳訊息
		for(StandardApiCategory tStandardApiCategory : tStandardApiCategoryList){
			Map<String, Object> tCategoryMap = new HashMap<>();
			String tCategory;
			switch(tLocale){
			case ApimgmtConstant.ZH_CN:
				tCategory = tStandardApiCategory.getNameZhCn();
				break;
			case ApimgmtConstant.ZH_TW:
				tCategory = tStandardApiCategory.getNameZhTw();
				break;
			case ApimgmtConstant.EN_US:
			default:
				tCategory = tStandardApiCategory.getNameEnUs();
				break;
			}
			tCategoryMap.put(ApimgmtConstant.ID, tStandardApiCategory.getId());
			tCategoryMap.put(ApimgmtConstant.CATEGORY, tCategory);
			tResponse.add(tCategoryMap);
		}
		return tResponse;
	}
}
