package com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper;

import com.digiwin.athena.apimgmt.dao.impl.mybatis.MpPage;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.WhereCondition;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ApiMgmtStandardApiMapper extends BaseMapperPlus<StandardApi> {

    List<StandardApi> advanceSearch(@Param("conditionList") List<WhereCondition> pConditionList,
                                    @Param("tenantId") String tenantId,
                                    @Param("teamType") String teamType,
                                    @Param("queryByCreator") boolean queryByCreator,
                                    @Param("viewAllApi") boolean pViewAllApi);

    List<Long> advanceApiSearchVersionIds(@Param("conditionList") List<WhereCondition> pList,
                                          @Param("teamType") String teamType,
                                          @Param("tenantId") String tenantId,
                                          @Param("queryByCreator") boolean queryByCreator,
                                          @Param("viewAllApi") boolean pViewAllApi,
                                          MpPage<?> page);

    List<StandardApiVersion> selectVersionsByIds(@Param("versionIds") List<Long> versionIds);

    List<Long> advanceStandardApiCountSearch(@Param("conditionList") List<WhereCondition> pList,
                                             @Param("teamType") String teamType,
                                             @Param("tenantId") String pTenantId,
                                             @Param("queryByCreator") boolean queryByCreator,
                                             @Param("viewAllApi") boolean tViewAllApi);

    StandardApi saveApi(@Param("api") StandardApi pStandardApi,
                        @Param("cleanProjectRelation") boolean cleanProjectRelation);
}
