package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.StandardApiColumnTypeConstants;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.enums.MessageTypeEnum;
import com.digiwin.athena.apimgmt.enums.SyncMetaDataCacheResultEnum;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.*;
import com.digiwin.athena.apimgmt.service.model.*;
import com.digiwin.athena.apimgmt.service.model.Description;
import com.digiwin.athena.apimgmt.service.util.DaoServiceUtil;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ApiMgmtSyncMdcAddService {

    @Autowired
    private ApimgmtProductDao productDao;

    @Autowired
    private ApiMgmtSyncMdcService syncMdcService;

    @Autowired
    private ApiMgmtMdcProp mdcProp;

    /**
     * 送审|定版同步MDC元数据
     *
     * @param pListApiVerIdNeedToSyncMetadata pListApiVerIdNeedToSyncMetadata
     * @param pSyncUrl                        pSyncUrl
     * @return Map
     */
    public Map<String, String> runSyncMdcMetadataAdd(List<Long> pListApiVerIdNeedToSyncMetadata, String pSyncUrl, String tUserId, String tToken, String routerKey) {
        Map<String, String> tResult = new HashMap<>();
        int tSize = pListApiVerIdNeedToSyncMetadata.size();
        if (0 < tSize) {
            //分批处理
            Integer mdcBatchNum = mdcProp.getBatchNum();
            int sum = (int) Math.ceil(1.0 * tSize / mdcBatchNum);
            for (int i = 0; i < sum; i++) {
                AddApiData tAddApiData = new AddApiData();
                List<Long> data = pListApiVerIdNeedToSyncMetadata.subList(i * mdcBatchNum, Math.min(i * mdcBatchNum + mdcBatchNum, tSize));
                for (Long tApiVerId : data) {
                    AddApiVer tAddApiVer = buildModel(tApiVerId);
                    //非esp的API不需要同步
                    if (StringUtils.isNoneBlank(tAddApiVer.getApiType()) && !ApimgmtConstant.DEFAULT_API_TYPE.equals(tAddApiVer.getApiType())) {
                        continue;
                    }
                    tAddApiData.getApi_data().add(tAddApiVer);
                }
                syncMdcService.reqSyncMdcMetadataAdd(data, tAddApiData, pSyncUrl, tUserId, tToken, routerKey);
            }
        }
        tResult.put(SyncMetaDataCacheResultEnum.RESULT.toString(), Boolean.TRUE.toString());
        return tResult;
    }

    /**
     * 同步MDC异常信息补偿消费
     *
     * @param syncMdcFailDataList syncMdcFailDataList
     * @param pSyncUrl        pSyncUrl
     */
    public void reqSyncMdcMetadataAddCompensate(List<SyncMdcFailData> syncMdcFailDataList, String pSyncUrl) {
        int tSize = syncMdcFailDataList.size();
        if (0 < tSize) {
            Integer mdcBatchNum = mdcProp.getBatchNum();
            //分批处理
            int sum = (int) Math.ceil(1.0 * tSize / mdcBatchNum);
            for (int i = 0; i < sum; i++) {
                AddApiData tAddApiData = new AddApiData();
                List<SyncMdcFailData> data = syncMdcFailDataList.subList(i * mdcBatchNum, Math.min(i * mdcBatchNum + mdcBatchNum, tSize));
                for (SyncMdcFailData syncMdcFailData : data) {
                    AddApiVer tAddApiVer = buildModel(syncMdcFailData.getApiVerId());
                    //非esp的API不需要同步
                    if (StringUtils.isNoneBlank(tAddApiVer.getApiType()) && !ApimgmtConstant.DEFAULT_API_TYPE.equals(tAddApiVer.getApiType())) {
                        continue;
                    }
                    tAddApiData.getApi_data().add(tAddApiVer);
                }
                syncMdcService.reqSyncMdcMetadataAddCompensate(data, tAddApiData, pSyncUrl);
            }
        }
    }

    private void buildSubModel(ApiDataName pApiDataName, List<StandardApiDataName> pListOfHierarchyNodes) {
        for (StandardApiDataName tStandardApiDataName : pListOfHierarchyNodes) {
            ApiDataName tApiDataName = new ApiDataName();
            tApiDataName.setData_name(tStandardApiDataName.getStandardDataName());
            if ((null != tStandardApiDataName.getChildrens()) && (0 < tStandardApiDataName.getChildrens().size())) {
                tApiDataName.setData_type("object");
                buildSubModel(tApiDataName, tStandardApiDataName.getChildrens());
            } else if ("M".equals(tStandardApiDataName.getColumnType())) {
                tApiDataName.setData_type("object");
                tApiDataName.setField(new ArrayList<>());
            } else {
                tApiDataName.setData_type(tStandardApiDataName.getDataType());
            }
            tApiDataName.setRequired(tStandardApiDataName.getIsRequired());
            tApiDataName.setIs_datakey(tStandardApiDataName.getIsDatakey());
            tApiDataName.setIs_array(tStandardApiDataName.getIsArray());
            tApiDataName.setCanSort(tStandardApiDataName.getCanSort());
            tApiDataName.setCanFilter(tStandardApiDataName.getCanFilter());
            tApiDataName.setIs_business_key(tStandardApiDataName.getIsBusinesskey());
            tApiDataName.setDescription(new Description(tStandardApiDataName.getDescriptionZhTw(), tStandardApiDataName.getDescriptionZhCn(), tStandardApiDataName.getDescriptionEnUs()));
            tApiDataName.setListEnum(new ListEnum(tStandardApiDataName.getListEnumZhTw(), tStandardApiDataName.getListEnumZhCn(), tStandardApiDataName.getListEnumEn()));
            if (null != tStandardApiDataName.getRemarkZhTw()) {
                tApiDataName.setRemark(new Remark(tStandardApiDataName.getRemarkZhTw(), tStandardApiDataName.getRemarkZhCn(), tStandardApiDataName.getRemarkEnUs()));
            }
            // 長度精度.
            ApiDataNameLength tApiDataNameLength = new ApiDataNameLength();
            for (ProductApiDataName tProductApiDataName : tStandardApiDataName.getProductApiDataNames()) {
                ApiDataNamePrecision tApiDataNamePrecision = new ApiDataNamePrecision();
                tApiDataNamePrecision.setProd_name(tProductApiDataName.getProduct().getName());
                if ("string".equals(tStandardApiDataName.getDataType())) {
                    tApiDataNamePrecision.setPrecision(tProductApiDataName.getLength());
                } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                    tApiDataNamePrecision.setPrecision(tProductApiDataName.getLength(), tProductApiDataName.getPrecision());
                }
                tApiDataNameLength.getProd_type().add(tApiDataNamePrecision);
            }
            tApiDataName.setData_length(tApiDataNameLength);
            pApiDataName.getField().add(tApiDataName);
        }
    }

    private ApiDataName buildStdDataModel(ApiDataName pApiDataName_StdData, Long pApiVerId, MessageTypeEnum pStandardApiMessageType) {
        List<StandardApiDataName> tListOfHierarchyNodes = StandardApiMessageUtil.generateListOfHierarchyNodes(DaoServiceUtil.getStandardApiDataNameDao().getByApiVerIdAndMsgType(pApiVerId, pStandardApiMessageType.getValue(), true), pApiVerId);
        // execution
        List<StandardApiDataName> tListOfHierarchyNodes_Execution = StandardApiMessageUtil.filterHierarchyNodes(tListOfHierarchyNodes, StandardApiColumnTypeConstants.EXECUTION_CONSTANTS);
        ApiDataName tApiDataName_Execution;
        if (0 != tListOfHierarchyNodes_Execution.size()) {
            tApiDataName_Execution = new ApiDataName("execution", "object", Boolean.TRUE);
            buildSubModel(tApiDataName_Execution, tListOfHierarchyNodes_Execution);
            pApiDataName_StdData.getField().add(tApiDataName_Execution);
        }
        // parameter
        List<StandardApiDataName> tListOfHierarchyNodes_Parameter = StandardApiMessageUtil.filterOutHierarchyNodesForParameter(tListOfHierarchyNodes);
        ApiDataName tApiDataName_Parameter;
        if (0 != tListOfHierarchyNodes_Parameter.size()) {
            tApiDataName_Parameter = new ApiDataName("parameter", "object", Boolean.TRUE);
            buildSubModel(tApiDataName_Parameter, tListOfHierarchyNodes_Parameter);
            pApiDataName_StdData.getField().add(tApiDataName_Parameter);
        }
        return pApiDataName_StdData;
    }

    private IRequest buildRequestModel(IRequest pRe, Long pApiVerId, MessageTypeEnum pStandardApiMessageType) {
        pRe.getHeader().add(new HeaderField("ContentType", new Description("application/json", "application/json", "application/json")));
        if (MessageTypeEnum.REQUEST.equals(pStandardApiMessageType)) {
            pRe.getHeader().add(new HeaderField("digi-type", new Description("調用模式：sync(同步)/async(異步)/fasync(全異步)", "调用模式：sync(同步)/async(异步)/fasync(全异步)", "Integration Type：sync/async/fasync")));
            pRe.getHeader().add(
                    new HeaderField("digi-host", new Description("發起方資訊：{\"prod\":\"Athena\",\"ver\":\"1.0\",\"ip\":\"\",\"id\":\"BpmCloud\",\"lang\":\"zh_CN\",\"acct\":\"DS\",\"timestamp\":\"20200605151102484\"}",
                            "發起方资讯：{\"prod\":\"Athena\",\"ver\":\"1.0\",\"ip\":\"\",\"id\":\"BpmCloud\",\"lang\":\"zh_CN\",\"acct\":\"DS\",\"timestamp\":\"20200605151102484\"}",
                            "host info：{\"prod\":\"Athena\",\"ver\":\"1.0\",\"ip\":\"\",\"id\":\"BpmCloud\",\"lang\":\"zh_CN\",\"acct\":\"DS\",\"timestamp\":\"20200605151102484\"}")));
            pRe.getHeader().add(
                    new HeaderField("digi-service", new Description("服務方資訊：{\"tenant_id\":\"athenaTestW\",\"prod\":\"WFGP\",\"uid\":\"WF_335\",\"name\":\"purchase.order.creation.process\"}",
                            "服务方資訊：{\"tenant_id\":\"athenaTestW\",\"prod\":\"WFGP\",\"uid\":\"WF_335\",\"name\":\"purchase.order.creation.process\"}", "service info：{\"tenant_id\":\"athenaTestW\",\"prod\":\"WFGP\",\"uid\":\"WF_335\",\"name\":\"purchase.order.creation.process\"}")));
            pRe.getHeader().add(new HeaderField("digi-key", new Description("安全碼：MD5 encode(digi-host + digi-service)", "安全码：MD5 encode(digi-host + digi-service)", "security key：MD5 encode(digi-host + digi-service)")));
        }
        List<StandardApiDataName> tListOfHierarchyNodes = StandardApiMessageUtil.generateListOfHierarchyNodes(DaoServiceUtil.getStandardApiDataNameDao().getByApiVerIdAndMsgType(pApiVerId, pStandardApiMessageType.getValue(), true), pApiVerId);
        // H
        List<StandardApiDataName> tListOfHierarchyNodes_H = StandardApiMessageUtil.filterHierarchyNodes(tListOfHierarchyNodes, StandardApiColumnTypeConstants.HEADER_CONSTANTS);
        for (StandardApiDataName tStandardApiDataName : tListOfHierarchyNodes_H) {
            pRe.getHeader().add(new HeaderField(tStandardApiDataName.getStandardDataName(), new Description(tStandardApiDataName.getDescriptionZhTw(), tStandardApiDataName.getDescriptionZhCn(), tStandardApiDataName.getDescriptionEnUs())));
        }
        // body
        pRe.setBody(buildStdDataModel(new ApiDataName("std_data", "object", Boolean.TRUE), pApiVerId, pStandardApiMessageType));
        return pRe;
    }

    private AddApiVer CreateAddApiVer(StandardApi pStandardApi) {
        String tApiName = pStandardApi.getName();
        String tType = pStandardApi.getStandardApiSyncType().getNameEnUs();
        String tCategory = pStandardApi.getStandardApiCategory().getNameZhTw();
        String provider = pStandardApi.getProvider();
        String tParentApiName = pStandardApi.getParentApiName();
        Description tDescription = new Description(pStandardApi.getDescriptionZhTw(), pStandardApi.getDescriptionZhCn(), pStandardApi.getDescriptionEnUs());
        String tApiExtend = pStandardApi.getApiExtend();
        AddApiVer addApiVer = new AddApiVer(tApiName, tType, tCategory, provider, tDescription, tParentApiName, tApiExtend);
        addApiVer.setApiType(pStandardApi.getApiType());

        return addApiVer;
    }

    private ApiVerInfo CreateApiVerInfo(StandardApiVersion pStandardApiVersion) {
        ApiVerInfo tApiVerInfo = new ApiVerInfo();
        tApiVerInfo.setApi_version(pStandardApiVersion.getVersion());
        tApiVerInfo.setIdempotency(pStandardApiVersion.getIdempotency());
        tApiVerInfo.setApproved_status(String.valueOf(pStandardApiVersion.getApprovedStatus().getId()));
        return tApiVerInfo;
    }

    public ApiMetaData CreateApiMetaData(Long pApiVerId) {
        ApiMetaData tApiMetaData = new ApiMetaData();
        IRequest tRequest = buildRequestModel(new Request(), pApiVerId, MessageTypeEnum.REQUEST);
        IRequest tResponseSuccess = buildRequestModel(new ResponseSuccess(), pApiVerId, MessageTypeEnum.RESPONSE_SUCCESS);
        IRequest tResponseFailed = buildRequestModel(new ResponseFailed(), pApiVerId, MessageTypeEnum.RESPONSE_FAILED);
        tApiMetaData.setRequest((Request) tRequest);
        tApiMetaData.setResponse_success((ResponseSuccess) tResponseSuccess);
        tApiMetaData.setResponse_failed((ResponseFailed) tResponseFailed);
        return tApiMetaData;
    }

    private boolean IsApi(List<Product> pListPrd, final StandardApi tStandardApi) {
        return CollUtil.emptyIfNull(pListPrd).stream().filter(tProduct -> (Boolean.TRUE).equals(tProduct.getIsAgile()))
                .anyMatch(tProduct -> tProduct.getName().equals(tStandardApi.getProvider()));
    }

    private void IsTenantId(StandardApi pStandardApi, AddApiVer pAddApiVer) {
        String tTenantId = pStandardApi.getTenantId();
        if (!StringUtils.isBlank(tTenantId)) {
            pAddApiVer.setTenant_id(tTenantId);
            // 修改自API.
            String tPackageName = pStandardApi.getPackageName();
            if (!StringUtils.isBlank(tPackageName)) {
                pAddApiVer.setPackage_name(tPackageName);
            } else {
                pAddApiVer.setPackage_name("");
            }
        }
    }

    private AddApiVer buildModel(Long tApiVerId) {
        StandardApiVersion tStandardApiVersion = DaoServiceUtil.getStandardApiVersionDao().get(tApiVerId);
        final StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
        final AddApiVer tAddApiVer = CreateAddApiVer(tStandardApi);
        // [S00-20200818001] 敏態API.
        List<Product> tListPrd = productDao.getAll();
        if (IsApi(tListPrd, tStandardApi)) {
            tAddApiVer.setApp_name(tStandardApi.getProvider());
        }
        // 租戶ID.
        IsTenantId(tStandardApi, tAddApiVer);
        if (null != tStandardApi.getRemarkZhTw()) {
            Remark tRemark = new Remark(tStandardApi.getRemarkZhTw(), tStandardApi.getRemarkZhCn(), tStandardApi.getRemarkEnUs());
            tAddApiVer.setRemark(tRemark);
        }
        ApiVerInfo tApiVerInfo = CreateApiVerInfo(tStandardApiVersion);
        ApiMetaData tApiMetaData = CreateApiMetaData(tApiVerId);
        tApiVerInfo.setData_metadata(tApiMetaData);
        tAddApiVer.getApi_version_info().add(tApiVerInfo);
        return tAddApiVer;
    }

}
