package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.apimgmt.dao.GenericDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.BaseMapperPlus;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@Slf4j
public abstract class GenericDaoMybatisImpl<M extends BaseMapperPlus<T>, T, PK extends Serializable>
        implements GenericDao<T, PK> {

    protected M baseMapper;

    protected ServiceImpl<M, T> batchService;

    @SuppressWarnings("unchecked")
    protected Class<T> entityClass = (Class<T>) ReflectionKit.getSuperClassGenericType(getClass(), GenericDaoMybatisImpl.class, 1);

    @Override
    public List<T> getAll() {
        return baseMapper.selectList(null);
    }

    @Override
    public T get(PK id) {
        // TODO 为null时报错，com.digiwin.athena.apimgmt.services.SyncMdcAddService.buildModel报错导致中断
        T entity = baseMapper.selectById(id);
        if (entity == null) {
            log.warn("Uh oh, '{}' object with id '{}' not found...", entityClass, id);
            throw new RuntimeException("Entity not found with id: " + id);
        }
        return entity;
    }

    @Override
    public boolean exists(PK id) {
        return baseMapper.selectById(id) != null;
    }

    @Override
    @Transactional
    public T save(T object) {
        if (null != object) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
            Assert.notNull(tableInfo, "error: can not execute. because can not find cache of TableInfo for entity!");
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty(keyProperty, "error: can not execute. because can not find column for id from entity!");
            Object idVal = tableInfo.getPropertyValue(object, tableInfo.getKeyProperty());

            if (StringUtils.checkValNull(idVal) || Objects.isNull(baseMapper.selectById((Serializable) idVal))) {
                baseMapper.insert(object);
            } else {
                baseMapper.updateById(object);
            }

            return object;
        }

        return null;
    }

    @Override
    public void remove(PK id) {
        baseMapper.deleteById(id);
    }


    @Override
    @Transactional
    public void saveOrupdate(T object) {
        save(object);
    }

    @Autowired
    public void setBaseMapper(M baseMapper) {
        this.baseMapper = baseMapper;
        this.batchService = new BatchService(baseMapper);
    }

    public class BatchService extends ServiceImpl<M, T> {

        public BatchService(M baseMapper) {
            this.baseMapper = baseMapper;
        }

        protected Class<M> currentMapperClass() {
            //noinspection unchecked
            return (Class<M>) GenericDaoMybatisImpl.this.baseMapper.getClass().getInterfaces()[0];
        }

        protected Class<T> currentModelClass() {
            return entityClass;
        }
    }
}
