package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service("openapi")
public class ApiMgmtStandardOpenApiSpecAnalyzeService extends ApiMgmtStandardApiSpecAnalyzeService {

    @Autowired
    private ApiMgmtProp prop;

    @Override
    protected void setStandardApiExtend(List<Map<String, String>> tResult, StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale) {
        //API名称格式校验
        String tApiName = pRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        pStandardApi.setName(tApiName);
        // 区分esp与openapi
        if (ApimgmtConstant.PATTERN_OPEN_API_NAME.matcher(tApiName).matches()) {
            // 区分测试区与paas区的名称 防止重复
            if (prop.isEnvType()) {
                pStandardApi.setName(ApimgmtConstant.API_PAAS_REGEX + tApiName);
            } else {
                pStandardApi.setName(tApiName);
            }
        } else {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 2L, null, 0, 0, pLocale);
        }

        // 父类API名称
        if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString())
                && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText())) {
            //不支持父类API
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 40L, null, 0, 0, pLocale);
        }

        //校验协议和请求方法(json schema校验和代码校验有什么区别)
        String protocol = pRequestJsonNode.get(ApiAttributeEnum.protocol.toString()).asText();
        pStandardApi.setProtocol(protocol);

        String requestMethod = pRequestJsonNode.get(ApiAttributeEnum.requestMethod.toString()).asText();
        pStandardApi.setRequestMethod(requestMethod);

        String apiPath = pRequestJsonNode.get(ApiAttributeEnum.apiPath.toString()).asText();
        pStandardApi.setApiPath(apiPath);
    }

}