/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.util;

import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StandardApiMessageUtil {
    public static Map<Integer, List<StandardApiDataName>> getMsgTypeMap(List<StandardApiDataName> plistOfNodes) {
        HashMap<Integer, List<StandardApiDataName>> tMap = new HashMap<Integer, List<StandardApiDataName>>();
        ArrayList<StandardApiDataName> tlistOfHierarchyNodesRequest = new ArrayList<StandardApiDataName>();
        ArrayList<StandardApiDataName> tlistOfHierarchyNodesResponseSuccess = new ArrayList<StandardApiDataName>();
        ArrayList<StandardApiDataName> tlistOfHierarchyNodesResponseFailed = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tApiDataName : plistOfNodes) {
            switch (tApiDataName.getMsgType()) {
                case 1: {
                    tlistOfHierarchyNodesRequest.add(tApiDataName);
                    break;
                }
                case 2: {
                    tlistOfHierarchyNodesResponseSuccess.add(tApiDataName);
                    break;
                }
                case 3: {
                    tlistOfHierarchyNodesResponseFailed.add(tApiDataName);
                    break;
                }
            }
        }
        tMap.put(1, tlistOfHierarchyNodesRequest);
        tMap.put(2, tlistOfHierarchyNodesResponseSuccess);
        tMap.put(3, tlistOfHierarchyNodesResponseFailed);
        return tMap;
    }

    public static List<StandardApiDataName> generateListOfHierarchyNodes(List<StandardApiDataName> pListOfNodes, Long pApVerid) {
        pListOfNodes = pListOfNodes.stream().distinct().collect(Collectors.toList());
        ArrayList<StandardApiDataName> listOfHierarchyNodes = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tApiDataName : pListOfNodes) {
            if (tApiDataName.getParentId() != null) continue;
            if (null != pApVerid) {
                StandardApiMessageUtil.addAllNodes(tApiDataName, pListOfNodes);
            }
            listOfHierarchyNodes.add(tApiDataName);
        }
        return listOfHierarchyNodes;
    }

    private static void addAllNodes(StandardApiDataName pParent, List<StandardApiDataName> pListOfNodes) {
        ArrayList<StandardApiDataName> tChildrens = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tApiDataName : pListOfNodes) {
            if (tApiDataName.getParentId() == null || !pParent.getId().equals(tApiDataName.getParentId())) continue;
            tChildrens.add(tApiDataName);
            StandardApiMessageUtil.addAllNodes(tApiDataName, pListOfNodes);
        }
        pParent.setChildrens(tChildrens);
    }

    public static List<StandardApiDataName> filterOutHierarchyNodesForParameter(List<StandardApiDataName> pListOfHierarchyNodes) {
        ArrayList<StandardApiDataName> tNewListOfHierarchyNodes = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tStandardApiDataName : pListOfHierarchyNodes) {
            if (tStandardApiDataName.getColumnType().equals("datakey") || tStandardApiDataName.getColumnType().equals("H") || tStandardApiDataName.getColumnType().equals("E")) continue;
            tNewListOfHierarchyNodes.add(tStandardApiDataName);
        }
        return tNewListOfHierarchyNodes;
    }

    public static List<StandardApiDataName> filterHierarchyNodes(List<StandardApiDataName> pListOfHierarchyNodes, String StandardApiColumnTypeConstantsString) {
        ArrayList<StandardApiDataName> tNewListOfHierarchyNodes = new ArrayList<StandardApiDataName>();
        for (StandardApiDataName tStandardApiDataName : pListOfHierarchyNodes) {
            if (!tStandardApiDataName.getColumnType().equals(StandardApiColumnTypeConstantsString)) continue;
            tNewListOfHierarchyNodes.add(tStandardApiDataName);
        }
        return tNewListOfHierarchyNodes;
    }

    public static List<List<AdvanceSearchValue>> generateQuery(ArrayNode tConditionArrayNode, JsonNode tCategoryId, JsonNode tStatusId, JsonNode tType, JsonNode projectId, JsonNode projectVersionId, String tUserId) {
        ArrayList<List<AdvanceSearchValue>> arrayList = new ArrayList<List<AdvanceSearchValue>>();
        ArrayList<AdvanceSearchValue> advanceSearchValueList = new ArrayList<AdvanceSearchValue>();
        boolean bracketJudge = false;
        int bracketOrder = 0;
        for (int i = 0; i < tConditionArrayNode.size(); ++i) {
            JsonNode tConditionNode = tConditionArrayNode.get(i);
            JsonNode bracket = tConditionNode.get("bracket");
            JsonNode mark = tConditionNode.get("mark");
            if (null == bracket && !bracketJudge) {
                advanceSearchValueList = new ArrayList();
                advanceSearchValueList.add(new AdvanceSearchValue(tConditionNode.get("content").asText(), tConditionNode.get("equation").asText(), null == mark ? "and" : mark.asText(), tConditionNode.get("condition").asText(), 0));
                arrayList.add(advanceSearchValueList);
                continue;
            }
            if (null != bracket && bracket.asText().equals("(")) {
                bracketOrder = 0;
                bracketJudge = true;
                advanceSearchValueList = new ArrayList();
            }
            advanceSearchValueList.add(new AdvanceSearchValue(tConditionNode.get("content").asText(), tConditionNode.get("equation").asText(), null == mark ? "and" : mark.asText(), tConditionNode.get("condition").asText(), bracketOrder));
            ++bracketOrder;
            if (null == bracket || !bracket.asText().equals(")")) continue;
            bracketOrder = 0;
            bracketJudge = false;
            arrayList.add(advanceSearchValueList);
        }
        if (null != tCategoryId && !StringUtil.isEmptyOrSpace((Object)tCategoryId.asText())) {
            advanceSearchValueList = new ArrayList();
            advanceSearchValueList.add(new AdvanceSearchValue(tCategoryId.asText(), "equal", "and", "apiCategory", 0));
            arrayList.add(advanceSearchValueList);
        }
        if (null != tStatusId && !StringUtil.isEmptyOrSpace((Object)tStatusId.asText())) {
            advanceSearchValueList = new ArrayList();
            advanceSearchValueList.add(new AdvanceSearchValue(tStatusId.asText(), "equal", "and", "apiStatus", 0));
            arrayList.add(advanceSearchValueList);
        }
        if (null != tType && tType.asBoolean() && null != tUserId) {
            advanceSearchValueList = new ArrayList();
            advanceSearchValueList.add(new AdvanceSearchValue(tUserId, "equal", "and", "userId", 0));
            arrayList.add(advanceSearchValueList);
        }
        if (null != projectId && !StringUtil.isEmptyOrSpace((Object)projectId.asText())) {
            advanceSearchValueList = new ArrayList();
            advanceSearchValueList.add(new AdvanceSearchValue(projectId.asText(), "equal", "and", "projectId", 0));
            arrayList.add(advanceSearchValueList);
        }
        if (null != projectVersionId && !StringUtil.isEmptyOrSpace((Object)projectVersionId.asText())) {
            advanceSearchValueList = new ArrayList();
            advanceSearchValueList.add(new AdvanceSearchValue(projectVersionId.asText(), "equal", "and", "projectVersionId", 0));
            advanceSearchValueList.add(new AdvanceSearchValue(null, "is", "or", "projectVersionId", 1));
            arrayList.add(advanceSearchValueList);
        }
        return arrayList;
    }
}

