package com.digiwin.athena.apimgmt.dao;

import com.digiwin.athena.apimgmt.model.ProjectVersion;

import java.util.List;
import java.util.Set;

public interface ApiMgmtProjectVersionDao extends GenericDao<ProjectVersion, Long> {

	List<ProjectVersion> getByProjectId(Long projectId);
	
	List<ProjectVersion> getByProjectVersionName(String projectVersionName);
	
	/**
	 * 根据项目版本名称列表进行批量查询
	 * @param projectVersionNames 项目版本名称列表
	 * @return 项目版本列表
	 */
	List<ProjectVersion> getByProjectVersionNames(List<String> projectVersionNames);

	List<ProjectVersion> getByProjectVersionNames(Long projectId, List<String> projectVersionNames);

	List<ProjectVersion> queryProjectVersionByIdList(List<Long> idList);

    List<ProjectVersion> selectByProjectIds(List<Long> projectIds);

    Integer deleteByIds(List<Long> projectVersionIds);

    /**
     * @implNote mysql未实现批量更新，而是插入&更新。可能会插入新数据。当前业务场景存在事务，先查后更，因此不会出现不存在插入。
     * 若需要严格batch update场景新建方法执行
     */
	void batchUpdate(List<ProjectVersion> updateVersionList);

	void deleteByProjectId(Long projectId);

	void batchSave(List<ProjectVersion> projectVersionList);

    Set<Long> selectExistProjectId(List<Long> projectIds);
}