package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.StandardApiMessageTypeConstants;
import com.digiwin.athena.apimgmt.dao.*;
import com.digiwin.athena.apimgmt.enums.*;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.*;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("esp")
public class ApiMgmtStandardApiSpecAnalyzeService extends AbstractService {

    @Autowired
    private ApiMgmtApprovedStatusDao approvedStatusDao;

    @Autowired
    private ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;

    @Autowired
    private ApiMgmtStandardApiGroupDao standardApiGroupDao;

    @Autowired
    private ApiMgmtStandardApiPagingDao standardApiPagingDao;

    @Autowired
    private ApiMgmtStandardApiCategoryDao standardApiCategoryDao;

    @Autowired
    private ApimgmtProductDao productDao;

    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    @Autowired
    private ApiMgmtProp prop;

    /**
     * esp扩展方法，放个性化配置，子类进行重写
     * @return
     */
    protected void setStandardApiExtend(List<Map<String, String>> tResult, StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale){
        //API名称格式校验
        String tApiName = pRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        pStandardApi.setName(tApiName);
        // 区分esp与openapi
        if (ApimgmtConstant.PATTERN_API_NAME.matcher(tApiName).matches()) {
            // 区分测试区与paas区的名称 防止重复
            if (prop.isEnvType()) {
                pStandardApi.setName(ApimgmtConstant.API_PAAS_REGEX + tApiName);
            } else {
                pStandardApi.setName(tApiName);
            }
        } else {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 2L, null, 0, 0, pLocale);
        }

        // 父类API名称
        if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString())
                && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText())) {
            pStandardApi.setParentApiName(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText());
            String parentApiTenantId = "";
            if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString())
                    && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()).asText())) {
                parentApiTenantId = pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()).asText();
            }
            pStandardApi.setParentApiTenantId(parentApiTenantId);

            String parentBranch = ApimgmtConstant.DEFAULT_BRANCH;
            if (StrUtil.isNotBlank(pStandardApi.getBranch())) {
                // 前端保存不传parentBranch，实际业务中父子api分支一致，不可修改
                parentBranch = pStandardApi.getBranch();
            }
            pStandardApi.setParentBranch(parentBranch);
        }

        pStandardApi.setRequestMethod(ApimgmtConstant.DEFAULT_REQUEST_METHOD);
    }

    public List<Map<String, String>> setStandardApi(StandardApi pStandardApi, JsonNode pRequestJsonNode,
                                                    String pLocale) throws Exception {
        List<Map<String, String>> tResult = new ArrayList<>();
        String tUserName = ApiMgmtServiceContextHolder.getUserName();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        StandardApiVersion tStandardApiVersion = new StandardApiVersion();
        tStandardApiVersion.setApprovedAcct(tUserId);
        tStandardApiVersion.setUserId(tUserId);
        pStandardApi.setBuildAcct(tUserId);

        // 项目
        long projectId = ObjectUtil.isNotNull(pRequestJsonNode.get(ApiAttributeEnum.projectId.toString())) ?
                pRequestJsonNode.get(ApiAttributeEnum.projectId.toString()).asLong() : ApimgmtConstant.DEFAULT_PROJECT;
        pStandardApi.setProjectId(projectId);
        // 项目版本
        String projectVersionStr = ObjectUtil.isNotNull(pRequestJsonNode.get(ApiAttributeEnum.projectVersionIdList.toString())) ?
                pRequestJsonNode.get(ApiAttributeEnum.projectVersionIdList.toString()).toString() : null;
        List<Long> projectVersionList = StringUtils.isNotEmpty(projectVersionStr) ? JSONArray.parseArray(projectVersionStr, Long.class) : null;
        // 处理成对象
        List<ProjectVersionRelation> projectVersionRelationList;
        if (CollectionUtil.isNotEmpty(projectVersionList)) {
            //处理成对象
            projectVersionRelationList = projectVersionList.stream().map(projectVersionId -> {
                ProjectVersionRelation projectVersionRelation = new ProjectVersionRelation();
                projectVersionRelation.setProjectId(projectId);
                projectVersionRelation.setProjectVersionId(projectVersionId);
                // 设置关联的StandardApi对象，这样在级联保存时能正确获取api_id
                projectVersionRelation.setStandardApi(pStandardApi);
                return projectVersionRelation;
            }).collect(Collectors.toList());
        } else {
            projectVersionRelationList = new ArrayList<>();
            ProjectVersionRelation projectRelation = new ProjectVersionRelation();
            projectRelation.setProjectId(projectId);
            // 设置关联的StandardApi对象，这样在级联保存时能正确获取api_id
            projectRelation.setStandardApi(pStandardApi);
            projectVersionRelationList.add(projectRelation);
        }
        
        // 设置新的关联关系
        pStandardApi.setProjectVersionRelations(projectVersionRelationList);

        // (1)服務名稱
        String tApiName = pRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        if (StringUtil.isEmptyOrSpace(tApiName)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 1L, null, 0, 0, pLocale);
        }
//        else {
//            pStandardApi.setName(tApiName);
//            // 区分esp与openapi
//            if (tApiName.matches(ApimgmtConstant.REGEX_API_NAME)) {
//                // 区分测试区与paas区的名称 防止重复
//                if (evnType) {
//                    pStandardApi.setName(ApimgmtConstant.API_PAAS_REGEX + tApiName);
//                } else {
//                    pStandardApi.setName(tApiName);
//                }
//            } else {
//                StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.APINAME_WRONG.toString(), 2L, null, 0, 0, pLocale);
//            }
//        }
//        // (1-1) 父类API名称
//        if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString())
//                && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText())) {
//            pStandardApi.setParentApiName(pRequestJsonNode.get(ApiAttributeEnum.parentApiName.toString()).asText());
//            String parentApiTenantId = "";
//            if (null != pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString())
//                    && !"null".equals(pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()).asText())) {
//                parentApiTenantId = pRequestJsonNode.get(ApiAttributeEnum.parentApiTenantId.toString()).asText();
//            }
//            pStandardApi.setParentApiTenantId(parentApiTenantId);
//        }
        // (2)服務說明(繁體)
        boolean tDescriptionZhTwEmpty = false;
        JsonNode tDescNode = pRequestJsonNode.get(ApiAttributeEnum.apiDescriptionMultilingual.toString());
        String tDescZhTw = tDescNode.get(ApimgmtConstant.ZH_TW).asText();
        if (StringUtil.isEmptyOrSpace(tDescZhTw)) {
            tDescriptionZhTwEmpty = true;
        } else {
            pStandardApi.setDescriptionZhTw(tDescZhTw.trim());
        }
        // (3)服務說明(簡體)
        boolean tDescriptionZhCnEmpty = false;
        String tDescZhCn = tDescNode.get(ApimgmtConstant.ZH_CN).asText();
        if (StringUtil.isEmptyOrSpace(tDescZhCn)) {
            tDescriptionZhCnEmpty = true;
        } else {
            pStandardApi.setDescriptionZhCn(tDescZhCn.trim());
        }
        // 如果服務說明(繁體)、服務說明(簡體)兩個都沒有填寫，才會顯示必要欄位沒有填寫
        if (tDescriptionZhTwEmpty && tDescriptionZhCnEmpty) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 3L, null, 0, 0, pLocale);
            // 如果服務說明(繁體)沒有填寫，用服務說明(簡體)翻譯的結果填入
        } else if (tDescriptionZhTwEmpty) {
            tDescZhTw = localeTranslate(tDescZhCn, LocaleEnum.ZH2HANT.getType());
            pStandardApi.setDescriptionZhTw(tDescZhTw.trim());
            // 如果服務說明(簡體)沒有填寫，用服務說明(繁體)翻譯的結果填入
        } else if (tDescriptionZhCnEmpty) {
            tDescZhCn = localeTranslate(tDescZhTw, LocaleEnum.ZH2HANS.getType());
            pStandardApi.setDescriptionZhCn(tDescZhCn.trim());
        }
        // (4)服務說明(英文)
        String tDescEnUs = tDescNode.get(ApimgmtConstant.EN_US).asText();
        if (StringUtil.isEmptyOrSpace(tDescEnUs)) {
            pStandardApi.setDescriptionEnUs(tDescZhTw.trim());
        } else {
            pStandardApi.setDescriptionEnUs(tDescEnUs.trim());
        }
        // (5)服務版本
        String tApiVersion = pRequestJsonNode.get(ApiAttributeEnum.apiVersion.toString()).asText().trim();
        if (StringUtil.isEmptyOrSpace(tApiVersion)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 5L, null, 0, 0, pLocale);
        } else {
            if (!tApiVersion.matches(ApimgmtConstant.REGEX_VERSION)) {
                StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 6L, null, 0, 0, pLocale);
            }
            pStandardApi.addStandardApiVersion(tStandardApiVersion);
            if (tApiVersion.endsWith(ApimgmtConstant.BRANCH_FIRST_API_VER)) {
                pStandardApi.setFirstApplicant(tUserName);
            }

            // API分支
            String branch = ApiVersionServiceUtil.getBranchFromVersion(tApiVersion);
            pStandardApi.setBranch(branch);

            tStandardApiVersion.setStandardApi(pStandardApi);
            tStandardApiVersion.setVersion(tApiVersion);
            tStandardApiVersion.setApplicant(tUserName);
            ApprovedStatus approvedStatus = approvedStatusDao.get(ApimgmtConstant.APPROVED_STATUS_DRAFT);
            tStandardApiVersion.setApprovedStatus(approvedStatus);
        }
        // (6)調用模式
        String tInvokeType = pRequestJsonNode.get(ApiAttributeEnum.invokeType.toString()).asText();
        StandardApiSyncType tStandardApiSyncType = null;
        if (tInvokeType.equals("sync")) {
            tStandardApiSyncType = standardApiSyncTypeDao.get(1L);
        } else if (tInvokeType.equals("fasync")) {
            tStandardApiSyncType = standardApiSyncTypeDao.get(2L);
        }
        pStandardApi.setStandardApiSyncType(tStandardApiSyncType);
        // (7)分頁模式
        long tPaging = pRequestJsonNode.get(ApiAttributeEnum.paging.toString()).asLong();
        // 「.get」才能使用「2.僅支持分頁」及「3.同時支持」
        if (pStandardApi.getApiType().equals(ApimgmtConstant.DEFAULT_API_TYPE) && !tApiName.endsWith(".get") && tPaging != 1) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.CAN_NOT_PAGING.toString(), 11L, null, 0, 0, pLocale);
        } else {
            StandardApiPaging tStandardApiPaging = standardApiPagingDao.get(tPaging);
            pStandardApi.setStandardApiPaging(tStandardApiPaging);
        }
        // (8)服務叫用方
        String tRequester = pRequestJsonNode.get(ApiAttributeEnum.requester.toString()).asText();
        if (StringUtil.isEmptyOrSpace(tRequester)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 12L, null, 0, 0, pLocale);
        } else {
            pStandardApi.setRequester(tRequester);
        }
        // (9)服務接收方
        String tProvider = pRequestJsonNode.get(ApiAttributeEnum.provider.toString()).asText();
        if (StringUtil.isEmptyOrSpace(tProvider)) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 13L, null, 0, 0, pLocale);
        } else {
            pStandardApi.setProvider(tProvider);
        }
        // (10)須分包
        boolean tIsBatch = pRequestJsonNode.get(ApiAttributeEnum.isBatch.toString()).asText().equals("Y");
        if (!tApiName.endsWith(".get") && tIsBatch) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.CAN_NOT_BATCH.toString(), 15L, null, 0, 0, pLocale);
        }
        pStandardApi.setIsBatch(tIsBatch);
        // (11)信息大類
        StandardApiGroup tStandardApiGroup = standardApiGroupDao.get(pRequestJsonNode.get(ApiAttributeEnum.group.toString()).asLong());
        pStandardApi.setStandardApiGroup(tStandardApiGroup);
        // (12)信息類別
        StandardApiCategory tStandardApiCategory = standardApiCategoryDao.get(pRequestJsonNode.get(ApiAttributeEnum.categoryId.toString()).asLong());
        pStandardApi.setStandardApiCategory(tStandardApiCategory);
        // (13)信息格式
        String tMsgFormat = pRequestJsonNode.get(ApiAttributeEnum.msgFormat.toString()).asText();
        pStandardApi.setMsgFormat(tMsgFormat);
        // (14)信息標籤(繁體)
        JsonNode tTagNode = pRequestJsonNode.get(ApiAttributeEnum.apiTagMultilingual.toString());
        String tTagZhTw = tTagNode.get(ApimgmtConstant.ZH_TW).asText().trim();
        if (!StringUtil.isEmptyOrSpace(tTagZhTw)) {
            pStandardApi.setTagZhTw(tTagZhTw);
        }
        // (15)信息標籤(簡體)
        String tTagZhCn = tTagNode.get(ApimgmtConstant.ZH_CN).asText().trim();
        if (!StringUtil.isEmptyOrSpace(tTagZhCn)) {
            pStandardApi.setTagZhCn(tTagZhCn);
        }
        // (16)信息標籤(英文)
        String tTagEnUs = tTagNode.get(ApimgmtConstant.EN_US).asText().trim();
        if (!StringUtil.isEmptyOrSpace(tTagEnUs)) {
            pStandardApi.setTagEnUs(tTagEnUs);
        } else {
            // 若無英文先放繁中
            pStandardApi.setTagEnUs(tTagZhTw);
        }
        // (17)備註(繁體)
        boolean tRemarkZhTWEmpty = false;
        JsonNode tRemarkNode = pRequestJsonNode.get(ApiAttributeEnum.apiRemarkMultilingual.toString());
        String tRemarkZhTw = tRemarkNode.get(ApimgmtConstant.ZH_TW).asText().trim();
        if (StringUtil.isEmptyOrSpace(tRemarkZhTw)) {
            tRemarkZhTWEmpty = true;
        } else {
            pStandardApi.setRemarkZhTw(tRemarkZhTw);
        }
        // (18)備註(簡體)
        boolean tRemarkZhCNEmpty = false;
        String tRemarkZhCn = tRemarkNode.get(ApimgmtConstant.ZH_CN).asText().trim();
        if (StringUtil.isEmptyOrSpace(tRemarkZhCn)) {
            tRemarkZhCNEmpty = true;
        } else {
            pStandardApi.setRemarkZhCn(tRemarkZhCn);
        }
        // 如果備註(繁體)、備註(簡體)兩個都沒有填寫，才會顯示必要欄位沒有填寫
        if (tRemarkZhTWEmpty && tRemarkZhCNEmpty) {
            StandardApiFileReadServiceUtil.uploadCheckResult(tResult, APIExportImportEnums.REQUIRED.toString(), 23L, null, 0, 0, pLocale);
            // 如果備註(繁體)沒有填寫，用備註(簡體)翻譯的結果填入
        } else if (tRemarkZhTWEmpty) {
            tRemarkZhTw = localeTranslate(tRemarkZhCn, LocaleEnum.ZH2HANT.getType());
            pStandardApi.setRemarkZhTw(tRemarkZhTw);
            // 如果備註(簡體)沒有填寫，用備註(繁體)翻譯的結果填入
        } else if (tRemarkZhCNEmpty) {
            tRemarkZhCn = localeTranslate(tRemarkZhTw, LocaleEnum.ZH2HANS.getType());
            pStandardApi.setRemarkZhCn(tRemarkZhCn);
        }
        // (19)備註(英文)
        String tRemarkEnUs = tRemarkNode.get(ApimgmtConstant.EN_US).asText().trim();
        if (!StringUtil.isEmptyOrSpace(tRemarkEnUs)) {
            pStandardApi.setRemarkEnUs(tRemarkEnUs);
        } else {
            pStandardApi.setRemarkEnUs(tRemarkZhTw);
        }
        // (20)租戶ID
        String tTenantId = null;
        if (pRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenantId = pRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        if (StringUtil.isEmptyOrSpace(tTenantId) || ApimgmtConstant.TENANT_ID_DEFAULT.equals(tTenantId)) {
            pStandardApi.setTenantId("");
        } else {
            pStandardApi.setTenantId(tTenantId);
        }
        // (21)修改自API
        String tPackageName = null;
        if (pRequestJsonNode.get(ApiAttributeEnum.packageName.toString()) != null) {
            tPackageName = pRequestJsonNode.get(ApiAttributeEnum.packageName.toString()).asText().trim();
        }
        if (!StringUtil.isEmptyOrSpace(tPackageName)) {
            pStandardApi.setPackageName(tPackageName);
        }
        // (22)是否符合冪等性
        boolean tIdempotency = pRequestJsonNode.get(ApiAttributeEnum.idempotency.toString()).asText().equals("Y");
        tStandardApiVersion.setIdempotency(tIdempotency);
        // (23)修改紀錄
        String tEditHistory = pRequestJsonNode.get(ApiAttributeEnum.editHistory.toString()).asText().trim();
        if (!StringUtil.isEmptyOrSpace(tEditHistory)) {
            tStandardApiVersion.setUpdateHistory(tEditHistory);
        }
        // (24)设计租户ID
        pStandardApi.setDesignTenantId(ApiMgmtServiceContextHolder.getTenantId());
        // (25)扩展字段
        JsonNode apiExtendNode = pRequestJsonNode.get(ApiAttributeEnum.apiExtend.toString());
        if (null != apiExtendNode) {
            pStandardApi.setApiExtend(mapper.writeValueAsString(apiExtendNode));
        }

        // 个性化配置校验
        setStandardApiExtend(tResult, pStandardApi, pRequestJsonNode, pLocale);
        return tResult;
    }

    public List<Map<String, String>> setStandardApiDataName(StandardApi pStandardApi, JsonNode pRequestJsonNode, Map<String, StandardApiDataName> pAddDataName, String pLocale) throws Exception {
        List<Map<String, String>> tResult = new ArrayList<>();
        ArrayNode tRequestSpecArrayNode = (ArrayNode) pRequestJsonNode.get(ApimgmtConstant.REQ_SPEC);
        ArrayNode tResponseSuccessSpecArrayNode = (ArrayNode) pRequestJsonNode.get(ApimgmtConstant.RES_SUCCESS_SPEC);
        ArrayNode tResponseFailSpecArrayNode = (ArrayNode) pRequestJsonNode.get(ApimgmtConstant.RES_FAIL_SPEC);
        List<String> productNameList = new ArrayList<>();
        setStandardApiDataNameByRow(tResult, pStandardApi, tRequestSpecArrayNode, pAddDataName, StandardApiMessageTypeConstants.REQUEST, null, pLocale, productNameList);
        setStandardApiDataNameByRow(tResult, pStandardApi, tResponseSuccessSpecArrayNode, pAddDataName, StandardApiMessageTypeConstants.RESPONSE_SUCCESS, null, pLocale, productNameList);
        setStandardApiDataNameByRow(tResult, pStandardApi, tResponseFailSpecArrayNode, pAddDataName, StandardApiMessageTypeConstants.RESPONSE_FAILED, null, pLocale, productNameList);
        return tResult;
    }

    private void setStandardApiDataNameByRow(List<Map<String, String>> pResult, StandardApi pStandardApi, ArrayNode pSpecArrayNode,
                                             Map<String, StandardApiDataName> pAddDataName, Integer pMsgType, StandardApiDataName pFatherStandardApiDataName,
                                             String pLocale, List<String> productNameList) throws Exception {
        if (pSpecArrayNode.isArray()) {
            for (JsonNode tNode : pSpecArrayNode) {
                StandardApiDataName tStandardApiDataName = new StandardApiDataName();
                // (0)is_businesskey
                boolean tIsBusinessKey = tNode.get(ApiAttributeEnum.isBusinessKey.toString()).asText().equals("Y");
                tStandardApiDataName.setIsBusinesskey(tIsBusinessKey);
                // (1)類型
                String tColumnType = tNode.get(ApiAttributeEnum.columnType.toString()).asText();
                if (StringUtil.isEmptyOrSpace(tColumnType)) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 24L, null, 0, 0, pLocale);
                } else {
                    try {
                        ColumnTypeEnum.valueOf(tColumnType.toUpperCase());
                    } catch (IllegalArgumentException e) {
                        if (!tColumnType.toUpperCase().matches(ApimgmtConstant.REGEX_COLUMN_TYPE_DETAIL_ALL)) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 24L, null, 0, 0, pLocale);
                        }
                    }
                    tStandardApiDataName.setColumnType(tColumnType);
                }
                // (4)辭彙代號
                String tDataName = tNode.get(ApiAttributeEnum.dataName.toString()).asText().trim();
                if (StringUtil.isEmptyOrSpace(tDataName)) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 27L, null, 0, 0, pLocale);
                } else {
                    tDataName = tDataName.replaceAll(ApimgmtConstant.SPACE, "");
                    // 檢查辭彙代號命名
                    if (StandardApiDataName.validateName(pStandardApi.getApiType(), tDataName)) {
                        tStandardApiDataName.setStandardDataName(tDataName);
                    } else {
                        Long solutionId = pStandardApi.isOpenApi() ? 3701L : 37L;
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), solutionId, tDataName, 0, 0, pLocale);
                    }
                }
                // (5)辭彙型態
                String tDataType = tNode.get(ApiAttributeEnum.dataType.toString()).asText();
                if (!Arrays.asList(ApimgmtConstant.ALLOW_ARRAY_COLUMN_TYPE).contains(tColumnType.toUpperCase()) && !tColumnType.toUpperCase().matches(ApimgmtConstant.REGEX_COLUMN_TYPE_DETAIL_HEADER)) {
                    if (StringUtil.isEmptyOrSpace(tDataType)) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 29L, tDataName, 0, 0, pLocale);
                    } else {
                        try {
                            DataTypeEnum.valueOf(tDataType.toUpperCase());
                        } catch (IllegalArgumentException e) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OR_CONTENT.toString(), 29L, tDataName, 0, 0, pLocale);
                        }
                        tStandardApiDataName.setDataType(tDataType.toLowerCase());
                    }
                }
                // (6)必要
                boolean tIsRequired = tNode.get(ApiAttributeEnum.isRequired.toString()).asText().equals(ApimgmtConstant.YES);
                tStandardApiDataName.setIsRequired(tIsRequired);
                // (7)為Datakey
                boolean tIsDatakey = tNode.get(ApiAttributeEnum.isDatakey.toString()).asText().equals(ApimgmtConstant.YES);
                tStandardApiDataName.setIsDatakey(tIsDatakey);
                // (8)為Array，只有M,D,SD,4D,5D...允許為array，若空值=false
                boolean tIsArray = tNode.get(ApiAttributeEnum.isArray.toString()).asText().equals(ApimgmtConstant.YES);
                tStandardApiDataName.setIsArray(tIsArray);
                // (9)可排序，只有P和F結尾才允許可排序，若空值=false
                boolean tCanSort = tNode.get(ApiAttributeEnum.canSort.toString()).asText().equals(ApimgmtConstant.YES);
                tStandardApiDataName.setCanSort(tCanSort);
                // (10)可过滤，只有P和F結尾才允許可过滤，若空值=false
                boolean tCanFilter = tNode.get(ApiAttributeEnum.canFilter.toString()).asText().equals(ApimgmtConstant.YES);
                tStandardApiDataName.setCanFilter(tCanFilter);
                // (11)說明(繁體)
                boolean tDescriptionZhTwEmpty = false;
                JsonNode tDataNameDescNode = tNode.get(ApiAttributeEnum.dataDescriptionMultilingual.toString());
                String tDataNameDescZhTw = tDataNameDescNode.get(ApimgmtConstant.ZH_TW).asText();
                if (StringUtil.isEmptyOrSpace(tDataNameDescZhTw)) {
                    tDescriptionZhTwEmpty = true;
                } else {
                    tStandardApiDataName.setDescriptionZhTw(tDataNameDescZhTw.trim());
                }
                // (12)說明(簡體)
                boolean tDescriptionZhCnEmpty = false;
                String tDataNameDescZhCn = tDataNameDescNode.get(ApimgmtConstant.ZH_CN).asText();
                if (StringUtil.isEmptyOrSpace(tDataNameDescZhCn)) {
                    tDescriptionZhCnEmpty = true;
                } else {
                    tStandardApiDataName.setDescriptionZhCn(tDataNameDescZhCn.trim());
                }
                // 如果服務說明(繁體)、服務說明(簡體)兩個都沒有填寫，才會顯示必要欄位沒有填寫
                if (tDescriptionZhTwEmpty && tDescriptionZhCnEmpty) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.REQUIRED.toString(), 31L, tDataName, 0, 0, pLocale);
                    // 如果服務說明(繁體)沒有填寫，用服務說明(簡體)翻譯的結果填入
                } else if (tDescriptionZhTwEmpty) {
                    tDataNameDescZhTw = localeTranslate(tDataNameDescZhCn, LocaleEnum.ZH2HANT.getType());
                    tStandardApiDataName.setDescriptionZhTw(tDataNameDescZhTw.trim());
                    // 如果服務說明(簡體)沒有填寫，用服務說明(繁體)翻譯的結果填入
                } else if (tDescriptionZhCnEmpty) {
                    tDataNameDescZhCn = localeTranslate(tDataNameDescZhTw, LocaleEnum.ZH2HANS.getType());
                    tStandardApiDataName.setDescriptionZhCn(tDataNameDescZhCn.trim());
                }
                // (13)說明(英文)
                String tDataNameDescEnUs = tDataNameDescNode.get(ApimgmtConstant.EN_US).asText();
                if (!StringUtil.isEmptyOrSpace(tDataNameDescEnUs)) {
                    tStandardApiDataName.setDescriptionEnUs(tDataNameDescEnUs.trim());
                } else {
                    tStandardApiDataName.setDescriptionEnUs(tDataName.replace("_", " "));
                }
                // (14)範例值
                String tValue = tNode.has(ApimgmtConstant.VALUE) ? tNode.get(ApimgmtConstant.VALUE).asText() : null;
                if (!StringUtil.isEmptyOrSpace(tValue)) {
                    tStandardApiDataName.setValue(tValue);
                }
                // (15)備註(繁體)
                boolean tRemarkZhTwEmpty = false;
                JsonNode tDataNameRemarkNode = tNode.get(ApiAttributeEnum.dataNameRemarkMultilingual.toString());
                String tDataNameRemarkZhTw = (tDataNameRemarkNode != null && tDataNameRemarkNode.has(ApimgmtConstant.ZH_TW)) ? tDataNameRemarkNode.get(ApimgmtConstant.ZH_TW).asText() : null;
                if (StringUtil.isEmptyOrSpace(tDataNameRemarkZhTw)) {
                    tRemarkZhTwEmpty = true;
                } else {
                    tStandardApiDataName.setRemarkZhTw(tDataNameRemarkZhTw.trim());
                }

                // (16)備註(簡體)
                boolean tRemarkZhCnEmpty = false;
                String tDataNameRemarkZhCn = (tDataNameRemarkNode != null && tDataNameRemarkNode.has(ApimgmtConstant.ZH_CN)) ? tDataNameRemarkNode.get(ApimgmtConstant.ZH_CN).asText() : null;
                if (StringUtil.isEmptyOrSpace(tDataNameRemarkZhCn)) {
                    tRemarkZhCnEmpty = true;
                } else {
                    tStandardApiDataName.setRemarkZhCn(tDataNameRemarkZhCn.trim());
                }
                if (tRemarkZhTwEmpty && !tRemarkZhCnEmpty) {
                    tDataNameRemarkZhTw = localeTranslate(tDataNameRemarkZhCn, LocaleEnum.ZH2HANT.getType());
                    tStandardApiDataName.setRemarkZhTw(tDataNameRemarkZhTw.trim());
                }
                if (tRemarkZhCnEmpty && !tRemarkZhTwEmpty) {
                    tDataNameRemarkZhCn = localeTranslate(tDataNameRemarkZhTw, LocaleEnum.ZH2HANS.getType());
                    tStandardApiDataName.setRemarkZhCn(tDataNameRemarkZhCn.trim());
                }
                // (17)備註(英文)
                String tDataNameRemarkEnUs = (tDataNameRemarkNode != null && tDataNameRemarkNode.has(ApimgmtConstant.EN_US)) ? tDataNameRemarkNode.get(ApimgmtConstant.EN_US).asText() : null;
                if (StringUtil.isEmptyOrSpace(tDataNameRemarkEnUs)) {
                    // 若無英文先放中文
                    tStandardApiDataName.setRemarkEnUs(tStandardApiDataName.getRemarkZhTw());
                } else {
                    tStandardApiDataName.setRemarkEnUs(tDataNameRemarkEnUs.trim());
                }
                // (18)列舉值(繁中)
                JsonNode tListEnumNode = tNode.get(ApiAttributeEnum.listEnumMultilingual.toString());
                String tListEnumZhTw = (tListEnumNode != null && tListEnumNode.has(ApimgmtConstant.ZH_TW)) ? tListEnumNode.get(ApimgmtConstant.ZH_TW).asText() : null;
                if (!StringUtil.isEmptyOrSpace(tListEnumZhTw)) {
                    tStandardApiDataName.setListEnumZhTw(tListEnumZhTw);
                }
                // (19)列舉值(簡中)
                String tListEnumZhCn = (tListEnumNode != null && tListEnumNode.has(ApimgmtConstant.ZH_CN)) ? tListEnumNode.get(ApimgmtConstant.ZH_CN).asText() : null;
                if (!StringUtil.isEmptyOrSpace(tListEnumZhCn)) {
                    tStandardApiDataName.setListEnumZhCn(tListEnumZhCn);
                }
                // (20)列舉值(英文)
                String tListEnumEn = (tListEnumNode != null && tListEnumNode.has(ApimgmtConstant.EN_US)) ? tListEnumNode.get(ApimgmtConstant.EN_US).asText() : null;
                if (!StringUtil.isEmptyOrSpace(tListEnumEn)) {
                    tStandardApiDataName.setListEnumEn(tListEnumEn);
                }
                // (21)修改紀錄
                String tEditHistory = tNode.has(ApiAttributeEnum.editHistory.toString()) ? tNode.get(ApiAttributeEnum.editHistory.toString()).asText().trim() : null;
                if (!StringUtil.isEmptyOrSpace(tEditHistory)) {
                    tStandardApiDataName.setUpdateHistory(tEditHistory);
                }
                // (22) 新增的产品精度配置
                JsonNode productPrecision = tNode.has(ApiAttributeEnum.productPrecision.toString()) ? tNode.get(ApiAttributeEnum.productPrecision.toString()) : null;
                if (null != productPrecision) {
                    for (Iterator<String> it = productPrecision.fieldNames(); it.hasNext(); ) {
                        String tProdName = it.next();
                        ProductApiDataName productApiDataName = new ProductApiDataName();
                        productApiDataName.setApiDataName(tStandardApiDataName);
                        tStandardApiDataName.addProductApiDataName(productApiDataName);
                        if (!productDao.exists(tProdName) && !productNameList.contains(tProdName)) {
                            productNameList.add(tProdName);
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INVALID_PROD_NAME.toString(), 33L, tDataName, 0, 0, pLocale);
                        } else {
                            Product tProduct = productDao.get(tProdName);
                            productApiDataName.setProduct(tProduct);
                            productApiDataName.setApiDataName(tStandardApiDataName);
                            tStandardApiDataName.addProductApiDataName(productApiDataName);
                        }
                        try {
                            if (null != productPrecision.get(tProdName) && !"null".equals(productPrecision.get(tProdName).asText())) {
                                if ("string".equals(tStandardApiDataName.getDataType())) {
                                    productApiDataName.setLength(productPrecision.get(tProdName).asInt());
                                } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                                    productApiDataName.setLength(Integer.parseInt(productPrecision.get(tProdName).asText().split(",")[0]));
                                    productApiDataName.setPrecision(Integer.parseInt(productPrecision.get(tProdName).asText().split(",")[1]));
                                } else {
                                    StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.CAN_NOT_INPUT_PRECISIONS.toString(), 36L, tDataName, 0, 0, pLocale);
                                }
                            }
                        } catch (NumberFormatException | ArrayIndexOutOfBoundsException ex) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.INCORRECT_FORMAT_OF_PRECISION.toString(), 34L, tDataName, 0, 0, pLocale);
                        }
                        if (StringUtil.isEmptyOrSpace(tProdName) && !productNameList.contains(tProdName)) {
                            // 沒有提供長度精度的產品名稱
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.NO_INPUT_PROD_NAME.toString(), 33L, tDataName, 0, 0, pLocale);
                            productNameList.add(tProdName);
                        }
                    }
                }
                // 沒有提供API版號就返回
                if (pStandardApi.getStandardApiVersions().size() == 0) {
                    return;
                }
                tStandardApiDataName.setStandardApiVersion(pStandardApi.getStandardApiVersions().get(0));
                tStandardApiDataName.setMsgType(pMsgType);
                tStandardApiDataName.setApiVer(ApimgmtConstant.API_VER);
                // 「類型」為E時須檢查字段名稱是否為code、sql_code、description
                if (tColumnType.equals(ColumnTypeEnum.E.toString())) {
                    if (!ArrayUtils.contains(ApimgmtConstant.COLUMN_TYPE_E_DATA_NAME, tDataName)) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.DATA_TYPE_WRONG.toString(), 35L, tDataName, 0, 0, pLocale);
                    }
                }
                String tFatherDataName;
                // 「類型」非P、M、E、H、Datakey時須檢查「所屬單頭/身」
                if (!ArrayUtils.contains(ApimgmtConstant.DATANAME_FATHER_UNREQUIRED, tColumnType.toUpperCase())) {
                    if (pFatherStandardApiDataName != null) {
                        for (StandardApiDataName tExistDataName : pFatherStandardApiDataName.getChildrens()) {
                            if (tDataName.equals(tExistDataName.getStandardDataName())) {
                                StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.DUPLICATE_DATANAME.toString(), 28L, tDataName, 0, 0, pLocale);
                            }
                        }
                        pFatherStandardApiDataName.addChildren(tStandardApiDataName);
                        tStandardApiDataName.setParent(pFatherStandardApiDataName);
                        tFatherDataName = pFatherStandardApiDataName.getStandardDataName();
                        pAddDataName.put(tColumnType + tDataName + pMsgType + tFatherDataName, tStandardApiDataName);
                    } else {
                        // 未找到對應的「所屬單頭/身」
                        StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.CAN_NOT_FIND_FATHER.toString(), 25L, tDataName, 0, 0, pLocale);
                    }
                } else {
                    // 檢查「類型」為Datakey、P、E、M、H，辭彙代號是否重複
                    if (tColumnType.toUpperCase().equals(ColumnTypeEnum.DATAKEY.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.P.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.E.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.M.toString()) || tColumnType.toUpperCase().equals(ColumnTypeEnum.H.toString())) {
                        StandardApiDataName tDataName2 = pAddDataName.get(tColumnType + tDataName + pMsgType);
                        if (tDataName2 != null) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(pResult, APIExportImportEnums.DUPLICATE_DATANAME.toString(), 28L, tDataName, 0, 0, pLocale);
                        }
                    }
                    pAddDataName.put(tColumnType + tDataName + pMsgType, tStandardApiDataName);
                    pStandardApi.getStandardApiVersions().get(0).addStandardApiDataName(tStandardApiDataName);
                }
                if (tNode.get(ApimgmtConstant.CHILDRENS) != null) {
                    ArrayNode tChildrensArrayNode = (ArrayNode) tNode.get(ApimgmtConstant.CHILDRENS);
                    setStandardApiDataNameByRow(pResult, pStandardApi, tChildrensArrayNode, pAddDataName, pMsgType, tStandardApiDataName, pLocale, productNameList);
                }
            }
        }
    }
}
