/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class WhereCondition {
    private Type type;
    private Operator operator;
    private String column;
    private Object val;
    private boolean isAnd = true;
    private List<WhereCondition> child;

    public static WhereCondition from(String column, Type type, AdvanceSearchValue item) {
        WhereCondition condition = new WhereCondition();
        condition.setColumn(column);
        condition.setType(type);
        condition.setVal(item.getContent());
        condition.setAnd(!"or".equalsIgnoreCase(item.getMark()));
        String operationStr = StrUtil.trimToEmpty((CharSequence)item.getEquation());
        condition.setOperator(Operator.ofOps(operationStr));
        if (condition.getOperator() == null) {
            condition.setOperator(Operator.EQ);
        }
        if (type == Type.MULTI_LANG) {
            return WhereCondition.buildMultiLang(condition);
        }
        if (type == Type.DATE) {
            return WhereCondition.buildDate(condition);
        }
        condition.convertAndSetVal();
        return condition;
    }

    public static WhereCondition buildDate(WhereCondition condition) {
        LocalDateTime datetime = (LocalDateTime)Convert.convert(LocalDateTime.class, (Object)condition.getVal());
        if (datetime == null) {
            return condition;
        }
        if (condition.getOperator() == Operator.LE) {
            condition.setOperator(Operator.LT);
            condition.setVal(datetime.plusSeconds(1L));
        } else if (condition.getOperator() == Operator.EQ) {
            WhereCondition begin = (WhereCondition)BeanUtil.copyProperties((Object)condition, WhereCondition.class, (String[])new String[0]);
            begin.setAnd(true);
            begin.setOperator(Operator.GE);
            begin.convertAndSetVal();
            WhereCondition end = (WhereCondition)BeanUtil.copyProperties((Object)begin, WhereCondition.class, (String[])new String[0]);
            end.setOperator(Operator.LT);
            end.convertAndSetVal(datetime.plusSeconds(1L));
            condition.setType(Type.SEGMENT);
            condition.setChild(ListUtil.of((Object[])new WhereCondition[]{begin, end}));
        } else if (condition.getOperator() == Operator.GT) {
            condition.setOperator(Operator.GE);
            condition.setVal(datetime.plusSeconds(1L));
        }
        return condition;
    }

    public static WhereCondition buildMultiLang(WhereCondition condition) {
        WhereCondition zh = (WhereCondition)BeanUtil.copyProperties((Object)condition, WhereCondition.class, (String[])new String[0]);
        zh.setAnd(false);
        zh.setColumn(zh.getColumn() + "_zh_cn");
        WhereCondition tw = (WhereCondition)BeanUtil.copyProperties((Object)zh, WhereCondition.class, (String[])new String[0]);
        tw.setColumn(zh.getColumn() + "_zh_tw");
        WhereCondition en = (WhereCondition)BeanUtil.copyProperties((Object)zh, WhereCondition.class, (String[])new String[0]);
        en.setColumn(zh.getColumn() + "_en_us");
        return WhereCondition.segment(condition.isAnd(), ListUtil.of((Object[])new WhereCondition[]{zh, tw, en}));
    }

    public static WhereCondition segment(boolean isAnd, List<WhereCondition> child) {
        WhereCondition condition = new WhereCondition();
        condition.setAnd(isAnd);
        condition.setType(Type.SEGMENT);
        condition.setChild(child);
        return condition;
    }

    public void convertAndSetVal() {
        this.convertAndSetVal(this.val);
    }

    public void convertAndSetVal(Object val) {
        if (this.type == Type.DATE && val instanceof String) {
            this.val = DateUtil.parseLocalDateTime((CharSequence)val.toString());
        } else if (this.operator == Operator.LIKE || this.operator == Operator.NOT_LIKE) {
            this.val = "%" + val + "%";
        }
    }

    public boolean notEmpty() {
        return ObjUtil.isNotEmpty((Object)this.val);
    }

    @Generated
    public WhereCondition() {
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Operator getOperator() {
        return this.operator;
    }

    @Generated
    public String getColumn() {
        return this.column;
    }

    @Generated
    public Object getVal() {
        return this.val;
    }

    @Generated
    public boolean isAnd() {
        return this.isAnd;
    }

    @Generated
    public List<WhereCondition> getChild() {
        return this.child;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Generated
    public void setColumn(String column) {
        this.column = column;
    }

    @Generated
    public void setVal(Object val) {
        this.val = val;
    }

    @Generated
    public void setAnd(boolean isAnd) {
        this.isAnd = isAnd;
    }

    @Generated
    public void setChild(List<WhereCondition> child) {
        this.child = child;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhereCondition)) {
            return false;
        }
        WhereCondition other = (WhereCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAnd() != other.isAnd()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Operator this$operator = this.getOperator();
        Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        Object this$val = this.getVal();
        Object other$val = other.getVal();
        if (this$val == null ? other$val != null : !this$val.equals(other$val)) {
            return false;
        }
        List<WhereCondition> this$child = this.getChild();
        List<WhereCondition> other$child = other.getChild();
        return !(this$child == null ? other$child != null : !((Object)this$child).equals(other$child));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WhereCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnd() ? 79 : 97);
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        Object $val = this.getVal();
        result = result * 59 + ($val == null ? 43 : $val.hashCode());
        List<WhereCondition> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WhereCondition(type=" + (Object)((Object)this.getType()) + ", operator=" + (Object)((Object)this.getOperator()) + ", column=" + this.getColumn() + ", val=" + this.getVal() + ", isAnd=" + this.isAnd() + ", child=" + this.getChild() + ")";
    }

    public static enum Type {
        IGNORE,
        SEGMENT,
        STRING,
        DATE,
        MULTI_LANG;

    }

    public static enum Operator {
        EQ("=", true, "EQ", "equal"),
        NE("!=", true, "NE"),
        GT(">", true, "GT"),
        LT("<", true, "LT"),
        GE(">=", true, "GE"),
        LE("<=", true, "LE"),
        LIKE("LIKE", true, new String[0]),
        NOT_LIKE("NOT LIKE", true, new String[0]),
        IN("IN", true, new String[0]),
        NOT_IN("NOT IN", true, new String[0]),
        IS_NULL("IS NULL", false, "is"),
        IS_NOT_NULL("IS NOT NULL", false, new String[0]);

        private final String[] expr;
        private final String op;
        private final boolean hasVal;

        private Operator(String op, boolean hasVal, String ... expr) {
            this.op = op;
            this.hasVal = hasVal;
            this.expr = expr;
        }

        public static Operator ofOps(String operationStr) {
            for (Operator op : Operator.values()) {
                if (op.op.equalsIgnoreCase(operationStr)) {
                    return op;
                }
                for (String expr : op.expr) {
                    if (!expr.equalsIgnoreCase(operationStr)) continue;
                    return op;
                }
            }
            return null;
        }

        @Generated
        public String getOp() {
            return this.op;
        }

        @Generated
        public boolean isHasVal() {
            return this.hasVal;
        }
    }
}

