/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.facade;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.apimgmt.facade.IApiInfoFacadeService;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiInfoFacadeService
implements IApiInfoFacadeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiInfoFacadeService.class);
    private final ApiMgmtStandardApiService standardApiService;

    @Override
    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) {
        return CollUtil.split(apiKeys, (int)100).stream().flatMap(subKeys -> {
            if (CollUtil.isEmpty((Collection)subKeys)) {
                return Stream.empty();
            }
            return this.standardApiService.queryByKey((List<ApiMgmtApiKeyDTO>)subKeys).stream();
        }).collect(Collectors.toList());
    }

    @Override
    public Map<ApiMgmtApiKeyDTO, ApiMgmtApiInfoDTO> queryApiInfoMapByKeys(List<ApiMgmtApiKeyDTO> apiKeys, boolean userTenant) {
        if (CollUtil.isEmpty(apiKeys)) {
            return Collections.emptyMap();
        }
        if (!userTenant) {
            apiKeys.forEach(v -> v.setTenantId(null));
        }
        List<ApiMgmtApiInfoDTO> apiInfoList = this.queryByKey(apiKeys);
        return this.transToKeyMap(apiInfoList, userTenant);
    }

    @NonNull
    protected Map<ApiMgmtApiKeyDTO, ApiMgmtApiInfoDTO> transToKeyMap(List<ApiMgmtApiInfoDTO> apiInfoList, boolean useTenant) {
        if (CollUtil.isEmpty(apiInfoList)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = MapUtil.newHashMap((int)(apiInfoList.size() * 2));
        for (ApiMgmtApiInfoDTO apiInfo : apiInfoList) {
            String apiName = apiInfo.getName();
            String tenantId = useTenant ? apiInfo.getTenantId() : null;
            String version = apiInfo.getVersion();
            ApiMgmtApiKeyDTO keyWithVersion = ApiMgmtApiKeyDTO.of(apiName, tenantId, version);
            resultMap.put(keyWithVersion, apiInfo);
            ApiMgmtApiKeyDTO keyWithoutVersion = ApiMgmtApiKeyDTO.of(apiName, tenantId);
            resultMap.put(keyWithoutVersion, apiInfo);
        }
        return resultMap;
    }

    @Override
    public String getProjectCode(Map<ApiMgmtApiKeyDTO, ApiMgmtApiInfoDTO> apiInfoMap, ApiMgmtApiKeyDTO key) {
        key.setTenantId(null);
        ApiMgmtApiInfoDTO apiInfo = apiInfoMap.get(key);
        if (apiInfo == null) {
            ApiMgmtApiKeyDTO keyWithoutVersion = ApiMgmtApiKeyDTO.ofName(key.getApiName());
            apiInfo = apiInfoMap.get(keyWithoutVersion);
        }
        return apiInfo != null ? apiInfo.getProjectCode() : null;
    }

    @Generated
    public ApiInfoFacadeService(ApiMgmtStandardApiService standardApiService) {
        this.standardApiService = standardApiService;
    }
}

