package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 取得API清單(狀態)
 * /restful/standard/apimgmt/ApiListByStatus/Get
 */
@Slf4j
@Service
@Deprecated
public class ApiListByStatusGetService {
	

	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
	
	public ApiListByStatusGetService(){
		super();
	}
	
	public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口：" +
				this.getClass() + "，原始訊息：" + validatorResult);
		ArrayList<Map<String, Object>> tResponse = new ArrayList<>();
		// 取得語系
		String tLocale = ApiMgmtServiceContextHolder.getLocale();
		// header沒傳語系的話，默認回傳英文
		tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
		String tUserId = ApiMgmtServiceContextHolder.getUserId();
		String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
		JsonNode tRequestJsonNode = JsonLoader.fromString(validatorResult);
		String tReqStatus = tRequestJsonNode.get(ApimgmtConstant.STATUS_ID).asText();
		boolean tIsVerifyAcct = false;
		if(!StringUtil.isEmptyOrSpace(tRequestJsonNode.get(ApimgmtConstant.VERIFY_ACCT).asText())){
			tIsVerifyAcct = true;
		}
		log.info("search start: " + tReqStatus  + "_" + tIsVerifyAcct);
		List<StandardApiVersion> tStandardApiVersionList = standardApiVersionDao.getByStatus(Long.valueOf(tReqStatus),
				tUserId, tTenantId, tIsVerifyAcct);
		log.info("tStandardApiVersionList: " + tStandardApiVersionList);
		if(tStandardApiVersionList != null){
			for(StandardApiVersion tStandardApiVersion : tStandardApiVersionList){
				StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
				Map<String, Object> tApiMap = new HashMap<>();
				String tApprovedStatus;
				String tDescription;
				String tRemark;
				String tSyncType;
				String tCategory;
				switch(tLocale){
				case ApimgmtConstant.ZH_CN:
					tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
					tDescription = tStandardApi.getDescriptionZhCn();
					tRemark = tStandardApi.getRemarkZhCn();
					tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
					tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
					break;
				case ApimgmtConstant.ZH_TW:
					tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
					tDescription = tStandardApi.getDescriptionZhTw();
					tRemark = tStandardApi.getRemarkZhTw();
					tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
					tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
					break;
				case ApimgmtConstant.EN_US:
				default:
					tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
					tDescription = tStandardApi.getDescriptionEnUs();
					tRemark = tStandardApi.getRemarkEnUs();
					tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
					tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
					break;
				}
				// 組成回傳訊息
				tApiMap.put(ApimgmtConstant.NAME, tStandardApi.getName());
				tApiMap.put(ApimgmtConstant.VERSION, tStandardApiVersion.getVersion());
				tApiMap.put(ApimgmtConstant.APPROVED_STATUS, tApprovedStatus);
				tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime(tStandardApiVersion.getApprovedTime()));
				tApiMap.put(ApimgmtConstant.DESCRIPTION, tDescription);
				tApiMap.put(ApimgmtConstant.REMARK, tRemark);
				tApiMap.put(ApimgmtConstant.SYNC_TYPE, tSyncType);
				tApiMap.put(ApimgmtConstant.CATEGORY_ID, tStandardApi.getStandardApiCategory().getId());
				tApiMap.put(ApimgmtConstant.CATEGORY_NAME, tCategory);
				tApiMap.put(ApimgmtConstant.MSG_FORMAT, tStandardApi.getMsgFormat());
				tApiMap.put(ApimgmtConstant.PROVIDER, tStandardApi.getProvider());
				tApiMap.put(ApimgmtConstant.TENANT_ID, tStandardApi.getTenantId());
				tApiMap.put(ApimgmtConstant.STATUS_ID, tStandardApiVersion.getApprovedStatus().getId());
				tResponse.add(tApiMap);
			}
		}
		return tResponse;
	}
}
