package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 同步MDC失败信息存贮表
 * 
 */
@TableName("sync_mdc_fail_data")
public class SyncMdcFailData implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键Id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;

	/**
	 * api版本
	 */
	@TableField("api_ver_id")
	private Long apiVerId;

	/**
	 * 同步环境
	 */
	@TableField("sync_factory")
	private String syncFactory;

	/**
	 * 同步是否成功标识
	 */
	@TableField("success_flag")
	private Boolean successFlag;

	/**
	 * 同步是否成功标识
	 */
	@TableField("build_time")
	private LocalDateTime buildTime;

	/**
	 * 同步是否成功标识
	 */
	@TableField("update_time")
	private LocalDateTime updateTime;

	public SyncMdcFailData() {
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getApiVerId() {
		return apiVerId;
	}

	public void setApiVerId(Long apiVerId) {
		this.apiVerId = apiVerId;
	}

	public String getSyncFactory() {
		return syncFactory;
	}

	public void setSyncFactory(String syncFactory) {
		this.syncFactory = syncFactory;
	}

	public Boolean getSuccessFlag() {
		return successFlag;
	}

	public void setSuccessFlag(Boolean successFlag) {
		this.successFlag = successFlag;
	}

	public LocalDateTime getBuildTime() {
		return buildTime;
	}

	public void setBuildTime(LocalDateTime buildTime) {
		this.buildTime = buildTime;
	}

	public LocalDateTime getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(LocalDateTime updateTime) {
		this.updateTime = updateTime;
	}
}