/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtJsonReqImportGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtJsonReqImportGetService.class);
    private static final Lock LOCK = new ReentrantLock(true);
    Long tId = 1L;

    public ApiMgmtJsonReqImportGetService() {
        this.jsonSchemaFileName = "json_req_import_get_schema.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, InterruptedException {
        JsonNode tParamJsonNode;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ArrayNode tResponseArrayNode = this.mapper.createArrayNode();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        JsonNode tExecutionJsonNode = null;
        if (tRequestJsonNode.has("std_data")) {
            tParamJsonNode = tRequestJsonNode.get("std_data").get("parameter");
            tExecutionJsonNode = tRequestJsonNode.get("std_data").get("execution");
        } else {
            tParamJsonNode = tRequestJsonNode;
        }
        StringBuilder tErrorString = new StringBuilder();
        LOCK.lock();
        try {
            this.resetId();
            if (tExecutionJsonNode != null) {
                this.analyzeJsonNode(tResponseArrayNode, tExecutionJsonNode);
            }
            this.analyzeJsonNode(tResponseArrayNode, tParamJsonNode, null, null, tErrorString);
        }
        finally {
            LOCK.unlock();
        }
        if (!StringUtil.isEmptyOrSpace((Object)tErrorString)) {
            tStateCode = this.getStateCode(ValidateStateEnum.JSON_CANNOT_HAS_NULL_OR_EMPTY.getCode());
            tDescription = tStateCode.getDescription();
        } else {
            tResponseNode.set("messageSpec", (JsonNode)tResponseArrayNode);
        }
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void resetId() {
        this.tId = 1L;
    }

    private void analyzeJsonNode(ArrayNode pResponseArrayNode, JsonNode pParamJsonNode) {
        List<String> tDataNameList = this.getJsonNodeKey(pParamJsonNode);
        for (String tDataName : tDataNameList) {
            ObjectNode tResponseObjectNode = this.mapper.createObjectNode();
            tResponseObjectNode.put("columnType", "E");
            tResponseObjectNode.put("id", this.tId);
            tResponseObjectNode.put("dataName", tDataName);
            tResponseObjectNode.put("dataType", "string");
            tResponseObjectNode.put("isArray", "N");
            tResponseObjectNode.put("isRequired", "N");
            tResponseObjectNode.put("canSort", "N");
            tResponseObjectNode.put("isBusinessKey", "N");
            tResponseObjectNode.put("isDatakey", "N");
            tResponseObjectNode.put("canFilter", "N");
            pResponseArrayNode.add((JsonNode)tResponseObjectNode);
            Long l = this.tId;
            this.tId = this.tId + 1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void analyzeJsonNode(ArrayNode pResponseArrayNode, JsonNode pParamJsonNode, Long pFatherId, String pFatherColumn, StringBuilder tErrorString) {
        List<String> tDataNameList = this.getJsonNodeKey(pParamJsonNode);
        Long tFatherId = pFatherId;
        boolean tHasChildrens = false;
        String tColumnType = "P";
        String tIsArray = null;
        String tDataType = null;
        if (pFatherColumn != null) {
            switch (pFatherColumn) {
                case "M": {
                    tColumnType = "MF";
                    break;
                }
                case "D": {
                    tColumnType = "DF";
                    break;
                }
                case "SD": {
                    tColumnType = "SDF";
                    break;
                }
                case "4D": {
                    tColumnType = "4DF";
                    break;
                }
                case "5D": {
                    tColumnType = "5DF";
                    break;
                }
                case "6D": {
                    tColumnType = "6DF";
                    break;
                }
                case "7D": {
                    tColumnType = "7DF";
                    break;
                }
                case "8D": {
                    tColumnType = "8DF";
                    break;
                }
                case "9D": {
                    tColumnType = "9DF";
                    break;
                }
            }
        }
        int tColumnIndex = Arrays.asList(ApimgmtConstant.COLUMN_TYPE_ARRAY_OLD).indexOf(tColumnType);
        String tNextColumn = ApimgmtConstant.COLUMN_TYPE_ARRAY_OLD[tColumnIndex + 1];
        Iterator<String> iterator = tDataNameList.iterator();
        while (true) {
            JsonNode tArrayColumnJsonNode;
            ObjectNode tResponseObjectNode;
            String tDataName;
            block33: {
                JsonNode tJsonNode;
                block34: {
                    block35: {
                        block32: {
                            if (!iterator.hasNext()) {
                                return;
                            }
                            tDataName = iterator.next();
                            tResponseObjectNode = this.mapper.createObjectNode();
                            tJsonNode = pParamJsonNode.get(tDataName);
                            tArrayColumnJsonNode = null;
                            if (tJsonNode.asText().equals("null")) {
                                tErrorString.append("ERROR");
                                continue;
                            }
                            if (!tJsonNode.isValueNode()) break block32;
                            tResponseObjectNode.put("columnType", tColumnType);
                            tIsArray = "N";
                            tHasChildrens = false;
                            tDataType = this.jsonNodeType(tJsonNode);
                            break block33;
                        }
                        if (!tJsonNode.isArray()) break block34;
                        ArrayNode tArrayNode = (ArrayNode)tJsonNode;
                        tArrayColumnJsonNode = tArrayNode.get(0);
                        if (tArrayColumnJsonNode == null) break block35;
                        if (tArrayColumnJsonNode.isValueNode()) {
                            tResponseObjectNode.put("columnType", tColumnType);
                            tIsArray = "N";
                            tHasChildrens = false;
                            tDataType = this.jsonNodeType(tJsonNode);
                            break block33;
                        } else if (tArrayColumnJsonNode.isObject()) {
                            tResponseObjectNode.put("columnType", tNextColumn);
                            tIsArray = "Y";
                            tHasChildrens = true;
                            tDataType = this.jsonNodeType(tJsonNode);
                        }
                        break block33;
                    }
                    tErrorString.append("ERROR");
                    continue;
                }
                if (tJsonNode.isObject()) {
                    tResponseObjectNode.put("columnType", tNextColumn);
                    tArrayColumnJsonNode = tJsonNode;
                    tIsArray = "N";
                    tHasChildrens = true;
                    tDataType = this.jsonNodeType(tJsonNode);
                }
            }
            String tColumn = tResponseObjectNode.get("columnType").asText();
            if (!Arrays.asList(ApimgmtConstant.DATANAME_FATHER_UNREQUIRED_OLD).contains(tColumn)) {
                tResponseObjectNode.put("parent", tFatherId);
            }
            if (Arrays.asList(ApimgmtConstant.ALLOW_ARRAY_COLUMN_TYPE_OLD).contains(tColumn)) {
                pFatherId = this.tId;
            }
            tResponseObjectNode.put("id", this.tId);
            tResponseObjectNode.put("dataName", tDataName);
            tResponseObjectNode.put("dataType", tDataType);
            tResponseObjectNode.put("isArray", tIsArray);
            tResponseObjectNode.put("isRequired", "N");
            tResponseObjectNode.put("canSort", "N");
            tResponseObjectNode.put("isBusinessKey", "N");
            tResponseObjectNode.put("isDatakey", "N");
            tResponseObjectNode.put("canFilter", "N");
            pResponseArrayNode.add((JsonNode)tResponseObjectNode);
            Long l = this.tId;
            this.tId = this.tId + 1L;
            if (!tHasChildrens) continue;
            this.analyzeJsonNode(pResponseArrayNode, tArrayColumnJsonNode, pFatherId, tNextColumn, tErrorString);
        }
    }

    private String jsonNodeType(JsonNode pJsonNode) {
        String tDataType = pJsonNode.isBoolean() ? "boolean" : (pJsonNode.isInt() ? "numeric" : (pJsonNode.isNumber() ? "numeric" : "string"));
        return tDataType;
    }

    private List<String> getJsonNodeKey(JsonNode pParamJsonNode) {
        Iterator nodes = pParamJsonNode.fields();
        ArrayList<String> tDataNameList = new ArrayList<String>();
        while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            tDataNameList.add((String)entry.getKey());
        }
        return tDataNameList;
    }
}

