package com.digiwin.athena.apimgmt.service.util;

import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * API版本处理类util
 */
@Service
public class ApiVersionServiceUtil extends GenericServiceUtil<ApiMgmtApiVersionService> {

	private static ApiMgmtApiVersionService service;

	@Override
	@Autowired
	public void setService(ApiMgmtApiVersionService pService) {
		service = pService;
	}
	
	public static String getPreviousVersion(String pVersion) {
		return service.getPreviousVersion(pVersion);
	}

	public static String getNextVersion(String pVersion) {
		return service.getNextVersion(pVersion);
	}

	public static Boolean judgeVersion(String pVersion) {
		return service.judgeVersion(pVersion);
	}
	
	public static StandardApiVersion getLatestVersion(List<StandardApiVersion> pStandardApiVersions) {
		return service.getLatestVersion(pStandardApiVersions);
	}

	/**
	 * 获取首次申请的版本
	 * by songwq 20230625 新增获取第一个版本
	 * 第一个版本一定是1.0版本
	 * @param pStandardApiVersions pStandardApiVersions
	 * @return StandardApiVersion
	 */
	public static StandardApiVersion getFirstVersion(List<StandardApiVersion> pStandardApiVersions) {
		return service.getFirstVersion(pStandardApiVersions);
	}

	/**
	 * 根据version获取对应的分支
	 * @param pVersion
	 * @return
	 */
	public static String getBranchFromVersion(String pVersion) {
		return service.getBranchFromVersion(pVersion);
	}

    /**
     * 获取上一个版本分支
     *
     * @return [2.0,2.9]=>1.0；[,1.0]=>null
     * @see ApiMgmtApiVersionService#getPrevBranchByVersion(String)
     */
    public static @Nullable String getPrevBranchByVersion(String version) {
        return service.getPrevBranchByVersion(version);
    }

    /**
     * @see ApiMgmtApiVersionService#getMajorVersion(String)
     */
    public static int getMajorVersion(String version) {
        return service.getMajorVersion(version);
    }
}
