/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.service.util;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiSpecAnalyzeService;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class StandardApiSpecAnalyzeServiceUtil
implements InitializingBean,
ApplicationContextAware {
    private static Map<String, ApiMgmtStandardApiSpecAnalyzeService> serviceMap;
    private static ApplicationContext applicationContext;

    public static List<Map<String, String>> setStandardApi(StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale) throws Exception {
        String apiType = ObjectUtil.isNotNull((Object)pRequestJsonNode.get(ApiAttributeEnum.apiType.toString())) ? pRequestJsonNode.get(ApiAttributeEnum.apiType.toString()).asText() : "esp";
        pStandardApi.setApiType(apiType);
        return StandardApiSpecAnalyzeServiceUtil.getService(apiType).setStandardApi(pStandardApi, pRequestJsonNode, pLocale);
    }

    public static List<Map<String, String>> setStandardApiDataName(StandardApi pStandardApi, JsonNode pRequestJsonNode, Map<String, StandardApiDataName> pAddDataName, String pLocale) throws Exception {
        String apiType = ObjectUtil.isNotNull((Object)pRequestJsonNode.get(ApiAttributeEnum.apiType.toString())) ? pRequestJsonNode.get(ApiAttributeEnum.apiType.toString()).asText() : "esp";
        return StandardApiSpecAnalyzeServiceUtil.getService(apiType).setStandardApiDataName(pStandardApi, pRequestJsonNode, pAddDataName, pLocale);
    }

    private static ApiMgmtStandardApiSpecAnalyzeService getService(String apiType) {
        return serviceMap.getOrDefault(apiType, serviceMap.get("esp"));
    }

    public void afterPropertiesSet() {
        Map services;
        serviceMap = services = applicationContext.getBeansOfType(ApiMgmtStandardApiSpecAnalyzeService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        StandardApiSpecAnalyzeServiceUtil.applicationContext = applicationContext;
    }
}

