/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.exception.TeamIdNotFindValidationException;
import com.digiwin.athena.apimgmt.exception.TenantInfoRetrievedException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.RequestOption;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtIamVerifyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtIamVerifyService.class);
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private ApiMgmtProp prop;

    public String getUserId(String pUserToken) throws Exception {
        Map<String, String> tResponse = this.getUserInfo(pUserToken);
        String tUserId = null;
        if (tResponse.get("userId") != null) {
            tUserId = tResponse.get("userId");
        }
        return tUserId;
    }

    public String getUserName(String pUserToken) throws Exception {
        Map<String, String> tResponse = this.getUserInfo(pUserToken);
        String tUserName = null;
        if (tResponse.get("name") != null) {
            tUserName = tResponse.get("name");
        }
        return tUserName;
    }

    public String getTenantId(String pUserToken) throws Exception {
        Map<String, String> tResponse = this.getUserInfo(pUserToken);
        String tTenantId = null;
        if (tResponse.get("tenantId") != null) {
            tTenantId = tResponse.get("tenantId");
        }
        return tTenantId;
    }

    public Map<String, String> getUserInfo(String pUserToken) throws Exception {
        HashMap<String, String> tResult = new HashMap<String, String>();
        JsonNode tResponseNode = this.analyzeToken(pUserToken);
        if (tResponseNode.get("tenantId") != null) {
            tResult.put("tenantId", tResponseNode.get("tenantId").asText());
        }
        if (tResponseNode.get("tenantName") != null) {
            tResult.put("tenantName", tResponseNode.get("tenantName").asText());
        }
        if (tResponseNode.get("id") != null) {
            tResult.put("userId", tResponseNode.get("id").asText());
        }
        if (tResponseNode.get("name") != null) {
            tResult.put("username", tResponseNode.get("name").asText());
        }
        return tResult;
    }

    public JsonNode analyzeToken(String pUserToken) throws Exception {
        try {
            String tDmcHost = this.prop.getIamUrl();
            String tUri = tDmcHost + "/api/iam/v2/identity/token/analyze";
            log.info("token: " + pUserToken + " tUri: " + tUri);
            HttpRequest tPost = HttpRequest.ofPost((String)tUri);
            RequestOption options = RequestOption.of().setTimeout(this.prop.getIamSocketTimeout());
            tPost.setHeader("Content-Type", (Object)"application/json;charset=UTF-8");
            tPost.setHeader("digi-middleware-auth-user", (Object)pUserToken);
            tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tPost.setHeader("token", (Object)pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            log.info("token: " + pUserToken + " tPost: " + tPost);
            String tResponse = (String)HttpUtil.execute((HttpRequest)tPost, String.class, (RequestOption)options);
            log.info("token: " + pUserToken + " tResponse: " + tResponse);
            return this.mapper.readTree(tResponse);
        }
        catch (Exception e) {
            if (e instanceof HttpFailedException) {
                int statusCode = ((HttpFailedException)e).getStatusCode();
                if (HttpStatus.UNAUTHORIZED.value() == statusCode) {
                    throw new TenantInfoRetrievedException("\u7528\u6237\u767b\u5f55\u8fc7\u671f\uff01", this.getClass());
                }
            }
            log.error("\u83b7\u53d6\u79df\u6237\u89e3\u6790\u5931\u8d25!token:" + pUserToken + e.getMessage(), (Throwable)e);
            throw new TenantInfoRetrievedException(e.getMessage(), this.getClass());
        }
    }

    public String getTeamId(String pUserToken) throws Exception {
        try {
            String tDmcHost = this.prop.getIamUrl();
            HttpRequest tGet = HttpRequest.ofGet((String)URLUtil.completeUrl((String)tDmcHost, (String)"/api/iam/v2/tenant/dev/current/info"));
            tGet.setHeader("Content-Type", (Object)"application/json;charset=UTF-8");
            tGet.setHeader("digi-middleware-auth-user", (Object)pUserToken);
            tGet.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tGet.setHeader("token", (Object)pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tGet.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            String tResponse = (String)HttpUtil.execute((HttpRequest)tGet, String.class);
            JsonNode tResponseNode = this.mapper.readTree(tResponse);
            String teamId = null;
            if (null != tResponseNode.get("data").get("teamId")) {
                teamId = tResponseNode.get("data").get("teamId").asText();
            }
            return teamId;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6teamId\u89e3\u6790\u5931\u8d25!token:" + pUserToken + e.getMessage(), (Throwable)e);
            throw new TeamIdNotFindValidationException("\u83b7\u53d6teamId\u89e3\u6790\u5931\u8d25:" + pUserToken, this.getClass());
        }
    }

    public String getIntegrationToken(String tenantId) {
        try {
            String tDmcHost = this.prop.getIamUrl();
            String tUri = URLUtil.completeUrl((String)tDmcHost, (String)"/api/iam/v2/identity/login/internal");
            log.info("getIntegrationToken url:" + tUri);
            HttpRequest tPost = HttpRequest.ofPost((String)tUri);
            RequestOption options = RequestOption.of().setTimeout(this.prop.getIamSocketTimeout());
            tPost.setHeader("Content-Type", (Object)"application/json;charset=UTF-8");
            tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("tenantId", tenantId);
            requestBody.put("userId", this.prop.getIntegrationUserId());
            requestBody.put("passwordHash", this.prop.getIntegrationPwd());
            tPost.setEntity(requestBody);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            String tResponse = (String)HttpUtil.execute((HttpRequest)tPost, String.class, (RequestOption)options);
            JSONObject responseObj = JSON.parseObject((String)tResponse);
            return responseObj.getString("token");
        }
        catch (Exception e) {
            log.error("getIntegrationToken:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u96c6\u6210token\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

